/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.sunfish;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.types.coord.LocationType;

public class VirtualDrifter
implements PropertiesProvider {
    @NeptusProperty
    public LocationType loc = new LocationType();
    @NeptusProperty
    public double headingDegrees;
    @NeptusProperty
    public double speedMps;
    @NeptusProperty
    public String id;
    protected double[] velocity;
    protected long startTime = System.currentTimeMillis();

    public VirtualDrifter(LocationType loc, double heading, double speed) {
        this.loc = loc;
        this.velocity = new double[2];
        this.speedMps = speed;
        this.headingDegrees = heading;
        this.velocity[0] = Math.cos(Math.toRadians(heading)) * speed;
        this.velocity[1] = Math.sin(Math.toRadians(heading)) * speed;
    }

    public LocationType getLocation() {
        LocationType curLoc = new LocationType(this.loc);
        double ellapsedTime = (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
        double movementx = this.velocity[0] * ellapsedTime;
        double movementy = this.velocity[1] * ellapsedTime;
        curLoc.translatePosition(movementx, movementy, 0.0);
        curLoc.convertToAbsoluteLatLonDepth();
        return curLoc;
    }

    public DefaultProperty[] getProperties() {
        return PluginUtils.getPluginProperties((Object)this);
    }

    public String getPropertiesDialogTitle() {
        return "Virtual Drifter Properties";
    }

    public String[] getPropertiesErrors(Property[] properties) {
        return null;
    }

    public void setProperties(Property[] properties) {
        PluginUtils.setPluginProperties((Object)this, (Property[])properties);
        this.velocity[0] = Math.cos(Math.toRadians(this.headingDegrees)) * this.speedMps;
        this.velocity[1] = Math.sin(Math.toRadians(this.headingDegrees)) * this.speedMps;
    }
}

