/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.sunfish.awareness;

import fr.cls.argos.dataxmldistribution.service.DixService;
import fr.cls.argos.dataxmldistribution.service.types.XmlRequestType;
import fr.cls.argos.dataxmldistribution.service.types.XsdRequestType;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.notifications.Notification;
import pt.lsts.neptus.data.Pair;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.sunfish.awareness.AssetPosition;
import pt.lsts.neptus.plugins.sunfish.awareness.ILocationProvider;
import pt.lsts.neptus.plugins.sunfish.awareness.SituationAwareness;
import pt.lsts.neptus.plugins.update.Periodic;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class ArgosLocationProvider
implements ILocationProvider {
    @NeptusProperty
    private String argosUsername = null;
    @NeptusProperty
    private String argosPassword = null;
    @NeptusProperty
    private String platformId = "136978";
    private boolean enabled = true;
    private boolean askCredentials = true;
    private SituationAwareness sitAwareness;

    public ArgosLocationProvider() {
        try {
            PluginUtils.loadProperties((String)"conf/argosCredentials.props", (Object)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getArgosUsername() {
        if (this.argosUsername == null) {
            return "";
        }
        return this.argosUsername;
    }

    private String getArgosPassword() {
        if (this.argosPassword == null) {
            return "";
        }
        return StringUtils.newStringUtf8((byte[])DatatypeConverter.parseBase64Binary((String)this.argosPassword));
    }

    private void setArgosPassword(String password) {
        if (password == null) {
            this.argosPassword = null;
        }
        this.argosPassword = DatatypeConverter.printBase64Binary((byte[])password.getBytes(Charset.forName("UTF8")));
    }

    private void setArgosUsername(String username) {
        if (username == null) {
            this.argosUsername = null;
        }
        this.argosUsername = username;
    }

    public String getXsd() throws Exception {
        DixService srv = new DixService();
        XsdRequestType request = new XsdRequestType();
        return srv.getDixServicePort().getXsd(request).getReturn();
    }

    @Periodic(millisBetweenUpdates=120000)
    public void updatePositions() {
        if (!this.enabled) {
            return;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            DixService srv = new DixService();
            XmlRequestType request = new XmlRequestType();
            if (this.askCredentials || this.argosPassword == null) {
                Pair credentials = GuiUtils.askCredentials((Component)ConfigFetch.getSuperParentFrame(), (String)"Enter Argos Credentials", (String)this.getArgosUsername(), (String)this.getArgosPassword());
                if (credentials == null) {
                    this.enabled = false;
                    return;
                }
                this.setArgosUsername((String)credentials.first());
                this.setArgosPassword((String)credentials.second());
                try {
                    PluginUtils.saveProperties((String)"conf/argosCredentials.props", (Object)this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                this.askCredentials = false;
            }
            request.setUsername(this.getArgosUsername());
            request.setPassword(this.getArgosPassword());
            request.setMostRecentPassages(true);
            request.setPlatformId(this.platformId);
            request.setNbDaysFromNow(10);
            String xml = srv.getDixServicePort().getXml(request).getReturn();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(xml.getBytes()));
            NodeList locations = doc.getElementsByTagName("location");
            for (int i = 0; i < locations.getLength(); ++i) {
                Node locNode = locations.item(i);
                Node platformNode = locNode.getParentNode().getParentNode();
                Node platfId = platformNode.getFirstChild();
                String id = platfId.getTextContent();
                NodeList childs = locNode.getChildNodes();
                String lat = null;
                String lon = null;
                String date = null;
                String locClass = null;
                block17: for (int j = 0; j < childs.getLength(); ++j) {
                    Node elem = childs.item(j);
                    switch (elem.getNodeName()) {
                        case "locationDate": {
                            date = elem.getTextContent();
                            continue block17;
                        }
                        case "latitude": {
                            lat = elem.getTextContent();
                            continue block17;
                        }
                        case "longitude": {
                            lon = elem.getTextContent();
                            continue block17;
                        }
                        case "locationClass": {
                            locClass = elem.getTextContent();
                            continue block17;
                        }
                    }
                }
                AssetPosition pos = new AssetPosition("Argos_" + id, Double.parseDouble(lat), Double.parseDouble(lon));
                pos.setSource(this.getName());
                pos.setType("Argos Tag");
                pos.putExtra("Loc. Class", locClass);
                pos.setTimestamp(df.parse(date.replaceAll("T", " ").replaceAll("Z", "")).getTime());
                if (this.sitAwareness == null) continue;
                this.sitAwareness.addAssetPosition(pos);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            NeptusLog.pub().error((Object)e);
            this.sitAwareness.postNotification(Notification.error((String)"Situation Awareness", (String)(e.getClass().getSimpleName() + " while polling ARGOS positions from Web.")).requireHumanAction(false));
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void onInit(SituationAwareness instance) {
        this.sitAwareness = instance;
    }

    @Override
    public void onCleanup() {
    }

    @Override
    public String getName() {
        return "ARGOS (Web Service)";
    }

    public static void main(String[] args) throws Exception {
        ArgosLocationProvider provider = new ArgosLocationProvider();
        provider.updatePositions();
    }
}

