/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.sunfish.awareness;

import java.util.Date;
import java.util.LinkedHashMap;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.DateTimeUtil;

public class AssetPosition
implements Comparable<AssetPosition> {
    private String assetName;
    private LocationType loc = null;
    private double yaw = Double.NaN;
    private double sog = Double.NaN;
    private long timestamp;
    private double accuracy = Double.NaN;
    private String source = "unknown";
    private String type = "Sensor";
    private LinkedHashMap<String, String> extraInfo = new LinkedHashMap();

    public AssetPosition(String asset, double latDegrees, double lonDegrees) {
        this.timestamp = System.currentTimeMillis();
        this.assetName = asset;
        this.loc = new LocationType(latDegrees, lonDegrees);
    }

    public String toString() {
        return this.assetName + "(" + new Date(this.timestamp) + ": " + this.loc + ")";
    }

    public String getAssetName() {
        return this.assetName;
    }

    public LocationType getLoc() {
        return this.loc;
    }

    public double getYaw() {
        return this.yaw;
    }

    public void setYaw(double yaw) {
        this.yaw = yaw;
    }

    public double getSog() {
        return this.sog;
    }

    public void setSog(double sog) {
        this.sog = sog;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(double accuracy) {
        this.accuracy = accuracy;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public long getAge() {
        return System.currentTimeMillis() - this.getTimestamp();
    }

    @Override
    public int compareTo(AssetPosition o) {
        return new Long(this.getTimestamp()).compareTo(o.getTimestamp());
    }

    public int hashCode() {
        return (this.assetName + "_" + this.getTimestamp() / 1000L).hashCode();
    }

    public void putExtra(String key, String value) {
        this.extraInfo.put(key, value);
    }

    public String getHtml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>").append("<table><tr><th colspan='2'>" + this.getAssetName() + "</th></tr>").append("<tr><td>Type:</td><td>" + this.getType() + "</td></tr>").append("<tr><td>Source:</td><td>" + this.getSource() + "</td></tr>").append("<tr><td>Timestamp:</td><td>" + new Date(this.getTimestamp()) + "</td></tr>").append("<tr><td>Age:</td><td>" + DateTimeUtil.milliSecondsToFormatedString((long)this.getAge()) + "</td></tr>").append("<tr><td>Location:</td><td>" + this.getLoc() + "</td></tr>");
        for (String key : this.extraInfo.keySet()) {
            sb.append("<tr><td>" + key + ":</td><td>" + this.extraInfo.get(key) + "</td></tr>");
        }
        sb.append("</table></html>");
        return sb.toString();
    }
}

