/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.sunfish.awareness;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import pt.lsts.neptus.plugins.sunfish.awareness.AssetPosition;
import pt.lsts.neptus.types.coord.LocationType;

public class AssetTrack {
    private String assetName = null;
    private String friendlyName = null;
    private ArrayList<AssetPosition> track = new ArrayList();
    private Color color;

    public AssetTrack(String assetName, Color color) {
        this.assetName = assetName;
        this.color = color;
    }

    public List<AssetPosition> getTrack() {
        return new ArrayList<AssetPosition>(this.track);
    }

    public List<AssetPosition> getTrack(int maxPositions, long sinceTimestamp) {
        List<AssetPosition> trackSince = this.getTrack();
        int count = 0;
        for (int i = trackSince.size() - 1; i >= 0; --i) {
            if (count == maxPositions || trackSince.get(i).getTimestamp() < sinceTimestamp) {
                if (i == trackSince.size() - 1) {
                    return new ArrayList<AssetPosition>();
                }
                return trackSince.subList(i + 1, trackSince.size());
            }
            ++count;
        }
        return trackSince;
    }

    public AssetPosition getLatest() {
        return this.track.get(this.track.size() - 1);
    }

    public AssetPosition getLatest(long beforeDate) {
        AssetPosition valid = null;
        for (AssetPosition p : this.getTrack()) {
            if (p.getTimestamp() > beforeDate) continue;
            valid = p;
        }
        return valid;
    }

    public AssetPosition getPrediction() {
        if (this.track.size() > 2) {
            AssetPosition last = this.getLatest();
            AssetPosition butLast = this.track.get(this.track.size() - 2);
            double timeDiff = (double)last.getTimestamp() / 1000.0 - (double)butLast.getTimestamp() / 1000.0;
            double dist = last.getLoc().getHorizontalDistanceInMeters(butLast.getLoc());
            double angle = butLast.getLoc().getXYAngle(last.getLoc());
            double speed = dist / timeDiff;
            double ellapsedTime = (double)last.getAge() / 1000.0;
            double offsetNorth = ellapsedTime * speed * Math.cos(angle);
            double offsetEast = ellapsedTime * speed * Math.sin(angle);
            LocationType loc = new LocationType(last.getLoc());
            loc.translatePosition(offsetNorth, offsetEast, 0.0).convertToAbsoluteLatLonDepth();
            return new AssetPosition(this.getAssetName(), loc.getLatitudeDegs(), loc.getLongitudeDegs());
        }
        return null;
    }

    public String getAssetName() {
        return this.assetName;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean addPosition(AssetPosition position) {
        if (!this.track.isEmpty()) {
            for (int i = 0; i < this.track.size(); ++i) {
                if (this.track.get(i).getTimestamp() == position.getTimestamp()) {
                    return false;
                }
                if (this.track.get(i).getTimestamp() <= position.getTimestamp()) continue;
                this.track.add(i, position);
                return true;
            }
        }
        this.track.add(position);
        return true;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }
}

