/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.sunfish.awareness;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import pt.lsts.neptus.mystate.MyState;
import pt.lsts.neptus.plugins.sunfish.awareness.AssetPosition;
import pt.lsts.neptus.util.DateTimeUtil;

public class DecisionSupportTable
extends AbstractTableModel {
    private static final long serialVersionUID = 1282602415878612300L;
    private double shipSpeed = 10.0;
    private double auvSpeed = 1.25;
    private double shipSafetyDistance = 3000.0;
    private final int colTagName = 0;
    private final int colDistAuv = 1;
    private final int colDistShip = 2;
    private final int colAuvTime = 3;
    private final int colAuvAndShipTime = 4;
    private final int colAge = 5;
    private final int colAccuracy = 6;
    private final int colResponseTime = 7;
    private ArrayList<AssetPosition> tags;
    private AssetPosition auv;

    public double getShipSpeed() {
        return this.shipSpeed;
    }

    public void setShipSpeed(double shipSpeed) {
        this.shipSpeed = shipSpeed;
        this.fireTableDataChanged();
    }

    public double getAuvSpeed() {
        return this.auvSpeed;
    }

    public void setAuvSpeed(double auvSpeed) {
        this.auvSpeed = auvSpeed;
        this.fireTableDataChanged();
    }

    public double getShipSafetyDistance() {
        return this.shipSafetyDistance;
    }

    public void setShipSafetyDistance(double shipSafetyDistance) {
        this.shipSafetyDistance = shipSafetyDistance;
        this.fireTableDataChanged();
    }

    public void setAssets(AssetPosition auv, List<AssetPosition> tags) {
        this.auv = auv;
        this.tags = new ArrayList<AssetPosition>(tags);
        this.fireTableStructureChanged();
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public int getRowCount() {
        return this.tags.size();
    }

    private long auvTime(AssetPosition tag) {
        double dist = tag.getLoc().getDistanceInMeters(this.auv.getLoc());
        return (long)(dist / this.auvSpeed * 1000.0);
    }

    private long shipAuvTime(AssetPosition tag) {
        double auvShipDist = this.auv.getLoc().getDistanceInMeters(MyState.getLocation());
        double auvTagDist = this.auv.getLoc().getDistanceInMeters(tag.getLoc());
        double time = auvShipDist / this.shipSpeed;
        auvTagDist -= this.shipSafetyDistance;
        auvTagDist = Math.min(this.shipSafetyDistance, auvTagDist);
        time += auvTagDist / this.shipSpeed;
        return (long)((time += this.shipSafetyDistance / this.auvSpeed) * 1000.0);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        AssetPosition tag = this.tags.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return tag.getAssetName();
            }
            case 1: {
                return new Distance(tag.getLoc().getDistanceInMeters(this.auv.getLoc()));
            }
            case 2: {
                return new Distance(tag.getLoc().getDistanceInMeters(MyState.getLocation()));
            }
            case 3: {
                return new EllapsedTime(this.auvTime(tag));
            }
            case 4: {
                return new EllapsedTime(this.shipAuvTime(tag));
            }
            case 5: {
                return new EllapsedTime(tag.getAge());
            }
            case 6: {
                return tag.getAccuracy();
            }
            case 7: {
                return new EllapsedTime(tag.getAge() + Math.min(this.auvTime(tag), this.shipAuvTime(tag)));
            }
        }
        return "?";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Distance.class;
            }
            case 2: {
                return Distance.class;
            }
            case 3: {
                return EllapsedTime.class;
            }
            case 4: {
                return EllapsedTime.class;
            }
            case 5: {
                return EllapsedTime.class;
            }
            case 6: {
                return String.class;
            }
            case 7: {
                return EllapsedTime.class;
            }
        }
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Tag";
            }
            case 1: {
                return "AUV Distance";
            }
            case 2: {
                return "Ship Distance";
            }
            case 3: {
                return "AUV ETA";
            }
            case 4: {
                return "AUV+Ship ETA";
            }
            case 5: {
                return "Age";
            }
            case 6: {
                return "Accuracy";
            }
            case 7: {
                return "Response Time";
            }
        }
        return "?";
    }

    class Distance
    implements Comparable<Distance> {
        Double distanceMeters;

        public Distance(double dist) {
            this.distanceMeters = dist;
        }

        @Override
        public int compareTo(Distance o) {
            return this.distanceMeters.compareTo(o.distanceMeters);
        }

        public String toString() {
            if (this.distanceMeters < 1000.0) {
                return String.format("%.2f m", this.distanceMeters);
            }
            return String.format("%.2f km", this.distanceMeters / 1000.0);
        }
    }

    class EllapsedTime
    implements Comparable<EllapsedTime> {
        private long time;

        public EllapsedTime(long time) {
            this.time = time;
        }

        public String toString() {
            return DateTimeUtil.milliSecondsToFormatedString((long)this.time);
        }

        @Override
        public int compareTo(EllapsedTime o) {
            return (int)(this.time - o.time);
        }
    }
}

