/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.sunfish.awareness;

import com.google.common.eventbus.Subscribe;
import com.google.gson.Gson;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import pt.lsts.imc.Announce;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.comm.iridium.DeviceUpdate;
import pt.lsts.neptus.comm.iridium.HubIridiumMessenger;
import pt.lsts.neptus.comm.iridium.Position;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.console.notifications.Notification;
import pt.lsts.neptus.mystate.MyState;
import pt.lsts.neptus.plugins.sunfish.awareness.AssetPosition;
import pt.lsts.neptus.plugins.sunfish.awareness.ILocationProvider;
import pt.lsts.neptus.plugins.sunfish.awareness.SituationAwareness;
import pt.lsts.neptus.plugins.update.Periodic;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.StringUtils;
import pt.lsts.neptus.util.conf.GeneralPreferences;

public class HubLocationProvider
implements ILocationProvider {
    SituationAwareness parent;
    private String systemsUrl = "http://hub.lsts.pt/api/v1/systems/active";
    private String iridiumUrl = "http://hub.lsts.pt/api/v1/iridium";
    LinkedHashMap<Integer, AssetPosition> positionsToSend = new LinkedHashMap();
    private boolean enabled = false;

    @Override
    public void onInit(SituationAwareness instance) {
        this.parent = instance;
        ImcMsgManager.registerBusListener((Object)this);
    }

    @Subscribe
    public void on(Announce announce) {
        if (announce.getLat() != 0.0 || announce.getLon() != 0.0) {
            AssetPosition pos = new AssetPosition(announce.getSysName(), Math.toDegrees(announce.getLat()), Math.toDegrees(announce.getLon()));
            this.positionsToSend.put(announce.getSrc(), pos);
        }
    }

    @Periodic(millisBetweenUpdates=180000)
    public void sendToHub() {
        if (!this.enabled) {
            return;
        }
        NeptusLog.pub().info((Object)"Uploading device updates to Hub...");
        LinkedHashMap<Integer, AssetPosition> toSend = new LinkedHashMap<Integer, AssetPosition>();
        LocationType myLoc = MyState.getLocation();
        AssetPosition myPos = new AssetPosition(StringUtils.toImcName((String)GeneralPreferences.imcCcuName), myLoc.getLatitudeDegs(), myLoc.getLongitudeDegs());
        toSend.put(ImcMsgManager.getManager().getLocalId().intValue(), myPos);
        toSend.putAll(this.positionsToSend);
        this.positionsToSend.clear();
        DeviceUpdate upd = new DeviceUpdate();
        upd.source = ImcMsgManager.getManager().getLocalId().intValue();
        upd.destination = 65535;
        for (Map.Entry pos : toSend.entrySet()) {
            Position p = new Position();
            p.id = (Integer)pos.getKey();
            p.latRads = ((AssetPosition)pos.getValue()).getLoc().getLatitudeRads();
            p.lonRads = ((AssetPosition)pos.getValue()).getLoc().getLongitudeRads();
            p.posType = Position.fromImcId((int)p.id);
            p.timestamp = (double)((AssetPosition)pos.getValue()).getTimestamp() / 1000.0;
            upd.getPositions().put(pos.getKey(), p);
        }
        for (Position p : upd.getPositions().values()) {
            NeptusLog.pub().info((Object)("Uploading position for " + p.id + ": " + Math.toDegrees(p.latRads) + "/" + Math.toDegrees(p.lonRads) + "/" + new Date((long)(1000.0 * p.timestamp))));
        }
        try {
            HttpPost postMethod = new HttpPost(this.iridiumUrl);
            postMethod.setHeader("Content-type", "application/hub");
            String data = new String(Hex.encodeHex((byte[])upd.serialize()));
            NeptusLog.pub().info((Object)("Sending '" + data + "'"));
            StringEntity ent = new StringEntity(data);
            postMethod.setEntity((HttpEntity)ent);
            DefaultHttpClient client = new DefaultHttpClient();
            HttpResponse response = client.execute((HttpUriRequest)postMethod);
            NeptusLog.pub().info((Object)("Sent " + upd.getPositions().size() + " device updates to Hub: " + response.getStatusLine().toString()));
            postMethod.abort();
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)"Error sending updates to hub", (Throwable)e);
            this.parent.postNotification(Notification.error((String)"Situation Awareness", (String)(e.getClass().getSimpleName() + " while trying to send device updates to HUB.")).requireHumanAction(false));
        }
    }

    @Periodic(millisBetweenUpdates=60000)
    public void pollActiveSystems() {
        if (!this.enabled) {
            return;
        }
        try {
            Gson gson = new Gson();
            URL url = new URL(this.systemsUrl);
            HubIridiumMessenger.HubSystemMsg[] msgs = (HubIridiumMessenger.HubSystemMsg[])gson.fromJson((Reader)new InputStreamReader(url.openStream()), HubIridiumMessenger.HubSystemMsg[].class);
            NeptusLog.pub().info((Object)(" through HTTP: " + this.systemsUrl));
            for (HubIridiumMessenger.HubSystemMsg m : msgs) {
                AssetPosition pos = new AssetPosition(m.name, m.coordinates[0], m.coordinates[1]);
                pos.setType(IMCUtils.getSystemType((int)m.imcid));
                pos.setTimestamp(HubIridiumMessenger.stringToDate((String)m.updated_at).getTime());
                pos.setSource(this.getName());
                if (pos.getAssetName().equals("hermes")) {
                    pos.setType("ASV");
                }
                if (!m.pos_error_class.isEmpty()) {
                    pos.putExtra("Loc. Class", m.pos_error_class);
                }
                this.parent.addAssetPosition(pos);
                NeptusLog.pub().info((Object)("Received HUB position update for " + m.name + ": " + pos.getLoc() + " @ " + new Date(pos.getTimestamp())));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            NeptusLog.pub().error((Object)e);
            this.parent.postNotification(Notification.error((String)"Situation Awareness", (String)(e.getClass().getSimpleName() + " while polling device updates from HUB.")).requireHumanAction(false));
        }
    }

    @Override
    public String getName() {
        return "HUB (Active Systems API)";
    }

    @Override
    public void onCleanup() {
        ImcMsgManager.unregisterBusListener((Object)this);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public static void main(String[] args) {
        SituationAwareness awareness = new SituationAwareness();
        awareness.updateMethods = "HUB (Active Systems API)";
        HubLocationProvider provider = new HubLocationProvider();
        provider.setEnabled(true);
        provider.onInit(awareness);
        provider.pollActiveSystems();
    }
}

