/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.sunfish.awareness;

import com.google.common.eventbus.Subscribe;
import pt.lsts.imc.Announce;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.RemoteSensorInfo;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.plugins.sunfish.awareness.AssetPosition;
import pt.lsts.neptus.plugins.sunfish.awareness.ILocationProvider;
import pt.lsts.neptus.plugins.sunfish.awareness.SituationAwareness;

public class ImcLocationProvider
implements ILocationProvider {
    private SituationAwareness instance;
    private boolean enabled = false;

    @Override
    public void onInit(SituationAwareness instance) {
        this.instance = instance;
        ImcMsgManager.registerBusListener((Object)this);
    }

    @Override
    public void onCleanup() {
        ImcMsgManager.unregisterBusListener((Object)this);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Subscribe
    public void on(Announce announce) {
        if (!this.enabled) {
            return;
        }
        AssetPosition pos = new AssetPosition(announce.getSysName(), Math.toDegrees(announce.getLat()), Math.toDegrees(announce.getLon()));
        pos.setSource(this.getName());
        switch (announce.getSysType()) {
            case STATICSENSOR: 
            case MOBILESENSOR: 
            case HUMANSENSOR: {
                pos.setType("Sensor");
                break;
            }
            default: {
                pos.setType(announce.getSysType().toString());
            }
        }
        pos.setSource("IMC (Announce)");
        this.instance.addAssetPosition(pos);
    }

    @Override
    public String getName() {
        return "IMC messages";
    }

    @Subscribe
    public void on(RemoteSensorInfo sensor) {
        try {
            if (!this.enabled) {
                return;
            }
            AssetPosition pos = new AssetPosition(sensor.getId(), Math.toDegrees(sensor.getLat()), Math.toDegrees(sensor.getLon()));
            pos.setTimestamp(sensor.getTimestampMillis());
            pos.setType(sensor.getSensorClass());
            if ("ais-1".equals(IMCDefinition.getInstance().getResolver().resolve(sensor.getSrc()))) {
                pos.setType("Ship");
                pos.setSource("AIS Receiver");
                if (!sensor.getSensorClass().isEmpty()) {
                    pos.putExtra("Ship Type", sensor.getSensorClass());
                }
            }
            this.instance.addAssetPosition(pos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

