/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.sunfish.awareness;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.plugins.sunfish.awareness.AssetPosition;

public class PositionHistory {
    private static final String positions_url = "http://hub.lsts.pt/api/v1/csvTag/";
    private static DateFormat fmt2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static void downloadCsv(String day, boolean force) throws Exception {
        File tmp = new File("positions/" + day);
        if (!force && tmp.exists()) {
            NeptusLog.pub().info((Object)("Downloading positions for day " + day + " not necessary."));
            return;
        }
        NeptusLog.pub().info((Object)("Downloading positions for day " + day + "..."));
        URL urlData = new URL(positions_url + day);
        FileUtils.copyURLToFile((URL)urlData, (File)tmp);
    }

    public static void downloadData() throws Exception {
        Date d = new Date();
        SimpleDateFormat dayFormat = new SimpleDateFormat("YYYY-MM-dd");
        PositionHistory.downloadCsv(dayFormat.format(d), true);
        for (int i = 0; i < 30; ++i) {
            d.setTime(d.getTime() - 86400000L);
            String day = dayFormat.format(d);
            if (i == 0) {
                PositionHistory.downloadCsv(day, true);
                continue;
            }
            PositionHistory.downloadCsv(day, false);
        }
    }

    public static Collection<AssetPosition> getHistory() throws Exception {
        try {
            PositionHistory.downloadData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Vector<AssetPosition> positions = new Vector<AssetPosition>();
        SimpleDateFormat dayFormat = new SimpleDateFormat("YYYY-MM-dd");
        Date current = new Date();
        Date d = new Date();
        for (int i = 30; i >= 0; --i) {
            String line;
            d.setTime(current.getTime() - (long)(i * 86400000));
            String day = dayFormat.format(d);
            PositionHistory.downloadCsv(day, false);
            BufferedReader reader = new BufferedReader(new FileReader("positions/" + day));
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split(",");
                if (parts.length < 4) continue;
                try {
                    Date time = fmt2.parse(parts[0]);
                    String id = parts[1].trim().toLowerCase();
                    double lat_degs = Double.parseDouble(parts[2].trim());
                    double lon_degs = Double.parseDouble(parts[3].trim());
                    AssetPosition position = new AssetPosition(id, lat_degs, lon_degs);
                    position.setTimestamp(time.getTime());
                    if (id.toLowerCase().startsWith("spot")) {
                        position.setType("Spot Tag");
                    } else if (id.toLowerCase().startsWith("argos")) {
                        position.setType("Argos Tag");
                    }
                    positions.add(position);
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)("Error parsing history line: " + line));
                }
            }
            reader.close();
        }
        return positions;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(PositionHistory.getHistory().size());
    }
}

