/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.sunfish.awareness;

import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JFileChooser;
import org.mozilla.javascript.edu.emory.mathcs.backport.java.util.Collections;
import pt.lsts.neptus.plugins.sunfish.awareness.AssetPosition;
import pt.lsts.neptus.plugins.sunfish.awareness.PositionHistory;
import pt.lsts.neptus.plugins.sunfish.awareness.SunfishAssetProperties;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;

public class PositionsToKml {
    public static void main(String[] args) throws Exception {
        Collection<SunfishAssetProperties.AssetDesc> props = new SunfishAssetProperties().fetchAssets();
        Collection<AssetPosition> history = PositionHistory.getHistory();
        LinkedHashMap tracks = new LinkedHashMap();
        LinkedHashMap<String, SunfishAssetProperties.AssetDesc> assetProperties = new LinkedHashMap<String, SunfishAssetProperties.AssetDesc>();
        for (SunfishAssetProperties.AssetDesc desc : props) {
            assetProperties.put(desc.name, desc);
        }
        for (AssetPosition p : history) {
            String name = p.getAssetName();
            if (!tracks.containsKey(name)) {
                tracks.put(name, new Vector());
            }
            ((Vector)tracks.get(name)).add(p);
        }
        for (Vector v : tracks.values()) {
            Collections.sort((List)v);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(PositionsToKml.prelude());
        for (String name : tracks.keySet()) {
            sb.append(PositionsToKml.track(name, (SunfishAssetProperties.AssetDesc)assetProperties.get(name), (Vector)tracks.get(name)));
        }
        sb.append(PositionsToKml.epilogue());
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Destination to save KML");
        chooser.setFileFilter(GuiUtils.getCustomFileFilter((String)"KML files", (String[])new String[]{"kml"}));
        int op = chooser.showSaveDialog(null);
        if (op == 0) {
            FileUtil.saveToFile((String)chooser.getSelectedFile().getAbsolutePath(), (String)sb.toString());
        }
    }

    private static String getColor(Color c) {
        return String.format("%02x", c.getAlpha()) + String.format("%02x", c.getBlue()) + String.format("%02x", c.getGreen()) + String.format("%02x", c.getRed());
    }

    private static String track(String name, SunfishAssetProperties.AssetDesc desc, Vector<AssetPosition> positions) {
        SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd'T'hh:mm:ss'Z'");
        StringBuilder b = new StringBuilder();
        String description = "";
        b.append("\t<Folder>\n");
        if (desc != null) {
            name = desc.friendly;
            description = desc.description;
            b.append("\t<name>" + desc.friendly + "</name>\n");
            b.append("\t<description>" + desc.description + "</description>\n");
        } else {
            b.append("\t<name>" + name + "</name>\n");
        }
        AssetPosition last = positions.lastElement();
        b.append("\t<Placemark>\n\t\t<name>" + name + "</name>\n" + "\t\t<description>" + description + "</description>\n" + "\t\t<Point>\n" + "\t\t<TimeStamp>" + sdf.format(new Date(last.getTimestamp())) + "</TimeStamp>\n" + "\t\t\t<coordinates>" + last.getLoc().getLongitudeDegs() + "," + last.getLoc().getLatitudeDegs() + "</coordinates>\n" + "\t\t</Point>\n" + "\t\t<Style>\n" + "\t\t\t<LineStyle>\n" + (desc == null ? "\t\t\t<color>ff33cc33</color>\n" : "\t\t\t<color>" + PositionsToKml.getColor(desc.color) + "</color>\n") + "\t\t\t<width>3</width>\n" + "\t\t\t</LineStyle>\n" + "\t\t</Style>\n");
        b.append("\t<LineString>\n\t<extrude>1</extrude>\n\t<tessellate>1</tessellate>\n\t<altitudeMode>absolute</altitudeMode>\n\t<coordinates>");
        boolean first = true;
        for (AssetPosition p : positions) {
            if (first) {
                b.append(p.getLoc().getLongitudeDegs() + "," + p.getLoc().getLatitudeDegs() + ",0");
                first = false;
                continue;
            }
            b.append("," + p.getLoc().getLongitudeDegs() + "," + p.getLoc().getLatitudeDegs() + ",0");
        }
        b.append("</coordinates>\n\t</LineString>\n\t</Placemark>\n");
        long lastTime = 0L;
        for (AssetPosition p : positions) {
            if (p.getTimestamp() - lastTime <= 3600000L) continue;
            b.append("\t\t\t<Placemark>\t\t\t<name>" + sdf.format(new Date(p.getTimestamp())) + "</name>\n" + "\t\t\t<description>Position @ " + sdf.format(new Date(p.getTimestamp())) + "</description>\n" + "\t\t\t<TimeStamp>" + sdf.format(new Date(p.getTimestamp())) + "</TimeStamp>\n" + "\t\t\t<Point>" + "\t\t\t<coordinates>" + p.getLoc().getLongitudeDegs() + "," + p.getLoc().getLatitudeDegs() + "</coordinates>\n" + "\t\t\t</Point>\n" + "\t\t\t</Placemark>");
            lastTime = p.getTimestamp();
        }
        b.append("\t</Folder>\n");
        return b.toString();
    }

    private static String prelude() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kml xmlns=\"http://www.opengis.net/kml/2.2\"> <Document>\n\t<name>Sunfish Tag positions</name>\n";
    }

    private static String epilogue() {
        return "</Document> </kml>\n";
    }
}

