/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.sunfish.awareness;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.mozilla.javascript.edu.emory.mathcs.backport.java.util.Collections;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.colormap.InterpolationColorMap;
import pt.lsts.neptus.console.ConsoleInteraction;
import pt.lsts.neptus.console.IConsoleLayer;
import pt.lsts.neptus.console.notifications.Notification;
import pt.lsts.neptus.console.plugins.planning.MapPanel;
import pt.lsts.neptus.gui.swing.RangeSlider;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.sunfish.awareness.AssetPosition;
import pt.lsts.neptus.plugins.sunfish.awareness.AssetTrack;
import pt.lsts.neptus.plugins.sunfish.awareness.DecisionSupportTable;
import pt.lsts.neptus.plugins.sunfish.awareness.ILocationProvider;
import pt.lsts.neptus.plugins.sunfish.awareness.PositionHistory;
import pt.lsts.neptus.plugins.sunfish.awareness.SunfishAssetProperties;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.plugins.update.Periodic;
import pt.lsts.neptus.plugins.update.PeriodicUpdatesService;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.speech.SpeechUtil;

@PluginDescription(name="Situation Awareness", icon="pt/lsts/neptus/plugins/sunfish/awareness/lamp.png")
@LayerPriority(priority=20)
public class SituationAwareness
extends ConsoleInteraction
implements IConsoleLayer,
Renderer2DPainter,
ConfigurationListener {
    private Random random = new Random();
    private LinkedHashMap<String, AssetTrack> assets = new LinkedHashMap();
    private Vector<ILocationProvider> localizers = new Vector();
    private Vector<IPeriodicUpdates> updaters = new Vector();
    private AssetPosition intercepted = null;
    private JDialog dialogDecisionSupport;
    private DecisionSupportTable supportTable = new DecisionSupportTable();
    private HashSet<String> updateMethodNames = new HashSet();
    private HashSet<String> hiddenPosTypes = new HashSet();
    private Image argos;
    private Image spot;
    private Image desired;
    private Image target;
    private Image unknown;
    private Image auv;
    private Image uav;
    private Image ship;
    private Image ccu;
    private Image wg;
    private SunfishAssetProperties props = new SunfishAssetProperties();
    private LinkedHashMap<String, SunfishAssetProperties.AssetDesc> assetProperties = new LinkedHashMap();
    private RangeSlider slider = new RangeSlider();
    private JLabel minTimeLabel = new JLabel("");
    private JLabel maxTimeLabel = new JLabel("");
    private SimpleDateFormat fmt = new SimpleDateFormat("MM-dd HH:mm");
    ColorMap cmap = ColorMapFactory.createRedYellowGreenColorMap();
    ColorMap cmap2 = new InterpolationColorMap("fading map", new double[]{0.0, 0.25, 0.5, 0.75, 1.0}, new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0), new Color(255, 0, 0), new Color(255, 255, 0), new Color(0, 255, 0)});
    private long oldestTimestamp = new Date().getTime();
    private long newestTimestamp = 0L;
    private long oldestTimestampSelection = new Date().getTime();
    private long newestTimestampSelection = 0L;
    @NeptusProperty(name="Ship speed (m/s)")
    public double shipSpeedMps = 10.0;
    @NeptusProperty(name="AUV speed (m/s)")
    public double uuvSpeedMps = 1.25;
    @NeptusProperty(name="Tag safety distance (meters)", description="Minimum distance the ship can be from the tag position")
    public double minDist = 3000.0;
    @NeptusProperty(name="Audible position updates")
    public boolean audibleUpdates = true;
    @NeptusProperty(name="Location sources", editable=false)
    public String updateMethods = "";
    @NeptusProperty(name="Hidden position types", editable=false)
    public String hiddenTypes = "";
    @NeptusProperty(name="Paint labels")
    public boolean paintLabels = true;
    @NeptusProperty(name="Paint icons")
    public boolean paintIcons = false;
    private long minDate = new Date().getTime() - 1872000000L;
    private JLabel lbl = new JLabel();

    void postNotification(Notification notification) {
        this.getConsole().post((Object)notification);
    }

    private void loadImages() {
        this.spot = ImageUtils.getImage((String)"pt/lsts/neptus/plugins/sunfish/spot.png");
        this.desired = ImageUtils.getImage((String)"pt/lsts/neptus/plugins/sunfish/desired.png");
        this.target = ImageUtils.getImage((String)"pt/lsts/neptus/plugins/sunfish/target.png");
        this.unknown = ImageUtils.getImage((String)"pt/lsts/neptus/plugins/sunfish/unknown.png");
        this.auv = ImageUtils.getImage((String)"pt/lsts/neptus/plugins/sunfish/auv.png");
        this.uav = ImageUtils.getImage((String)"pt/lsts/neptus/plugins/sunfish/uav.png");
        this.ship = ImageUtils.getImage((String)"pt/lsts/neptus/plugins/sunfish/ship.png");
        this.ccu = ImageUtils.getImage((String)"pt/lsts/neptus/plugins/sunfish/ccu.png");
        this.argos = ImageUtils.getImage((String)"pt/lsts/neptus/plugins/sunfish/argos.png");
        this.wg = ImageUtils.getImage((String)"pt/lsts/neptus/plugins/sunfish/wg.png");
    }

    @Periodic
    public void fetchAssetProperties() {
        NeptusLog.pub().info((Object)"Fetching asset properties");
        for (SunfishAssetProperties.AssetDesc a : this.props.fetchAssets()) {
            this.assetProperties.put(a.name, a);
        }
    }

    public void initInteraction() {
        Reflections reflections = new Reflections(((Object)((Object)this)).getClass().getPackage().getName(), new Scanner[0]);
        for (Class c : reflections.getSubTypesOf(ILocationProvider.class)) {
            try {
                ILocationProvider localizer = (ILocationProvider)c.newInstance();
                this.updaters.addAll(PeriodicUpdatesService.inspect((Object)localizer));
                localizer.onInit(this);
                this.localizers.add(localizer);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        }
        for (IPeriodicUpdates upd : this.updaters) {
            PeriodicUpdatesService.register((IPeriodicUpdates)upd);
        }
        if (this.getConsole() != null) {
            for (MapPanel map : this.getConsole().getSubPanelsOfClass(MapPanel.class)) {
                map.addLayer((IConsoleLayer)this);
            }
        }
        this.loadImages();
        this.propertiesChanged();
        Thread t = new Thread("Asset Properties Loader"){

            @Override
            public void run() {
                SituationAwareness.this.fetchAssetProperties();
                try {
                    Collection<AssetPosition> dailyPositions = PositionHistory.getHistory();
                    for (AssetPosition p : dailyPositions) {
                        p.setSource("Daily Positions CSV");
                        SituationAwareness.this.addAssetPosition(p);
                    }
                    SituationAwareness.this.slider.setValue(SituationAwareness.this.slider.getUpperValue() - 86400);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.setDaemon(true);
        t.start();
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SituationAwareness.this.minTimeLabel.setText(SituationAwareness.this.fmt.format(new Date((long)SituationAwareness.this.slider.getValue() * 1000L)));
                SituationAwareness.this.maxTimeLabel.setText(SituationAwareness.this.fmt.format(new Date((long)SituationAwareness.this.slider.getUpperValue() * 1000L)));
                SituationAwareness.this.oldestTimestampSelection = (long)SituationAwareness.this.slider.getValue() * 1000L;
                SituationAwareness.this.newestTimestampSelection = (long)(SituationAwareness.this.slider.getValue() + SituationAwareness.this.slider.getExtent()) * 1000L;
                if (SituationAwareness.this.slider.getUpperValue() - SituationAwareness.this.slider.getValue() < 3600) {
                    SituationAwareness.this.slider.setUpperValue(Math.min(SituationAwareness.this.slider.getMaximum(), SituationAwareness.this.slider.getValue() + 3600));
                }
            }
        });
    }

    public void propertiesChanged() {
        this.updateMethodNames.clear();
        for (String s : this.updateMethods.split("\\s*,\\s*")) {
            this.updateMethodNames.add(s);
        }
        this.hiddenPosTypes.clear();
        for (String s : this.hiddenTypes.split("\\s*,\\s*")) {
            this.hiddenPosTypes.add(s);
        }
        for (ILocationProvider prov : this.localizers) {
            prov.setEnabled(this.updateMethodNames.contains(prov.getName()));
        }
        this.supportTable.setShipSpeed(this.shipSpeedMps);
        this.supportTable.setAuvSpeed(this.uuvSpeedMps);
    }

    public void addAssetPosition(AssetPosition pos) {
        boolean newPos;
        AssetTrack track;
        String asset;
        if (pos.getTimestamp() < this.oldestTimestamp && pos.getTimestamp() > this.minDate) {
            this.oldestTimestamp = pos.getTimestamp();
            this.slider.setMinimum((int)(this.oldestTimestamp / 1000L));
            this.minTimeLabel.setText(this.fmt.format(new Date(this.oldestTimestamp)));
        }
        if (pos.getTimestamp() > this.newestTimestamp) {
            this.newestTimestampSelection = this.newestTimestamp = pos.getTimestamp();
            this.slider.setMaximum((int)(this.newestTimestamp / 1000L));
            this.maxTimeLabel.setText(this.fmt.format(new Date(this.newestTimestamp)));
            this.slider.setUpperValue((int)(this.newestTimestamp / 1000L));
        }
        if (!this.assets.containsKey(asset = pos.getAssetName())) {
            track = new AssetTrack(asset, new Color(this.random.nextInt(255), this.random.nextInt(255), this.random.nextInt(255)));
            this.assets.put(asset, track);
        }
        if ((newPos = (track = this.assets.get(asset)).addPosition(pos)) && (track.getLatest() == null || track.getLatest().getAge() > 30000L)) {
            if (this.getConsole() != null) {
                this.getConsole().post((Object)Notification.info((String)"New Position", (String)("Received position for " + pos.getAssetName())));
            }
            if (this.audibleUpdates && pos.getTimestamp() > this.oldestTimestamp) {
                SpeechUtil.readSimpleText((String)(track.getAssetName() + " has been updated"));
            }
        }
        if (newPos) {
            this.logPosition(pos);
        }
    }

    private void logPosition(AssetPosition pos) {
    }

    public void setAssetColor(String assetName, Color c) {
        if (this.assets.containsKey(assetName)) {
            this.assets.get(assetName).setColor(c);
        }
    }

    public void cleanInteraction() {
        for (ILocationProvider localizer : this.localizers) {
            localizer.onCleanup();
        }
        for (IPeriodicUpdates upd : this.updaters) {
            PeriodicUpdatesService.unregister((IPeriodicUpdates)upd);
        }
    }

    public static void main(String[] args) throws Exception {
        SituationAwareness aware = new SituationAwareness();
        aware.initInteraction();
        Thread.sleep(100000L);
    }

    public void paintIcons(Graphics2D g, StateRenderer2D renderer) {
        for (AssetTrack track : this.assets.values()) {
            AssetPosition p = track.getLatest(this.newestTimestampSelection);
            if (p == null || this.hiddenPosTypes.contains(p.getType()) || p.getTimestamp() < this.oldestTimestampSelection || p.getTimestamp() > this.newestTimestampSelection) continue;
            Point2D pt = renderer.getScreenPosition(p.getLoc());
            Image img = this.getIcon(p);
            if (img == null) continue;
            g.drawImage(img, (int)(pt.getX() - 8.0), (int)(pt.getY() - 8.0), (int)(pt.getX() + 8.0), (int)(pt.getY() + 8.0), 0, 0, img.getWidth(null), img.getHeight(null), null);
        }
    }

    public Image getIcon(AssetPosition pos) {
        if (pos.getAssetName().equals("hermes")) {
            return this.wg;
        }
        switch (pos.getType().toLowerCase()) {
            case "ship": {
                return this.ship;
            }
            case "uuv": 
            case "auv": {
                return this.auv;
            }
            case "uav": {
                return this.uav;
            }
            case "ccu": {
                return this.ccu;
            }
            case "argos tag": {
                return this.argos;
            }
            case "spot tag": {
                return this.spot;
            }
            case "desired position": {
                return this.desired;
            }
            case "target position": {
                return this.target;
            }
        }
        return this.unknown;
    }

    public void paintLabels(Graphics2D g, StateRenderer2D renderer) {
        g.setFont(new Font("Arial", 0, 11));
        for (AssetTrack track : this.assets.values()) {
            AssetPosition p = track.getLatest(this.newestTimestampSelection);
            if (p == null || this.hiddenPosTypes.contains(p.getType()) || p.getTimestamp() < this.oldestTimestampSelection || p.getTimestamp() > this.newestTimestampSelection) continue;
            Point2D pt = renderer.getScreenPosition(p.getLoc());
            g.setColor(track.getColor());
            g.setColor(Color.black);
            String name = p.getAssetName();
            g.drawString(name + " (" + DateTimeUtil.milliSecondsToFormatedString((long)(System.currentTimeMillis() - p.getTimestamp())) + ")", (int)(pt.getX() + 13.0), (int)(pt.getY() + 5.0));
        }
    }

    public void paintInteraction(Graphics2D g, StateRenderer2D source) {
        super.paintInteraction(g, source);
        g.setStroke(new BasicStroke(1.0f));
        this.paint(g, source);
        AssetPosition pivot = this.intercepted;
        if (pivot != null) {
            Point2D pt = source.getScreenPosition(pivot.getLoc());
            g.setColor(Color.white);
            g.draw(new Ellipse2D.Double(pt.getX() - 6.0, pt.getY() - 6.0, 12.0, 12.0));
            if (this.assetProperties.containsKey(pivot.getAssetName())) {
                pivot.putExtra("Description", this.assetProperties.get((Object)pivot.getAssetName()).description);
            }
            if (this.assetProperties.containsKey(pivot.getAssetName())) {
                pivot.putExtra("Friendly name", this.assetProperties.get((Object)pivot.getAssetName()).friendly);
            }
            this.lbl.setOpaque(true);
            this.lbl.setBackground(new Color(255, 255, 255, 128));
            this.lbl.setText(pivot.getHtml());
            Dimension d = this.lbl.getPreferredSize();
            this.lbl.setSize(d);
            Graphics copy = g.create();
            copy.translate(10, 10);
            this.lbl.paint(copy);
        }
        for (AssetTrack t : this.assets.values()) {
            Point2D pt2;
            AssetPosition prev = t.getLatest();
            AssetPosition pred = t.getPrediction();
            if (prev == null || pred == null || prev.getTimestamp() < this.oldestTimestampSelection || prev.getTimestamp() > this.newestTimestampSelection) continue;
            g.setColor(new Color(t.getColor().getRed(), t.getColor().getGreen(), t.getColor().getBlue(), 128));
            Point2D pt1 = source.getScreenPosition(prev.getLoc());
            if (!(pt1.distance(pt2 = source.getScreenPosition(pred.getLoc())) < 1000.0)) continue;
            g.draw(new Line2D.Double(pt1, pt2));
        }
    }

    private String getAge(AssetPosition position) {
        return DateTimeUtil.milliSecondsToFormatedString((long)(System.currentTimeMillis() - position.getTimestamp()));
    }

    private LinkedHashMap<String, Vector<AssetPosition>> positionsByType() {
        LinkedHashMap<String, Vector<AssetPosition>> ret = new LinkedHashMap<String, Vector<AssetPosition>>();
        for (AssetTrack t : this.assets.values()) {
            AssetPosition last = t.getLatest();
            if (!ret.containsKey(last.getType())) {
                ret.put(last.getType(), new Vector());
            }
            ret.get(last.getType()).add(last);
        }
        return ret;
    }

    public void mouseClicked(MouseEvent event, final StateRenderer2D source) {
        if (event.getButton() == 3) {
            final LinkedHashMap<String, Vector<AssetPosition>> positions = this.positionsByType();
            JPopupMenu popup = new JPopupMenu();
            for (String type : positions.keySet()) {
                JMenu menu = new JMenu(type + "s");
                for (final AssetPosition p : positions.get(type)) {
                    if (p.getTimestamp() < this.oldestTimestampSelection || p.getTimestamp() > this.newestTimestampSelection) continue;
                    Color c = this.cmap.getColor(1.0 - (double)p.getAge() / 7200000.0);
                    String htmlColor = String.format("#%02X%02X%02X", c.getRed(), c.getGreen(), c.getBlue());
                    menu.add("<html><b>" + p.getAssetName() + "</b> <font color=" + htmlColor + ">" + this.getAge(p) + "</font>").addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            source.focusLocation(p.getLoc());
                        }
                    });
                }
                popup.add(menu);
            }
            popup.addSeparator();
            popup.add("Settings").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PluginUtils.editPluginProperties((Object)((Object)SituationAwareness.this), (boolean)true);
                }
            });
            popup.add("Fetch asset properties").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SituationAwareness.this.fetchAssetProperties();
                }
            });
            popup.add("Select location sources").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JPanel p = new JPanel();
                    p.setLayout(new BoxLayout(p, 3));
                    for (ILocationProvider l : SituationAwareness.this.localizers) {
                        JCheckBox check = new JCheckBox(l.getName());
                        check.setSelected(true);
                        p.add(check);
                        check.setSelected(SituationAwareness.this.updateMethodNames.contains(l.getName()));
                    }
                    int op = JOptionPane.showConfirmDialog((Component)SituationAwareness.this.getConsole(), p, "Location update sources", 2, 3);
                    if (op == 2) {
                        return;
                    }
                    Vector<String> methods = new Vector<String>();
                    for (int i = 0; i < p.getComponentCount(); ++i) {
                        JCheckBox sel;
                        if (!(p.getComponent(i) instanceof JCheckBox) || !(sel = (JCheckBox)p.getComponent(i)).isSelected()) continue;
                        methods.add(sel.getText());
                    }
                    SituationAwareness.this.updateMethods = StringUtils.join(methods, (String)", ");
                    SituationAwareness.this.propertiesChanged();
                }
            });
            popup.add("Select hidden positions types").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JPanel p = new JPanel();
                    p.setLayout(new BoxLayout(p, 3));
                    for (String type : positions.keySet()) {
                        JCheckBox check = new JCheckBox(type);
                        check.setSelected(true);
                        p.add(check);
                        check.setSelected(SituationAwareness.this.hiddenPosTypes.contains(type));
                    }
                    int op = JOptionPane.showConfirmDialog((Component)SituationAwareness.this.getConsole(), p, "Position types to be hidden", 2, 3);
                    if (op == 2) {
                        return;
                    }
                    Vector<String> types = new Vector<String>();
                    for (int i = 0; i < p.getComponentCount(); ++i) {
                        JCheckBox sel;
                        if (!(p.getComponent(i) instanceof JCheckBox) || !(sel = (JCheckBox)p.getComponent(i)).isSelected()) continue;
                        types.add(sel.getText());
                    }
                    SituationAwareness.this.hiddenTypes = StringUtils.join(types, (String)", ");
                    SituationAwareness.this.propertiesChanged();
                }
            });
            popup.addSeparator();
            popup.add("Decision Support").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SituationAwareness.this.dialogDecisionSupport == null) {
                        SituationAwareness.this.dialogDecisionSupport = new JDialog((Frame)SituationAwareness.this.getConsole());
                        SituationAwareness.this.dialogDecisionSupport.setModal(false);
                        SituationAwareness.this.dialogDecisionSupport.setAlwaysOnTop(true);
                        SituationAwareness.this.dialogDecisionSupport.setDefaultCloseOperation(1);
                    }
                    ArrayList<AssetPosition> tags = new ArrayList<AssetPosition>();
                    LinkedHashMap positions = SituationAwareness.this.positionsByType();
                    Vector spots = (Vector)positions.get("SPOT Tag");
                    Vector argos = (Vector)positions.get("Argos Tag");
                    if (spots != null) {
                        tags.addAll(spots);
                    }
                    if (argos != null) {
                        tags.addAll(argos);
                    }
                    if (!SituationAwareness.this.assets.containsKey(SituationAwareness.this.getConsole().getMainSystem())) {
                        GuiUtils.errorMessage((Component)SituationAwareness.this.getConsole(), (String)"Decision Support", (String)"UUV asset position is unknown");
                        return;
                    }
                    SituationAwareness.this.supportTable.setAssets(((AssetTrack)SituationAwareness.this.assets.get(SituationAwareness.this.getConsole().getMainSystem())).getLatest(), tags);
                    JXTable table = new JXTable((TableModel)SituationAwareness.this.supportTable);
                    SituationAwareness.this.dialogDecisionSupport.setContentPane(new JScrollPane((Component)table));
                    SituationAwareness.this.dialogDecisionSupport.invalidate();
                    SituationAwareness.this.dialogDecisionSupport.validate();
                    SituationAwareness.this.dialogDecisionSupport.setSize(600, 300);
                    SituationAwareness.this.dialogDecisionSupport.setTitle("Decision Support Table");
                    SituationAwareness.this.dialogDecisionSupport.setVisible(true);
                    SituationAwareness.this.dialogDecisionSupport.toFront();
                    GuiUtils.centerOnScreen((Window)SituationAwareness.this.dialogDecisionSupport);
                }
            });
            popup.show((Component)source, event.getX(), event.getY());
        }
        super.mouseClicked(event, source);
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        double radius = this.isActive() ? 6.0 : 2.5;
        for (AssetTrack track : this.assets.values()) {
            List<AssetPosition> positions = track.getTrack();
            Point2D lastLoc = null;
            long lastAge = 0L;
            for (AssetPosition p : positions) {
                if (this.hiddenPosTypes.contains(p.getType()) || p.getTimestamp() < this.oldestTimestampSelection || p.getTimestamp() > this.newestTimestampSelection) continue;
                Point2D pt = renderer.getScreenPosition(p.getLoc());
                if (this.assetProperties.containsKey(track.getAssetName())) {
                    g.setColor(this.assetProperties.get((Object)track.getAssetName()).color);
                } else {
                    g.setColor(track.getColor());
                }
                if (lastLoc != null && lastLoc.distance(pt) < 20000.0) {
                    g.draw(new Line2D.Double(lastLoc, pt));
                }
                g.fill(new Ellipse2D.Double(pt.getX() - radius, pt.getY() - radius, radius * 2.0, radius * 2.0));
                lastLoc = pt;
                lastAge = p.getAge();
            }
            g.setStroke(new BasicStroke(2.0f));
            if (lastLoc == null) continue;
            Color c = this.cmap2.getColor(1.0 - (double)lastAge / 7200000.0);
            g.setColor(c);
            g.setStroke(new BasicStroke(2.0f));
            g.draw(new Ellipse2D.Double(lastLoc.getX() - radius - 1.5, lastLoc.getY() - radius - 1.5, radius * 2.0 + 3.0, radius * 2.0 + 3.0));
        }
        if (this.paintLabels) {
            this.paintLabels(g, renderer);
        }
        if (this.paintIcons) {
            this.paintIcons(g, renderer);
        }
    }

    public static void exportKml() {
    }

    public float getOpacity() {
        return 1.0f;
    }

    public boolean userControlsOpacity() {
        return false;
    }

    public void setOpacity(float opacity) {
    }

    public void setActive(boolean mode, StateRenderer2D source) {
        Container parent;
        super.setActive(mode, source);
        for (parent = source.getParent(); parent != null && !(parent.getLayout() instanceof BorderLayout); parent = parent.getParent()) {
        }
        if (mode) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)this.slider, "Center");
            panel.add((Component)this.minTimeLabel, "West");
            panel.add((Component)this.maxTimeLabel, "East");
            parent.add((Component)panel, "South");
        } else {
            parent = this.slider.getParent().getParent();
            parent.remove(this.slider.getParent());
        }
        parent.invalidate();
        parent.validate();
        parent.repaint();
    }

    public void mouseMoved(MouseEvent event, StateRenderer2D source) {
        ArrayList<AssetPosition> allPositions = new ArrayList<AssetPosition>();
        for (AssetTrack track : this.assets.values()) {
            allPositions.addAll(track.getTrack());
        }
        Collections.sort(allPositions);
        for (AssetPosition p : allPositions) {
            double dist;
            if (p.getTimestamp() < this.oldestTimestampSelection || p.getTimestamp() > this.newestTimestampSelection || !((dist = event.getPoint().distance(source.getScreenPosition(p.getLoc()))) < 5.0)) continue;
            this.intercepted = p;
            return;
        }
        this.intercepted = null;
    }
}

