/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.sunfish.awareness;

import java.io.File;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.WordUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.console.notifications.Notification;
import pt.lsts.neptus.plugins.sunfish.awareness.AssetPosition;
import pt.lsts.neptus.plugins.sunfish.awareness.ILocationProvider;
import pt.lsts.neptus.plugins.sunfish.awareness.SituationAwareness;
import pt.lsts.neptus.plugins.update.Periodic;

public class SpotLocationProvider
implements ILocationProvider {
    SituationAwareness parent;
    private String url = "https://api.findmespot.com/spot-main-web/consumer/rest-api/2.0/public/feed/0qQz420UTPODTjoHylgIOPa3RqqvOhkMK/message.xml";
    private boolean enabled = false;

    @Override
    public void onInit(SituationAwareness instance) {
        this.parent = instance;
    }

    @Periodic(millisBetweenUpdates=60000)
    public void updateSpots() throws Exception {
        if (!this.enabled) {
            return;
        }
        try {
            URL urlSpot = new URL(this.url);
            File tmp = File.createTempFile("neptus", "spots");
            FileUtils.copyURLToFile((URL)urlSpot, (File)tmp);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(tmp);
            NodeList messages = doc.getElementsByTagName("message");
            for (int i = 0; i < messages.getLength(); ++i) {
                NodeList elems = messages.item(i).getChildNodes();
                String name = null;
                double lat = 0.0;
                double lon = 0.0;
                long timestamp = System.currentTimeMillis();
                String battState = null;
                String msgType = null;
                block19: for (int j = 0; j < elems.getLength(); ++j) {
                    Node nd = elems.item(j);
                    switch (nd.getNodeName()) {
                        case "unixTime": {
                            timestamp = Long.parseLong(nd.getTextContent()) * 1000L;
                            continue block19;
                        }
                        case "latitude": {
                            lat = Double.parseDouble(nd.getTextContent());
                            continue block19;
                        }
                        case "longitude": {
                            lon = Double.parseDouble(nd.getTextContent());
                            continue block19;
                        }
                        case "messengerName": {
                            name = nd.getTextContent().toLowerCase();
                            continue block19;
                        }
                        case "batteryState": {
                            battState = nd.getTextContent();
                            continue block19;
                        }
                        case "messageType": {
                            msgType = nd.getTextContent();
                            continue block19;
                        }
                    }
                }
                if (name == null) continue;
                AssetPosition pos = new AssetPosition(name, lat, lon);
                pos.setTimestamp(timestamp);
                pos.setSource(this.getName());
                pos.setType("SPOT Tag");
                if (battState != null) {
                    pos.putExtra("Battery", WordUtils.capitalize((String)battState.toLowerCase()));
                }
                if (msgType != null) {
                    pos.putExtra("SPOT Mode", WordUtils.capitalize((String)msgType.toLowerCase()));
                }
                this.parent.addAssetPosition(pos);
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
            this.parent.postNotification(Notification.error((String)"Situation Awareness", (String)(e.getClass().getSimpleName() + " while polling SPOT positions from Web.")).requireHumanAction(false));
        }
    }

    @Override
    public String getName() {
        return "SPOT (Web API)";
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void onCleanup() {
    }
}

