/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.sunfish.awareness;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.util.Collection;
import java.util.Vector;
import org.apache.commons.io.FileUtils;

public class SunfishAssetProperties {
    private static final String assets_url = "https://docs.google.com/spreadsheets/d/1N76OoEUYvejoRBO2xZ_SL3o34q8GaC36iYb_-N94Dkg/export?gid=0&format=csv";
    private Vector<AssetDesc> lastAssets = new Vector();

    private Color parseColor(String hexColor) {
        if (hexColor == null || !hexColor.startsWith("#")) {
            return Color.black;
        }
        try {
            int red = Integer.valueOf(hexColor.substring(1, 3), 16);
            int green = Integer.valueOf(hexColor.substring(3, 5), 16);
            int blue = Integer.valueOf(hexColor.substring(5, 7), 16);
            return new Color(red, green, blue);
        }
        catch (Exception e) {
            return Color.black;
        }
    }

    public Collection<AssetDesc> fetchAssets() {
        try {
            URL urlAssets = new URL(assets_url);
            File tmp = File.createTempFile("neptus", "assets");
            FileUtils.copyURLToFile((URL)urlAssets, (File)tmp);
            BufferedReader reader = new BufferedReader(new FileReader(tmp));
            String line = reader.readLine();
            Vector<AssetDesc> assets = new Vector<AssetDesc>();
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split(",");
                AssetDesc asset = new AssetDesc();
                asset.name = parts[0].trim();
                asset.description = parts[1].trim();
                asset.color = this.parseColor(parts[2].trim());
                asset.friendly = parts[3].trim();
                asset.url = parts[4].trim();
                assets.add(asset);
            }
            reader.close();
            this.lastAssets = assets;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.lastAssets;
    }

    public static void main(String[] args) {
        SunfishAssetProperties props = new SunfishAssetProperties();
        System.out.println(props.fetchAssets().size());
    }

    public static class AssetDesc {
        public String name;
        public String description;
        public String url;
        public String friendly;
        public Color color;
    }
}

