/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.sunfish.iridium;

import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.apache.commons.codec.binary.Hex;
import pt.lsts.neptus.comm.iridium.IridiumMessage;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.util.ImageUtils;

public class IridiumHtmlVisualization
implements MRAVisualization {
    protected IridiumMessage msg;
    protected SimpleDateFormat fmt = new SimpleDateFormat("HH:mm:ss");
    protected JScrollPane scroll;

    public IridiumHtmlVisualization(IridiumMessage message) {
        this.fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.msg = message;
        JEditorPane editor = new JEditorPane();
        editor.setEditable(false);
        editor.setContentType("text/plain");
        editor.setBackground(Color.white);
        editor.setOpaque(true);
        try {
            editor.setText(this.msg.toString() + "DATA:\n" + new String(Hex.encodeHex((byte[])this.msg.serialize())));
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        editor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    JPopupMenu popup = new JPopupMenu();
                    popup.add(I18n.text((String)"Copy to clipboard")).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            StringSelection selection = new StringSelection(IridiumHtmlVisualization.this.msg.toString());
                            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, null);
                        }
                    });
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.scroll = new JScrollPane(editor);
    }

    public void onHide() {
    }

    public void onShow() {
    }

    public boolean supportsVariableTimeSteps() {
        return false;
    }

    public String getName() {
        return this.msg.getClass().getSimpleName() + " [" + new Date(this.msg.timestampMillis) + "]";
    }

    public ImageIcon getIcon() {
        return ImageUtils.getIcon((String)"images/menus/view.png");
    }

    public Double getDefaultTimeStep() {
        return null;
    }

    public Component getComponent(IMraLogGroup source, double timestep) {
        return this.scroll;
    }

    public MRAVisualization.Type getType() {
        return MRAVisualization.Type.TABLE;
    }

    public void onCleanup() {
    }

    public boolean canBeApplied(IMraLogGroup source) {
        return true;
    }
}

