/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.sunfish.iridium;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.codec.binary.Hex;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IridiumMsgRx;
import pt.lsts.imc.IridiumMsgTx;
import pt.lsts.neptus.comm.iridium.IridiumMessage;

public class IridiumMessagesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss.SSS");
    Vector<IrMsg> msgs = new Vector();
    private static final int TIMESTAMP = 0;
    private static final int SOURCE = 1;
    private static final int DESTINATION = 2;
    private static final int TYPE = 3;
    private static final int SIZE = 4;
    private static final int DATA = 5;

    public void addReception(IridiumMsgRx msg) throws Exception {
        IridiumMessage m = IridiumMessage.deserialize((byte[])msg.getData());
        IrMsg irmsg = new IrMsg();
        irmsg.size = msg.getData().length;
        irmsg.data = new String(Hex.encodeHex((byte[])msg.getData()));
        irmsg.trans = "Reception";
        irmsg.source = IMCDefinition.getInstance().getResolver().resolve(m.getSource());
        irmsg.destination = IMCDefinition.getInstance().getResolver().resolve(m.getDestination());
        irmsg.type = m.getClass().getSimpleName();
        irmsg.time = msg.getDate();
        Collections.sort(this.msgs);
        this.msgs.add(irmsg);
        this.fireTableDataChanged();
    }

    public void addTransmission(IridiumMsgTx msg) throws Exception {
        IridiumMessage m = IridiumMessage.deserialize((byte[])msg.getData());
        IrMsg irmsg = new IrMsg();
        irmsg.size = msg.getData().length;
        irmsg.data = new String(Hex.encodeHex((byte[])msg.getData()));
        irmsg.trans = "Transmission Request";
        irmsg.source = IMCDefinition.getInstance().getResolver().resolve(m.getSource());
        irmsg.destination = IMCDefinition.getInstance().getResolver().resolve(m.getDestination());
        irmsg.type = m.getClass().getSimpleName();
        irmsg.time = msg.getDate();
        this.msgs.add(irmsg);
        Collections.sort(this.msgs);
        this.fireTableDataChanged();
    }

    public String getMessageData(int row) {
        return this.msgs.get((int)row).data;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Time";
            }
            case 1: {
                return "Source";
            }
            case 2: {
                return "Destination";
            }
            case 3: {
                return "Type";
            }
            case 4: {
                return "Size";
            }
            case 5: {
                return "Data";
            }
        }
        return "??";
    }

    public IridiumMessagesTableModel() {
        this.sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    public int getRowCount() {
        return this.msgs.size();
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        IrMsg m = this.msgs.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return this.sdf.format(m.time);
            }
            case 1: {
                return m.source;
            }
            case 2: {
                return m.destination;
            }
            case 3: {
                return m.trans;
            }
            case 4: {
                return m.size;
            }
            case 5: {
                return m.data;
            }
        }
        return "??";
    }

    class IrMsg
    implements Comparable<IrMsg> {
        public int size;
        public String trans;
        public String source;
        public String destination;
        public String type;
        public String data;
        public Date time;

        IrMsg() {
        }

        @Override
        public int compareTo(IrMsg o) {
            return this.time.compareTo(o.time);
        }
    }
}

