/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.sunfish.iridium;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import org.apache.commons.codec.binary.Hex;
import org.jdesktop.swingx.JXTable;
import pt.lsts.imc.IridiumMsgRx;
import pt.lsts.imc.IridiumMsgTx;
import pt.lsts.imc.lsf.LsfIterator;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.iridium.IridiumMessage;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.mra.visualizations.SimpleMRAVisualization;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.sunfish.iridium.IridiumHtmlVisualization;
import pt.lsts.neptus.plugins.sunfish.iridium.IridiumMessagesTableModel;
import pt.lsts.neptus.util.GuiUtils;

@PluginDescription(active=false)
public class IridiumVisualization
extends SimpleMRAVisualization {
    IridiumMessagesTableModel tableModel = new IridiumMessagesTableModel();
    private static final long serialVersionUID = 1L;

    public IridiumVisualization(MRAPanel panel) {
        super(panel);
    }

    public MRAVisualization.Type getType() {
        return MRAVisualization.Type.VISUALIZATION;
    }

    public boolean canBeApplied(IMraLogGroup source) {
        return source.getLsfIndex().containsMessagesOfType(new String[]{"IridiumMsgTx", "IridiumMsgRx"});
    }

    public JComponent getVisualization(IMraLogGroup source, double timestep) {
        LsfIterator itTx = source.getLsfIndex().getIterator(IridiumMsgTx.class);
        while (itTx.hasNext()) {
            try {
                this.tableModel.addTransmission((IridiumMsgTx)itTx.next());
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        }
        LsfIterator itRx = source.getLsfIndex().getIterator(IridiumMsgRx.class);
        while (itRx.hasNext()) {
            try {
                this.tableModel.addReception((IridiumMsgRx)itRx.next());
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        }
        final JXTable table = new JXTable((TableModel)this.tableModel);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    try {
                        IridiumMessage msg = IridiumMessage.deserialize((byte[])Hex.decodeHex((char[])IridiumVisualization.this.tableModel.getMessageData(table.getSelectedRow()).toCharArray()));
                        IridiumVisualization.this.mraPanel.loadVisualization((MRAVisualization)new IridiumHtmlVisualization(msg), true);
                    }
                    catch (Exception ex) {
                        GuiUtils.errorMessage((Component)IridiumVisualization.this.mraPanel, (Exception)ex);
                    }
                }
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    String data = IridiumVisualization.this.tableModel.getMessageData(table.getSelectedRow());
                    try {
                        IridiumMessage.deserialize((byte[])Hex.decodeHex((char[])data.toCharArray()));
                    }
                    catch (Exception e) {
                        NeptusLog.pub().error((Object)e);
                    }
                }
            }
        });
        return new JScrollPane((Component)table);
    }
}

