/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.actions;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.actions.SimpleAction;

@PluginDescription(icon="pt/lsts/neptus/plugins/actions/full_toggle.png", name="Full Screen Toggle", description="Toggle fullscreen mode")
public class FullScreenAction
extends SimpleAction {
    private static final long serialVersionUID = 1L;
    private Rectangle bounds = null;

    public FullScreenAction(ConsoleLayout console) {
        super(console);
    }

    @Override
    protected boolean isSwitch() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        if (!this.isSelected()) {
            gs.setFullScreenWindow(null);
            if (this.bounds != null) {
                this.getConsole().setBounds(this.bounds);
            }
        } else {
            try {
                this.bounds = this.getConsole().getBounds();
                this.getConsole().setExtendedState(6);
                this.getConsole().setBounds(gs.getDefaultConfiguration().getBounds());
                this.getConsole().validate();
                gs.setFullScreenWindow((Window)this.getConsole());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                gs.setFullScreenWindow(null);
            }
        }
    }

    public void initSubPanel() {
    }

    public void cleanSubPanel() {
    }
}

