/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Color;
import java.awt.Graphics2D;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.parser.UnitProcessor;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.keys.BooleanKey;
import org.apache.batik.transcoder.keys.FloatKey;
import org.apache.batik.util.ParsedURL;
import org.apache.fop.Version;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.svg.AbstractFOPTranscoder;
import org.apache.fop.svg.PDFBridgeContext;
import org.apache.fop.svg.PDFDocumentGraphics2D;
import org.apache.fop.svg.PDFDocumentGraphics2DConfigurator;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageSessionContext;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PDFTranscoder
extends AbstractFOPTranscoder
implements Configurable {
    public static final TranscodingHints.Key KEY_DEVICE_RESOLUTION = new FloatKey();
    public static final TranscodingHints.Key KEY_AUTO_FONTS = new BooleanKey();
    private Configuration cfg = null;
    protected PDFDocumentGraphics2D graphics = null;
    private ImageManager imageManager;
    private ImageSessionContext imageSessionContext;

    public PDFTranscoder() {
        this.handler = new AbstractFOPTranscoder.FOPErrorHandler();
    }

    protected UserAgent createUserAgent() {
        return new AbstractFOPTranscoder.FOPTranscoderUserAgent(){

            public float getPixelUnitToMillimeter() {
                return super.getPixelUnitToMillimeter();
            }
        };
    }

    public void configure(Configuration cfg) throws ConfigurationException {
        this.cfg = cfg;
    }

    protected void transcode(Document document, String uri, TranscoderOutput output) throws TranscoderException {
        this.graphics = new PDFDocumentGraphics2D(this.isTextStroked());
        this.graphics.getPDFDocument().getInfo().setProducer("Apache FOP Version " + Version.getVersion() + ": PDF Transcoder for Batik");
        if (this.hints.containsKey((Object)KEY_DEVICE_RESOLUTION)) {
            this.graphics.setDeviceDPI(((Float)this.hints.get((Object)KEY_DEVICE_RESOLUTION)).floatValue());
        }
        this.setupImageInfrastructure(uri);
        try {
            Configuration effCfg = this.cfg;
            if (effCfg == null) {
                boolean autoFonts = true;
                if (this.hints.containsKey((Object)KEY_AUTO_FONTS)) {
                    autoFonts = (Boolean)this.hints.get((Object)KEY_AUTO_FONTS);
                }
                if (autoFonts) {
                    DefaultConfiguration c = new DefaultConfiguration("pdf-transcoder");
                    DefaultConfiguration fonts = new DefaultConfiguration("fonts");
                    c.addChild(fonts);
                    DefaultConfiguration autodetect = new DefaultConfiguration("auto-detect");
                    fonts.addChild(autodetect);
                    effCfg = c;
                }
            }
            if (effCfg != null) {
                PDFDocumentGraphics2DConfigurator configurator = new PDFDocumentGraphics2DConfigurator();
                configurator.configure(this.graphics, effCfg);
            } else {
                this.graphics.setupDefaultFontInfo();
            }
        }
        catch (Exception e) {
            throw new TranscoderException("Error while setting up PDFDocumentGraphics2D", e);
        }
        super.transcode(document, uri, output);
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)("document size: " + this.width + " x " + this.height));
        }
        UnitProcessor.Context uctx = UnitProcessor.createContext((BridgeContext)this.ctx, (Element)document.getDocumentElement());
        float widthInPt = UnitProcessor.userSpaceToSVG((float)this.width, (short)9, (short)2, (UnitProcessor.Context)uctx);
        int w = (int)((double)widthInPt + 0.5);
        float heightInPt = UnitProcessor.userSpaceToSVG((float)this.height, (short)9, (short)2, (UnitProcessor.Context)uctx);
        int h = (int)((double)heightInPt + 0.5);
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)("document size: " + w + "pt x " + h + "pt"));
        }
        try {
            OutputStream out = output.getOutputStream();
            if (!(out instanceof BufferedOutputStream)) {
                out = new BufferedOutputStream(out);
            }
            this.graphics.setupDocument(out, w, h);
            this.graphics.setSVGDimension(this.width, this.height);
            if (this.hints.containsKey((Object)ImageTranscoder.KEY_BACKGROUND_COLOR)) {
                this.graphics.setBackgroundColor((Color)this.hints.get((Object)ImageTranscoder.KEY_BACKGROUND_COLOR));
            }
            this.graphics.setGraphicContext(new GraphicContext());
            this.graphics.preparePainting();
            this.graphics.transform(this.curTxf);
            this.graphics.setRenderingHint(RenderingHintsKeyExt.KEY_TRANSCODING, "Vector");
            this.root.paint((Graphics2D)((Object)this.graphics));
            this.graphics.finish();
        }
        catch (IOException ex) {
            throw new TranscoderException((Exception)ex);
        }
    }

    private void setupImageInfrastructure(final String baseURI) {
        final ImageContext imageContext = new ImageContext(){

            public float getSourceResolution() {
                return 25.4f / PDFTranscoder.this.userAgent.getPixelUnitToMillimeter();
            }
        };
        this.imageManager = new ImageManager(imageContext);
        this.imageSessionContext = new AbstractImageSessionContext(){

            public ImageContext getParentContext() {
                return imageContext;
            }

            public float getTargetResolution() {
                return PDFTranscoder.this.graphics.getDeviceDPI();
            }

            public Source resolveURI(String uri) {
                System.out.println("resolve " + uri);
                try {
                    ParsedURL url = new ParsedURL(baseURI, uri);
                    InputStream in = url.openStream();
                    StreamSource source = new StreamSource(in, url.toString());
                    return source;
                }
                catch (IOException ioe) {
                    PDFTranscoder.this.userAgent.displayError((Exception)ioe);
                    return null;
                }
            }
        };
    }

    protected BridgeContext createBridgeContext() {
        return this.createBridgeContext("1.x");
    }

    public BridgeContext createBridgeContext(String version) {
        FontInfo fontInfo = this.graphics.getFontInfo();
        if (this.isTextStroked()) {
            fontInfo = null;
        }
        PDFBridgeContext ctx = new PDFBridgeContext(this.userAgent, fontInfo, this.imageManager, this.imageSessionContext);
        return ctx;
    }
}

