/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtilsStriped;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class ExpandStriped {
    private boolean overwrite = true;
    private static final String NATIVE_ENCODING = "native-encoding";
    private String encoding = "UTF8";

    public void expandFile(File srcF, File dir) {
        this.expandFile(FileUtilsStriped.newFileUtils(), srcF, dir);
    }

    protected void expandFile(FileUtilsStriped fileUtils, File srcF, File dir) {
        ZipFile zf = null;
        try {
            zf = new ZipFile(srcF, this.encoding);
            Enumeration<ZipEntry> e = zf.getEntries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                this.extractFile(fileUtils, srcF, dir, zf.getInputStream(ze), ze.getName(), new Date(ze.getTime()), ze.isDirectory());
            }
        }
        catch (IOException ioe) {
            throw new BuildException("Error while expanding " + srcF.getPath(), ioe);
        }
        finally {
            if (zf != null) {
                try {
                    zf.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractFile(FileUtilsStriped fileUtils, File srcF, File dir, InputStream compressedInputStream, String entryName, Date entryDate, boolean isDirectory) throws IOException {
        File f = fileUtils.resolveFile(dir, entryName);
        try {
            if (!this.overwrite && f.exists() && f.lastModified() >= entryDate.getTime()) {
                return;
            }
            File dirF = fileUtils.getParentFile(f);
            if (dirF != null) {
                dirF.mkdirs();
            }
            if (isDirectory) {
                f.mkdirs();
            } else {
                byte[] buffer = new byte[1024];
                int length = 0;
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(f);
                    while ((length = compressedInputStream.read(buffer)) >= 0) {
                        fos.write(buffer, 0, length);
                    }
                    fos.close();
                    fos = null;
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            fileUtils.setFileLastModified(f, entryDate.getTime());
        }
        catch (FileNotFoundException ex) {
            // empty catch block
        }
    }

    public void setOverwrite(boolean b) {
        this.overwrite = b;
    }

    public void setEncoding(String encoding) {
        if (NATIVE_ENCODING.equals(encoding)) {
            encoding = null;
        }
        this.encoding = encoding;
    }
}

