/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.File;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.launch.Locator;
import org.apache.tools.ant.taskdefs.condition.Os;

public class FileUtilsStriped {
    private static final FileUtilsStriped PRIMARY_INSTANCE = new FileUtilsStriped();
    private static boolean onNetWare = Os.isFamily("netware");
    private static boolean onDos = Os.isFamily("dos");
    private static boolean[] isSpecial = new boolean[256];
    private static char[] escapedChar1 = new char[256];
    private static char[] escapedChar2 = new char[256];
    public static final long FAT_FILE_TIMESTAMP_GRANULARITY = 2000L;
    public static final long UNIX_FILE_TIMESTAMP_GRANULARITY = 1000L;

    public static FileUtilsStriped newFileUtils() {
        return new FileUtilsStriped();
    }

    public static FileUtilsStriped getFileUtils() {
        return PRIMARY_INSTANCE;
    }

    protected FileUtilsStriped() {
    }

    public void setFileLastModified(File file, long time) {
        file.setLastModified(time < 0L ? System.currentTimeMillis() : time);
    }

    public File resolveFile(File file, String filename) {
        if (FileUtilsStriped.isAbsolutePath(filename = filename.replace('/', File.separatorChar).replace('\\', File.separatorChar))) {
            return this.normalize(filename);
        }
        if (file == null) {
            return new File(filename);
        }
        File helpFile = new File(file.getAbsolutePath());
        StringTokenizer tok = new StringTokenizer(filename, File.separator);
        while (tok.hasMoreTokens()) {
            String part = tok.nextToken();
            if (part.equals("..")) {
                if ((helpFile = helpFile.getParentFile()) != null) continue;
                String msg = "The file or path you specified (" + filename + ") is invalid relative to " + file.getPath();
                throw new BuildException(msg);
            }
            if (part.equals(".")) continue;
            helpFile = new File(helpFile, part);
        }
        return new File(helpFile.getAbsolutePath());
    }

    public static boolean isAbsolutePath(String filename) {
        if (filename.startsWith(File.separator)) {
            return true;
        }
        if (onDos && filename.length() >= 2 && Character.isLetter(filename.charAt(0)) && filename.charAt(1) == ':') {
            return true;
        }
        return onNetWare && filename.indexOf(":") > -1;
    }

    public File normalize(String path) {
        int i;
        String orig = path;
        path = path.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        int colon = path.indexOf(":");
        if (!FileUtilsStriped.isAbsolutePath(path)) {
            String msg = path + " is not an absolute path";
            throw new BuildException(msg);
        }
        boolean dosWithDrive = false;
        String root = null;
        if (onDos && path.length() >= 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':' || onNetWare && colon > -1) {
            dosWithDrive = true;
            char[] ca = path.replace('/', '\\').toCharArray();
            StringBuffer sbRoot = new StringBuffer();
            for (int i2 = 0; i2 < colon; ++i2) {
                sbRoot.append(Character.toUpperCase(ca[i2]));
            }
            sbRoot.append(':');
            if (colon + 1 < path.length()) {
                sbRoot.append(File.separatorChar);
            }
            root = sbRoot.toString();
            StringBuffer sbPath = new StringBuffer();
            for (i = colon + 1; i < ca.length; ++i) {
                if (ca[i] == '\\' && (ca[i] != '\\' || ca[i - 1] == '\\')) continue;
                sbPath.append(ca[i]);
            }
            path = sbPath.toString().replace('\\', File.separatorChar);
        } else if (path.length() == 1) {
            root = File.separator;
            path = "";
        } else if (path.charAt(1) == File.separatorChar) {
            root = File.separator + File.separator;
            path = path.substring(2);
        } else {
            root = File.separator;
            path = path.substring(1);
        }
        Stack<String> s = new Stack<String>();
        s.push(root);
        StringTokenizer tok = new StringTokenizer(path, File.separator);
        while (tok.hasMoreTokens()) {
            String thisToken = tok.nextToken();
            if (".".equals(thisToken)) continue;
            if ("..".equals(thisToken)) {
                if (s.size() < 2) {
                    throw new BuildException("Cannot resolve path " + orig);
                }
                s.pop();
                continue;
            }
            s.push(thisToken);
        }
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < s.size(); ++i) {
            if (i > 1) {
                sb.append(File.separatorChar);
            }
            sb.append((String)s.elementAt(i));
        }
        path = sb.toString();
        if (dosWithDrive) {
            path = path.replace('/', '\\');
        }
        return new File(path);
    }

    public String fromURI(String uri) {
        String path = Locator.fromURI(uri);
        try {
            path = this.normalize(path).getAbsolutePath();
        }
        catch (BuildException buildException) {
            // empty catch block
        }
        return path;
    }

    public File getParentFile(File f) {
        return f == null ? null : f.getParentFile();
    }

    static {
        for (int i = 0; i <= 32; ++i) {
            FileUtilsStriped.isSpecial[i] = true;
            FileUtilsStriped.escapedChar1[i] = Character.forDigit(i >> 4, 16);
            FileUtilsStriped.escapedChar2[i] = Character.forDigit(i & 0xF, 16);
        }
        FileUtilsStriped.isSpecial[127] = true;
        FileUtilsStriped.escapedChar1[127] = 55;
        FileUtilsStriped.escapedChar2[127] = 70;
        for (char ch : new char[]{'<', '>', '#', '%', '\"', '{', '}', '|', '\\', '^', '~', '[', ']', '`'}) {
            FileUtilsStriped.isSpecial[ch] = true;
            FileUtilsStriped.escapedChar1[ch] = Character.forDigit(ch >> 4, 16);
            FileUtilsStriped.escapedChar2[ch] = Character.forDigit(ch & 0xF, 16);
        }
    }
}

