/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.ZipException;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipLong;
import org.apache.tools.zip.ZipShort;

public class ZipOutputStream
extends FilterOutputStream {
    private ZipEntry entry;
    private String comment = "";
    private int level = -1;
    private boolean hasCompressionLevelChanged = false;
    private int method = 8;
    private Vector<ZipEntry> entries = new Vector();
    private CRC32 crc = new CRC32();
    private long written = 0L;
    private long dataStart = 0L;
    private long localDataStart = 0L;
    private ZipLong cdOffset = new ZipLong(0L);
    private ZipLong cdLength = new ZipLong(0L);
    private static final byte[] ZERO = new byte[]{0, 0};
    private static final byte[] LZERO = new byte[]{0, 0, 0, 0};
    private Hashtable<ZipEntry, ZipLong> offsets = new Hashtable();
    private String encoding = null;
    protected Deflater def = new Deflater(-1, true);
    protected byte[] buf = new byte[512];
    private RandomAccessFile raf = null;
    public static final int DEFLATED = 8;
    public static final int STORED = 0;
    protected static final ZipLong LFH_SIG = new ZipLong(67324752L);
    protected static final ZipLong DD_SIG = new ZipLong(134695760L);
    protected static final ZipLong CFH_SIG = new ZipLong(33639248L);
    protected static final ZipLong EOCD_SIG = new ZipLong(101010256L);
    private static final ZipLong DOS_TIME_MIN = new ZipLong(8448L);

    public ZipOutputStream(OutputStream out) {
        super(out);
    }

    public ZipOutputStream(File file) throws IOException {
        super(null);
        try {
            this.raf = new RandomAccessFile(file, "rw");
            this.raf.setLength(0L);
        }
        catch (IOException e) {
            if (this.raf != null) {
                try {
                    this.raf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.raf = null;
            }
            this.out = new FileOutputStream(file);
        }
    }

    public boolean isSeekable() {
        return this.raf != null;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void finish() throws IOException {
        this.closeEntry();
        this.cdOffset = new ZipLong(this.written);
        for (int i = 0; i < this.entries.size(); ++i) {
            this.writeCentralFileHeader(this.entries.elementAt(i));
        }
        this.cdLength = new ZipLong(this.written - this.cdOffset.getValue());
        this.writeCentralDirectoryEnd();
        this.offsets.clear();
        this.entries.removeAllElements();
    }

    public void closeEntry() throws IOException {
        if (this.entry == null) {
            return;
        }
        long realCrc = this.crc.getValue();
        this.crc.reset();
        if (this.entry.getMethod() == 8) {
            this.def.finish();
            while (!this.def.finished()) {
                this.deflate();
            }
            this.entry.setSize(ZipOutputStream.adjustToLong(this.def.getTotalIn()));
            this.entry.setComprSize(ZipOutputStream.adjustToLong(this.def.getTotalOut()));
            this.entry.setCrc(realCrc);
            this.def.reset();
            this.written += this.entry.getCompressedSize();
        } else if (this.raf == null) {
            if (this.entry.getCrc() != realCrc) {
                throw new ZipException("bad CRC checksum for entry " + this.entry.getName() + ": " + Long.toHexString(this.entry.getCrc()) + " instead of " + Long.toHexString(realCrc));
            }
            if (this.entry.getSize() != this.written - this.dataStart) {
                throw new ZipException("bad size for entry " + this.entry.getName() + ": " + this.entry.getSize() + " instead of " + (this.written - this.dataStart));
            }
        } else {
            long size = this.written - this.dataStart;
            this.entry.setSize(size);
            this.entry.setComprSize(size);
            this.entry.setCrc(realCrc);
        }
        if (this.raf != null) {
            long save = this.raf.getFilePointer();
            this.raf.seek(this.localDataStart);
            this.writeOut(new ZipLong(this.entry.getCrc()).getBytes());
            this.writeOut(new ZipLong(this.entry.getCompressedSize()).getBytes());
            this.writeOut(new ZipLong(this.entry.getSize()).getBytes());
            this.raf.seek(save);
        }
        this.writeDataDescriptor(this.entry);
        this.entry = null;
    }

    public void putNextEntry(ZipEntry ze) throws IOException {
        this.closeEntry();
        this.entry = ze;
        this.entries.addElement(this.entry);
        if (this.entry.getMethod() == -1) {
            this.entry.setMethod(this.method);
        }
        if (this.entry.getTime() == -1L) {
            this.entry.setTime(System.currentTimeMillis());
        }
        if (this.entry.getMethod() == 0 && this.raf == null) {
            if (this.entry.getSize() == -1L) {
                throw new ZipException("uncompressed size is required for STORED method when not writing to a file");
            }
            if (this.entry.getCrc() == -1L) {
                throw new ZipException("crc checksum is required for STORED method when not writing to a file");
            }
            this.entry.setComprSize(this.entry.getSize());
        }
        if (this.entry.getMethod() == 8 && this.hasCompressionLevelChanged) {
            this.def.setLevel(this.level);
            this.hasCompressionLevelChanged = false;
        }
        this.writeLocalFileHeader(this.entry);
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setLevel(int level) {
        this.hasCompressionLevelChanged = this.level != level;
        this.level = level;
    }

    public void setMethod(int method) {
        this.method = method;
    }

    @Override
    public void write(byte[] b, int offset, int length) throws IOException {
        if (this.entry.getMethod() == 8) {
            if (length > 0 && !this.def.finished()) {
                this.def.setInput(b, offset, length);
                while (!this.def.needsInput()) {
                    this.deflate();
                }
            }
        } else {
            this.writeOut(b, offset, length);
            this.written += (long)length;
        }
        this.crc.update(b, offset, length);
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)(b & 0xFF)};
        this.write(buf, 0, 1);
    }

    @Override
    public void close() throws IOException {
        this.finish();
        if (this.raf != null) {
            this.raf.close();
        }
        if (this.out != null) {
            this.out.close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    protected final void deflate() throws IOException {
        int len = this.def.deflate(this.buf, 0, this.buf.length);
        if (len > 0) {
            this.writeOut(this.buf, 0, len);
        }
    }

    protected void writeLocalFileHeader(ZipEntry ze) throws IOException {
        this.offsets.put(ze, new ZipLong(this.written));
        this.writeOut(LFH_SIG.getBytes());
        this.written += 4L;
        if (ze.getMethod() == 8 && this.raf == null) {
            this.writeOut(new ZipShort(20).getBytes());
            this.writeOut(new ZipShort(8).getBytes());
        } else {
            this.writeOut(new ZipShort(10).getBytes());
            this.writeOut(ZERO);
        }
        this.written += 4L;
        this.writeOut(new ZipShort(ze.getMethod()).getBytes());
        this.written += 2L;
        this.writeOut(ZipOutputStream.toDosTime(new Date(ze.getTime())).getBytes());
        this.written += 4L;
        this.localDataStart = this.written;
        if (ze.getMethod() == 8 || this.raf != null) {
            this.writeOut(LZERO);
            this.writeOut(LZERO);
            this.writeOut(LZERO);
        } else {
            this.writeOut(new ZipLong(ze.getCrc()).getBytes());
            this.writeOut(new ZipLong(ze.getSize()).getBytes());
            this.writeOut(new ZipLong(ze.getSize()).getBytes());
        }
        this.written += 12L;
        byte[] name = this.getBytes(ze.getName());
        this.writeOut(new ZipShort(name.length).getBytes());
        this.written += 2L;
        byte[] extra = ze.getLocalFileDataExtra();
        this.writeOut(new ZipShort(extra.length).getBytes());
        this.written += 2L;
        this.writeOut(name);
        this.written += (long)name.length;
        this.writeOut(extra);
        this.written += (long)extra.length;
        this.dataStart = this.written;
    }

    protected void writeDataDescriptor(ZipEntry ze) throws IOException {
        if (ze.getMethod() != 8 || this.raf != null) {
            return;
        }
        this.writeOut(DD_SIG.getBytes());
        this.writeOut(new ZipLong(this.entry.getCrc()).getBytes());
        this.writeOut(new ZipLong(this.entry.getCompressedSize()).getBytes());
        this.writeOut(new ZipLong(this.entry.getSize()).getBytes());
        this.written += 16L;
    }

    protected void writeCentralFileHeader(ZipEntry ze) throws IOException {
        this.writeOut(CFH_SIG.getBytes());
        this.written += 4L;
        this.writeOut(new ZipShort(ze.getPlatform() << 8 | 0x14).getBytes());
        this.written += 2L;
        if (ze.getMethod() == 8 && this.raf == null) {
            this.writeOut(new ZipShort(20).getBytes());
            this.writeOut(new ZipShort(8).getBytes());
        } else {
            this.writeOut(new ZipShort(10).getBytes());
            this.writeOut(ZERO);
        }
        this.written += 4L;
        this.writeOut(new ZipShort(ze.getMethod()).getBytes());
        this.written += 2L;
        this.writeOut(ZipOutputStream.toDosTime(new Date(ze.getTime())).getBytes());
        this.written += 4L;
        this.writeOut(new ZipLong(ze.getCrc()).getBytes());
        this.writeOut(new ZipLong(ze.getCompressedSize()).getBytes());
        this.writeOut(new ZipLong(ze.getSize()).getBytes());
        this.written += 12L;
        byte[] name = this.getBytes(ze.getName());
        this.writeOut(new ZipShort(name.length).getBytes());
        this.written += 2L;
        byte[] extra = ze.getCentralDirectoryExtra();
        this.writeOut(new ZipShort(extra.length).getBytes());
        this.written += 2L;
        String comm = ze.getComment();
        if (comm == null) {
            comm = "";
        }
        byte[] comment = this.getBytes(comm);
        this.writeOut(new ZipShort(comment.length).getBytes());
        this.written += 2L;
        this.writeOut(ZERO);
        this.written += 2L;
        this.writeOut(new ZipShort(ze.getInternalAttributes()).getBytes());
        this.written += 2L;
        this.writeOut(new ZipLong(ze.getExternalAttributes()).getBytes());
        this.written += 4L;
        this.writeOut(this.offsets.get(ze).getBytes());
        this.written += 4L;
        this.writeOut(name);
        this.written += (long)name.length;
        this.writeOut(extra);
        this.written += (long)extra.length;
        this.writeOut(comment);
        this.written += (long)comment.length;
    }

    protected void writeCentralDirectoryEnd() throws IOException {
        this.writeOut(EOCD_SIG.getBytes());
        this.writeOut(ZERO);
        this.writeOut(ZERO);
        byte[] num = new ZipShort(this.entries.size()).getBytes();
        this.writeOut(num);
        this.writeOut(num);
        this.writeOut(this.cdLength.getBytes());
        this.writeOut(this.cdOffset.getBytes());
        byte[] data = this.getBytes(this.comment);
        this.writeOut(new ZipShort(data.length).getBytes());
        this.writeOut(data);
    }

    protected static ZipLong toDosTime(Date time) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(time);
        int year = gc.get(1) + 1900;
        int month = gc.get(2) + 1;
        if (year < 1980) {
            return DOS_TIME_MIN;
        }
        long value = year - 1980 << 25 | month << 21 | gc.get(5) << 16 | gc.get(10) << 11 | gc.get(12) << 5 | gc.get(13) >> 1;
        byte[] result = new byte[]{(byte)(value & 0xFFL), (byte)((value & 0xFF00L) >> 8), (byte)((value & 0xFF0000L) >> 16), (byte)((value & 0xFF000000L) >> 24)};
        return new ZipLong(result);
    }

    protected byte[] getBytes(String name) throws ZipException {
        if (this.encoding == null) {
            return name.getBytes();
        }
        try {
            return name.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new ZipException(uee.getMessage());
        }
    }

    protected final void writeOut(byte[] data) throws IOException {
        this.writeOut(data, 0, data.length);
    }

    protected final void writeOut(byte[] data, int offset, int length) throws IOException {
        if (this.raf != null) {
            this.raf.write(data, offset, length);
        } else {
            this.out.write(data, offset, length);
        }
    }

    protected static long adjustToLong(int i) {
        if (i < 0) {
            return 0x100000000L + (long)i;
        }
        return i;
    }
}

