/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import pt.lsts.neptus.NeptusLog;

public class NeptusConfig {
    public static final String DS = System.getProperty("file.separator", "/");
    public static final String FILE_TYPE_VEHICLE = "nvcl";
    private final File tempDir;
    private Map<String, File> schemas = new HashMap<String, File>();
    private PropertiesConfiguration config;
    private Properties versionInfo = new Properties();

    public NeptusConfig(PropertiesConfiguration config) {
        this.tempDir = new File(System.getProperty("java.io.tmpdir") + DS + "Neptus_" + new Date().getTime());
        this.tempDir.mkdirs();
        this.config = config;
        this.loadVersionFile();
    }

    public NeptusConfig loadSchemas() {
        Iterator keys = this.config.getKeys("schemas");
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String path = this.config.getString(key);
            InputStream in = NeptusConfig.class.getResourceAsStream("/" + path);
            if (in != null) {
                File file = new File(this.tempDir, key);
                try {
                    FileOutputStream out = FileUtils.openOutputStream((File)file);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    in.close();
                    ((OutputStream)out).close();
                    this.schemas.put(key, file);
                }
                catch (IOException e) {
                    NeptusLog.pub().error((Object)("error loading schema : " + path));
                }
                continue;
            }
            NeptusLog.pub().error((Object)("error opening stream for schema : " + path));
        }
        return this;
    }

    public NeptusConfig setupLog() {
        NeptusLog.extendedLog = this.config.getBoolean("core.extended-log");
        return this;
    }

    public String getVehiclesPath() {
        return this.config.getString("core.vehicles-path");
    }

    private void loadVersionFile() {
        InputStream in = this.getClass().getResourceAsStream(this.config.getString("core.version-file"));
        this.versionInfo = new Properties();
        try {
            this.versionInfo.load(in);
        }
        catch (IOException e) {
            NeptusLog.pub().error((Object)"error loading version file", (Throwable)e);
        }
    }

    public Properties version() {
        return this.versionInfo;
    }

    public String versionForXml() {
        Date trialTime = new Date();
        SimpleDateFormat dateFormater = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.0Z'");
        String ret = "Data saved on " + dateFormater.format(trialTime) + " with Neptus version " + this.versionInfo.getProperty("VERSION", "") + " (compiled on " + this.versionInfo.getProperty("DATE", "") + ", r" + this.versionInfo.getProperty("SVN_REV", "?") + ").";
        return " " + ret + " ";
    }

    public String versionAsString() {
        String versionString = " ";
        versionString = versionString + this.versionInfo.getProperty("VERSION", "");
        versionString = versionString + " (";
        versionString = versionString + this.versionInfo.getProperty("DATE", "");
        versionString = versionString + ", r";
        versionString = versionString + this.versionInfo.getProperty("SVN_REV", "?");
        versionString = versionString + ")";
        return versionString;
    }

    public void shutdown() {
        try {
            FileUtils.deleteDirectory((File)this.tempDir);
        }
        catch (IOException e) {
            NeptusLog.pub().error((Object)"error deleting temp folder");
        }
    }
}

