/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.configuration.PropertiesConfiguration;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.neptus.NeptusConfig;
import pt.lsts.neptus.NeptusProperties;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.systems.SystemsManager;
import pt.lsts.neptus.util.conf.GeneralPreferences;

public class NeptusFactory {
    public static final String CONFIG_FILE = "conf/config.properties";
    private final PropertiesConfiguration config = new PropertiesConfiguration("conf/config.properties");
    private final IMCDefinition imcDefinition;
    private final NeptusConfig neptusConfig = new NeptusConfig(this.config);
    private final SystemsManager systems;
    private final ImcMsgManager imcManager;

    public NeptusFactory() throws Exception {
        new NeptusProperties(this.neptusConfig).load(this.config.getString("core.general-properties"));
        GeneralPreferences.generateImcId();
        this.systems = new SystemsManager(this.neptusConfig);
        this.imcDefinition = new IMCDefinition((InputStream)new FileInputStream(new File(this.config.getString("core.imc"))));
        this.imcManager = new ImcMsgManager(this.imcDefinition);
        this.imcManager.start();
        ImcMsgManager.registerBusListener(this.systems);
    }

    public NeptusConfig config() {
        return this.neptusConfig;
    }

    public SystemsManager systems() {
        return this.systems;
    }

    public IMCDefinition getIMCDefinition() {
        return this.imcDefinition;
    }
}

