/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus;

import java.io.File;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import pt.lsts.neptus.util.conf.GeneralPreferences;

public class NeptusLog {
    public static boolean extendedLog = true;
    private static final String NEPTUS_PUB = "Neptus.Pub";
    private static final String NEPTUS_ACTION = "Neptus.Action";
    private static final String NEPTUS_WASTE = "Neptus.Waste";
    private static Logger pub = Logger.getLogger((String)"Neptus.Pub");
    private static Logger action = Logger.getLogger((String)"Neptus.Action");
    private static Logger waste = Logger.getLogger((String)"Neptus.Waste");

    public static void init() {
        try {
            if (new File("conf/log4j.xml").exists()) {
                DOMConfigurator.configure((String)"conf/log4j.xml");
                pub.debug((Object)"Log4J configured with conf/log4j.xml!");
            } else {
                PropertyConfigurator.configure((String)"conf/log4j.properties");
                pub.debug((Object)"Log4J configured with conf/log4j.properties!");
            }
        }
        catch (Error e) {
            BasicConfigurator.configure();
            pub.warn((Object)"Could not configure Log4J with a default config, will try to load from configuration file!!");
        }
    }

    private static String getCallerStamp() {
        int idx;
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (stack.length <= (idx = 4)) {
            return "";
        }
        String str = stack[idx].getClassName() + "." + stack[idx].getMethodName();
        return str;
    }

    private static Logger getLogger(Logger fallbackLogger, String prefix) {
        String caller = NeptusLog.getCallerStamp();
        if (caller.length() == 0) {
            return fallbackLogger;
        }
        return Logger.getLogger((String)(prefix + "." + caller));
    }

    public static Logger pub() {
        return GeneralPreferences.programLogExtendedLog ? NeptusLog.getLogger(pub, NEPTUS_PUB) : pub;
    }

    public static Logger pubRoot() {
        return pub;
    }

    public static Logger action() {
        return GeneralPreferences.programLogExtendedLog ? NeptusLog.getLogger(action, NEPTUS_ACTION) : action;
    }

    public static Logger actRoot() {
        return action;
    }

    public static Logger waste() {
        return GeneralPreferences.programLogExtendedLog ? NeptusLog.getLogger(waste, NEPTUS_WASTE) : waste;
    }

    public static Logger wasteRoot() {
        return waste;
    }
}

