/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.app.tiles;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXStatusBar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.InfiniteProgressPanel;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.renderer2d.WorldRenderPainter;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.ColorUtils;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.MathMiscUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.output.OutputMonitor;

public class WorldMapPanel
extends JPanel {
    public static Icon NEPTUS_ICON = new ImageIcon(ImageUtils.getScaledImage("images/neptus-icon1.png", 32, 32));
    private Timer timer = null;
    private TimerTask timerTask = null;
    private JPanel headerPanel = null;
    private JPanel toolButtonsPanel;
    private JButton showOptionsDialog = null;
    private JButton addKMLFileButton = null;
    private JButton unloadAllKMLFilesButton = null;
    private JCheckBox showKMLItems = null;
    private StateRenderer2D renderer = null;
    private JXStatusBar statusBar = null;
    private JLabel levelOfDetailLabel;
    private JButton saveImageButton = null;
    private JButton copyImageButton = null;
    private JXBusyLabel busyPanel;
    private JButton zoomInButton;
    private JButton zoomOutButton;
    private JLabel memInfoLabel;
    private JLabel loadingTilesLabel;
    private JButton stopLoadingButton;
    private Renderer2DPainter kmlPainter = null;
    private MouseMotionListener rendererMouseMotionListener = null;
    private MouseListener rendererMouseListener = null;
    private KMLPlacemark infoBalloonFeature = null;
    private static File lastSuccessSavedDir = null;
    private static File lastSuccessKMLDir = null;
    private WorldRenderPainter worldRenderPainter = null;
    private JFrame jFrame;
    private JInternalFrame jInternalFrame;
    @NeptusProperty
    public LocationType center = new LocationType();
    @NeptusProperty
    public int levelOfDetail = 7;
    @NeptusProperty
    public String kmlFiles = "";
    private Map<String, Vector<KMLPlacemark>> placemarksHolder = Collections.synchronizedMap(new LinkedHashMap());
    private DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
    private static final String ROOT_PREFIX;
    private boolean mouseActive;

    public WorldMapPanel() {
        String[] kfl;
        this.docBuilderFactory.setIgnoringComments(true);
        this.docBuilderFactory.setIgnoringElementContentWhitespace(true);
        this.docBuilderFactory.setNamespaceAware(false);
        try {
            String confFx = ROOT_PREFIX + "conf/" + WorldMapPanel.class.getSimpleName().toLowerCase() + ".properties";
            if (new File(confFx).exists()) {
                PluginUtils.loadProperties(confFx, (Object)this);
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)("Not possible to open \"conf/" + WorldMapPanel.class.getSimpleName().toLowerCase() + ".properties\""));
            NeptusLog.pub().debug((Object)e, (Throwable)e);
        }
        Vector<String> validFiles = new Vector<String>();
        for (String path : kfl = this.kmlFiles.split(",")) {
            File file = new File(path.trim());
            if (!file.exists()) continue;
            validFiles.add(path.trim());
            lastSuccessKMLDir = file;
            Vector<KMLPlacemark> placemarks = this.getPlacemarksFromKML(file);
            if (placemarks.size() <= 0) continue;
            String kmlName = file.getName().replaceFirst("((\\.[kK][mM][lL]))$", "");
            this.placemarksHolder.put(kmlName, placemarks);
        }
        this.kmlFiles = "";
        for (String path : validFiles.toArray(new String[validFiles.size()])) {
            this.kmlFiles = this.kmlFiles + (this.kmlFiles.length() > 0 ? "," + path : path);
        }
        this.mouseActive = false;
        this.initialize();
    }

    public WorldMapPanel(LocationType center) {
        String[] kfl;
        this.docBuilderFactory.setIgnoringComments(true);
        this.docBuilderFactory.setIgnoringElementContentWhitespace(true);
        this.docBuilderFactory.setNamespaceAware(false);
        try {
            String confFx = ROOT_PREFIX + "conf/" + WorldMapPanel.class.getSimpleName().toLowerCase() + ".properties";
            if (new File(confFx).exists()) {
                PluginUtils.loadProperties(confFx, (Object)this);
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)("Not possible to open \"conf/" + WorldMapPanel.class.getSimpleName().toLowerCase() + ".properties\""));
            NeptusLog.pub().debug((Object)e, (Throwable)e);
        }
        Vector<String> validFiles = new Vector<String>();
        for (String path : kfl = this.kmlFiles.split(",")) {
            File file = new File(path.trim());
            if (!file.exists()) continue;
            validFiles.add(path.trim());
            lastSuccessKMLDir = file;
            Vector<KMLPlacemark> placemarks = this.getPlacemarksFromKML(file);
            if (placemarks.size() <= 0) continue;
            String kmlName = file.getName().replaceFirst("((\\.[kK][mM][lL]))$", "");
            this.placemarksHolder.put(kmlName, placemarks);
        }
        this.kmlFiles = "";
        for (String path : validFiles.toArray(new String[validFiles.size()])) {
            this.kmlFiles = this.kmlFiles + (this.kmlFiles.length() > 0 ? "," + path : path);
        }
        this.mouseActive = false;
        this.center = center;
        this.initialize();
    }

    private void initialize() {
        this.showOptionsDialog = new JButton(new AbstractAction("Preferences"){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorldMapPanel.this.worldRenderPainter.showChooseMapStyleDialog(WorldMapPanel.this);
            }
        });
        this.addKMLFileButton = new JButton(new AbstractAction("Add KML File"){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorldMapPanel.this.addKMLFileButton.setEnabled(false);
                SwingWorker<Void, Void> sw = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        JFileChooser fc = WorldMapPanel.this.createFileKMLChooser("Choose a KML File");
                        fc.setFileSelectionMode(0);
                        int option = fc.showOpenDialog(WorldMapPanel.this);
                        if (0 == option) {
                            File file = fc.getSelectedFile();
                            lastSuccessKMLDir = file;
                            Vector placemarks = WorldMapPanel.this.getPlacemarksFromKML(file);
                            if (placemarks.size() > 0) {
                                String kmlName = file.getName().replaceFirst("((\\.[kK][mM][lL]))$", "");
                                WorldMapPanel.this.placemarksHolder.put(kmlName, placemarks);
                                String[] fxs = WorldMapPanel.this.kmlFiles.split(",");
                                Vector<String> fxsv = new Vector<String>();
                                for (String path : fxs) {
                                    if (fxsv.contains(path)) continue;
                                    fxsv.add(path);
                                }
                                if (!fxsv.contains(file.getPath())) {
                                    fxsv.add(file.getPath());
                                }
                                WorldMapPanel.this.kmlFiles = "";
                                for (String path : fxsv.toArray(new String[fxsv.size()])) {
                                    WorldMapPanel.this.kmlFiles = WorldMapPanel.this.kmlFiles + (WorldMapPanel.this.kmlFiles.length() > 0 ? "," + path : path);
                                }
                            }
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e);
                        }
                        WorldMapPanel.this.addKMLFileButton.setEnabled(true);
                    }
                };
                sw.execute();
            }
        });
        this.unloadAllKMLFilesButton = new JButton(new AbstractAction("Unload all KML Files"){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorldMapPanel.this.unloadAllKMLFilesButton.setEnabled(false);
                SwingWorker<Void, Void> sw = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        WorldMapPanel.this.infoBalloonFeature = null;
                        WorldMapPanel.this.placemarksHolder.clear();
                        WorldMapPanel.this.kmlFiles = "";
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e);
                        }
                        WorldMapPanel.this.unloadAllKMLFilesButton.setEnabled(true);
                    }
                };
                sw.execute();
            }
        });
        this.showKMLItems = new JCheckBox("Show KML Objects");
        this.showKMLItems.setSelected(true);
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(3);
        this.toolButtonsPanel = new JPanel();
        this.toolButtonsPanel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this.toolButtonsPanel.setLayout(flowLayout);
        this.toolButtonsPanel.setSize(8, 8);
        this.toolButtonsPanel.add(new JLabel(NEPTUS_ICON));
        this.toolButtonsPanel.add(Box.createHorizontalStrut(10));
        this.toolButtonsPanel.add(this.showOptionsDialog);
        this.toolButtonsPanel.add(Box.createHorizontalStrut(10));
        this.toolButtonsPanel.add(this.addKMLFileButton);
        this.toolButtonsPanel.add(this.unloadAllKMLFilesButton);
        this.toolButtonsPanel.add(this.showKMLItems);
        this.headerPanel = new JPanel();
        this.headerPanel.setLayout(new BoxLayout(this.headerPanel, 1));
        this.headerPanel.add(this.toolButtonsPanel);
        this.renderer = new StateRenderer2D(this.center){

            @Override
            protected void init() {
                super.init();
                block2: while (WorldMapPanel.this.worldRenderPainter == null) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        NeptusLog.pub().error((Object)e.getMessage());
                    }
                    for (Renderer2DPainter painter : this.painters.getPreRenderPainters()) {
                        if (!(painter instanceof WorldRenderPainter)) continue;
                        WorldMapPanel.this.worldRenderPainter = (WorldRenderPainter)painter;
                        continue block2;
                    }
                }
            }
        };
        this.renderer.setLevelOfDetail(this.levelOfDetail);
        this.renderer.setMapCenterShow(false);
        this.renderer.addPostRenderPainter(this.getKMLPainter(), "KML Painter");
        this.renderer.addMouseListener(this.getRendererMouseListener());
        this.renderer.addMouseMotionListener(this.getRendererMouseMotionListener());
        this.worldRenderPainter.setShowOnScreenControls(false);
        this.worldRenderPainter.setUseTransparency(false);
        this.levelOfDetailLabel = new JLabel("Zoom Level: " + this.levelOfDetail);
        this.zoomInButton = new JButton(new AbstractAction("+"){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorldMapPanel.this.renderer.zoomIn();
            }
        });
        this.zoomOutButton = new JButton(new AbstractAction("-"){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorldMapPanel.this.renderer.zoomOut();
            }
        });
        this.memInfoLabel = new JLabel();
        this.loadingTilesLabel = new JLabel();
        this.stopLoadingButton = new JButton(new AbstractAction("Stop"){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorldRenderPainter.clearMemCache();
            }
        });
        this.saveImageButton = new JButton(new AbstractAction("Save Image"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BufferedImage image = new BufferedImage(WorldMapPanel.this.renderer.getWidth(), WorldMapPanel.this.renderer.getHeight(), 1);
                Graphics2D g2 = (Graphics2D)image.getGraphics();
                g2.setColor(Color.LIGHT_GRAY);
                g2.fillRect(0, 0, image.getWidth(), image.getHeight());
                WorldMapPanel.this.worldRenderPainter.paint((Graphics2D)image.getGraphics(), WorldMapPanel.this.renderer, false);
                JFileChooser fc = WorldMapPanel.this.createFileChooser("Save image as");
                fc.setFileSelectionMode(0);
                int option = fc.showSaveDialog(WorldMapPanel.this);
                File file = null;
                if (0 != option) {
                    return;
                }
                file = fc.getSelectedFile();
                try {
                    String ext = FileUtil.getFileExtension(file);
                    if (!ext.toLowerCase().equalsIgnoreCase("png")) {
                        file = new File(file.getParent(), ext.equalsIgnoreCase("") ? file.getName() + ".png" : file.getName().replaceFirst("\\." + ext + "$", ".png"));
                    }
                    ImageIO.write((RenderedImage)image, "png", file);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.copyImageButton = new JButton(new AbstractAction("Copy Image"){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorldMapPanel.this.copyImageButton.setEnabled(false);
                final BufferedImage image = new BufferedImage(WorldMapPanel.this.renderer.getWidth(), WorldMapPanel.this.renderer.getHeight(), 1);
                Graphics2D g2 = (Graphics2D)image.getGraphics();
                g2.setColor(Color.LIGHT_GRAY);
                g2.fillRect(0, 0, image.getWidth(), image.getHeight());
                WorldMapPanel.this.worldRenderPainter.paint((Graphics2D)image.getGraphics(), WorldMapPanel.this.renderer, false);
                SwingWorker<Void, Void> sworker = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        ClipboardOwner owner = new ClipboardOwner(){

                            @Override
                            public void lostOwnership(Clipboard clipboard, Transferable contents) {
                            }
                        };
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new Transferable(){
                            DataFlavor df = DataFlavor.imageFlavor;

                            @Override
                            public boolean isDataFlavorSupported(DataFlavor flavor) {
                                return this.df.equals(flavor);
                            }

                            @Override
                            public DataFlavor[] getTransferDataFlavors() {
                                return new DataFlavor[]{this.df};
                            }

                            @Override
                            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                                return image;
                            }
                        }, owner);
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e);
                        }
                        WorldMapPanel.this.copyImageButton.setEnabled(true);
                    }
                };
                sworker.run();
            }
        });
        this.busyPanel = InfiniteProgressPanel.createBusyAnimationInfiniteBeans(20);
        this.statusBar = new JXStatusBar();
        this.statusBar.add((Component)this.levelOfDetailLabel);
        this.statusBar.add((Component)this.zoomInButton);
        this.statusBar.add((Component)this.zoomOutButton);
        this.statusBar.add((Component)this.memInfoLabel, (Object)JXStatusBar.Constraint.ResizeBehavior.FILL);
        this.statusBar.add((Component)this.saveImageButton);
        this.statusBar.add((Component)this.copyImageButton);
        this.statusBar.add((Component)this.loadingTilesLabel);
        this.statusBar.add((Component)this.stopLoadingButton);
        this.statusBar.add((Component)this.busyPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.headerPanel, "North");
        this.add((Component)this.renderer, "Center");
        this.add((Component)this.statusBar, "South");
        this.getTimer().scheduleAtFixedRate(this.getTimerTask(), 500L, 200L);
    }

    public StateRenderer2D getRenderer() {
        return this.renderer;
    }

    private Renderer2DPainter getKMLPainter() {
        if (this.kmlPainter == null) {
            this.kmlPainter = new Renderer2DPainter(){

                @Override
                public void paint(Graphics2D g, StateRenderer2D renderer) {
                    if (!WorldMapPanel.this.showKMLItems.isSelected()) {
                        return;
                    }
                    for (String kmlFileName : WorldMapPanel.this.placemarksHolder.keySet().toArray(new String[WorldMapPanel.this.placemarksHolder.keySet().size()])) {
                        Vector vecPlacemarks = (Vector)WorldMapPanel.this.placemarksHolder.get(kmlFileName);
                        for (KMLPlacemark kmlPlacemark : vecPlacemarks) {
                            if (!kmlPlacemark.visibility) continue;
                            Graphics2D g2 = (Graphics2D)g.create();
                            LocationType loc = new LocationType();
                            loc.setLatitudeDegs(kmlPlacemark.latDegrees);
                            loc.setLongitudeDegs(kmlPlacemark.lonDegrees);
                            Point2D pointXY = renderer.getScreenPosition(loc);
                            g2.translate(pointXY.getX(), pointXY.getY());
                            GeneralPath pointer = new GeneralPath();
                            int upOff = -10;
                            int leftOff = -5;
                            int leafOff = 10;
                            pointer.moveTo(leftOff, upOff);
                            pointer.lineTo(0.0f, 0.0f);
                            pointer.lineTo(-leftOff, upOff);
                            pointer.curveTo(-leftOff, upOff - leafOff, leftOff, upOff - leafOff, leftOff, upOff);
                            pointer.closePath();
                            g2.setColor(ColorUtils.setTransparencyToColor(Color.GREEN, 160));
                            g2.fill(pointer);
                            g2.setColor(ColorUtils.setTransparencyToColor(Color.BLACK, 160));
                            Stroke oldStroke = g2.getStroke();
                            g2.setStroke(new BasicStroke(2.0f));
                            g2.draw(pointer);
                            g2.setStroke(oldStroke);
                            g2.setColor(ColorUtils.setTransparencyToColor(Color.GREEN, 200));
                            g2.drawString(kmlPlacemark.name, -1, 15);
                            g2.drawString(kmlPlacemark.name, -3, 15);
                            g2.setColor(ColorUtils.setTransparencyToColor(Color.BLACK, 200));
                            g2.drawString(kmlPlacemark.name, -2, 14);
                            g2.dispose();
                        }
                    }
                    if (WorldMapPanel.this.infoBalloonFeature != null && ((WorldMapPanel)WorldMapPanel.this).infoBalloonFeature.visibility) {
                        String txt = ((WorldMapPanel)WorldMapPanel.this).infoBalloonFeature.description != null ? ((WorldMapPanel)WorldMapPanel.this).infoBalloonFeature.description : "<html><b>" + ((WorldMapPanel)WorldMapPanel.this).infoBalloonFeature.name + "</b>" + (((WorldMapPanel)WorldMapPanel.this).infoBalloonFeature.address != null ? "<br>" + ((WorldMapPanel)WorldMapPanel.this).infoBalloonFeature.address : "") + (((WorldMapPanel)WorldMapPanel.this).infoBalloonFeature.phoneNumber != null ? "<br>" + ((WorldMapPanel)WorldMapPanel.this).infoBalloonFeature.phoneNumber : "");
                        JEditorPane label = new JEditorPane();
                        label.setEditable(false);
                        label.setBackground(Color.white);
                        label.addHyperlinkListener(new HyperlinkListener(){

                            @Override
                            public void hyperlinkUpdate(HyperlinkEvent e) {
                                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                                    return;
                                }
                            }
                        });
                        label.setContentType("text/html");
                        label.setText(txt);
                        label.setOpaque(true);
                        label.setBackground(ColorUtils.setTransparencyToColor(Color.WHITE, 200));
                        label.setForeground(ColorUtils.setTransparencyToColor(Color.BLACK, 200));
                        Graphics2D g2 = (Graphics2D)g.create();
                        Dimension dim = label.getPreferredSize();
                        Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, dim.getWidth(), dim.getHeight());
                        label.setBorder(new EmptyBorder(5, 5, 5, 5));
                        label.setBounds((int)(-((RectangularShape)bounds).getWidth() - 5.0), (int)(-((RectangularShape)bounds).getHeight() - 5.0), (int)(((RectangularShape)bounds).getWidth() + 10.0), (int)(((RectangularShape)bounds).getHeight() + 10.0));
                        LocationType loc = new LocationType();
                        loc.setLatitudeDegs(((WorldMapPanel)WorldMapPanel.this).infoBalloonFeature.latDegrees);
                        loc.setLongitudeDegs(((WorldMapPanel)WorldMapPanel.this).infoBalloonFeature.lonDegrees);
                        Point2D pointXY = renderer.getScreenPosition(loc);
                        g2.translate(pointXY.getX(), pointXY.getY());
                        int offsetX = 20;
                        int offsetY = -20;
                        int boxBorderSize = 10;
                        Polygon pointerShape = new Polygon(new int[]{0, offsetX, offsetX + (int)Math.signum(offsetX) * 20}, new int[]{0, offsetY + -((int)Math.signum(offsetY)) * boxBorderSize, offsetY + -((int)Math.signum(offsetY)) * boxBorderSize}, 3);
                        g2.setColor(ColorUtils.setTransparencyToColor(Color.WHITE, 200));
                        g2.fill(pointerShape);
                        g2.translate((double)offsetX, (double)offsetY - ((RectangularShape)bounds).getHeight());
                        label.paint(g2);
                        g2.translate((double)(-offsetX), -((double)offsetY - ((RectangularShape)bounds).getHeight()));
                        g2.dispose();
                    }
                }
            };
        }
        return this.kmlPainter;
    }

    private MouseListener getRendererMouseListener() {
        if (this.rendererMouseListener == null) {
            this.rendererMouseListener = new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!WorldMapPanel.this.mouseActive) {
                        return;
                    }
                    if (e.getButton() != 1) {
                        return;
                    }
                    WorldMapPanel.this.infoBalloonFeature = null;
                    int offSet = 20;
                    int offSetDiv2 = offSet / 2;
                    block0: for (String key : WorldMapPanel.this.placemarksHolder.keySet().toArray(new String[WorldMapPanel.this.placemarksHolder.keySet().size()])) {
                        for (KMLPlacemark pmk : (Vector)WorldMapPanel.this.placemarksHolder.get(key)) {
                            if (!pmk.visibility) continue;
                            LocationType loc = new LocationType();
                            loc.setLatitudeDegs(pmk.latDegrees);
                            loc.setLongitudeDegs(pmk.lonDegrees);
                            Point2D pointXY = WorldMapPanel.this.renderer.getScreenPosition(loc);
                            Rectangle2D.Double bbox = new Rectangle2D.Double(pointXY.getX() - (double)offSetDiv2, pointXY.getY() - (double)offSetDiv2, offSet, offSet);
                            if (!bbox.contains(e.getPoint())) continue;
                            WorldMapPanel.this.infoBalloonFeature = pmk;
                            continue block0;
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    WorldMapPanel.this.mouseActive = true;
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    WorldMapPanel.this.mouseActive = false;
                }
            };
        }
        return this.rendererMouseListener;
    }

    private MouseMotionListener getRendererMouseMotionListener() {
        if (this.rendererMouseMotionListener == null) {
            this.rendererMouseMotionListener = new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (!WorldMapPanel.this.mouseActive) {
                        return;
                    }
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                }
            };
        }
        return this.rendererMouseMotionListener;
    }

    public void dispose() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    public Timer getTimer() {
        if (this.timer == null) {
            this.timer = new Timer(WorldMapPanel.class.getSimpleName() + " [" + Integer.toHexString(this.hashCode()) + "]", true);
        }
        return this.timer;
    }

    public TimerTask getTimerTask() {
        if (this.timerTask == null) {
            this.timerTask = new TimerTask(){

                @Override
                public void run() {
                    WorldMapPanel.this.center.setLocation(WorldMapPanel.this.renderer.getCenter());
                    WorldMapPanel.this.levelOfDetail = WorldMapPanel.this.renderer.getLevelOfDetail();
                    long nlt = WorldRenderPainter.getNumberOfLoadingMapTiles();
                    long nlt1 = WorldRenderPainter.getNumberOfLoadedMapTiles();
                    WorldMapPanel.this.levelOfDetailLabel.setText("Zoom Level: " + WorldMapPanel.this.levelOfDetail);
                    WorldMapPanel.this.memInfoLabel.setText("Free Memory: " + MathMiscUtils.parseToEngineeringRadix2Notation(Runtime.getRuntime().freeMemory(), 1) + "B of " + MathMiscUtils.parseToEngineeringRadix2Notation(Runtime.getRuntime().totalMemory(), 1) + "B");
                    WorldMapPanel.this.loadingTilesLabel.setText("Tiles Loading: " + nlt + " of " + nlt1);
                    WorldMapPanel.this.busyPanel.setVisible(nlt != 0L);
                    WorldMapPanel.this.busyPanel.setBusy(nlt != 0L);
                    WorldMapPanel.this.invalidate();
                    WorldMapPanel.this.validate();
                    WorldMapPanel.this.repaint();
                    WorldMapPanel.this.renderer.repaint();
                }
            };
        }
        return this.timerTask;
    }

    public synchronized void savePropertiesToDisk() {
        try {
            PluginUtils.saveProperties(ROOT_PREFIX + "conf/" + WorldMapPanel.class.getSimpleName().toLowerCase() + ".properties", this);
        }
        catch (Exception e) {
            NeptusLog.pub().debug((Object)e.getMessage());
            NeptusLog.pub().error((Object)("Not possible to open \"conf/" + WorldMapPanel.class.getSimpleName().toLowerCase() + ".properties\""));
        }
    }

    private JFrame getJFrame(String title) {
        String defaultTitle = WorldMapPanel.class.getSimpleName();
        this.jFrame = title == null ? new JFrame(defaultTitle) : (title.equalsIgnoreCase("") ? new JFrame(defaultTitle) : new JFrame(title));
        this.jFrame.setPreferredSize(new Dimension(880, 600));
        this.jFrame.getContentPane().setLayout(new BorderLayout());
        this.jFrame.getContentPane().add(this);
        this.jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WorldMapPanel.this.savePropertiesToDisk();
                WorldMapPanel.this.hideFrame();
            }
        });
        GuiUtils.centerOnScreen(this.jFrame);
        this.jFrame.setIconImages(ConfigFetch.getIconImagesForFrames());
        this.jFrame.setVisible(true);
        return this.jFrame;
    }

    private void hideFrame() {
        if (this.jFrame != null) {
            this.jFrame.setVisible(false);
            this.jFrame.dispose();
        }
        if (this.jInternalFrame != null) {
            this.jInternalFrame.setVisible(false);
            this.jInternalFrame.doDefaultCloseAction();
            this.jInternalFrame.dispose();
        }
        this.dispose();
    }

    public void setJInternalFrame(JInternalFrame internalFrame) {
        this.jInternalFrame = internalFrame;
        this.jInternalFrame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
            }
        });
    }

    private JFileChooser createFileChooser(String name) {
        JFileChooser fc = new JFileChooser();
        fc.setName(name);
        fc.setFileFilter(new FileNameExtensionFilter("PNG images", "png", "PNG"));
        fc.setMultiSelectionEnabled(false);
        File last = new File(".");
        if (lastSuccessSavedDir != null && lastSuccessSavedDir.exists()) {
            last = lastSuccessSavedDir.isDirectory() ? lastSuccessSavedDir : lastSuccessSavedDir.getParentFile();
        }
        fc.setCurrentDirectory(last);
        return fc;
    }

    private JFileChooser createFileKMLChooser(String name) {
        JFileChooser fc = new JFileChooser();
        fc.setName(name);
        fc.setFileFilter(new FileNameExtensionFilter("KML File", "kml", "KML"));
        fc.setMultiSelectionEnabled(false);
        File last = new File(".");
        if (lastSuccessKMLDir != null && lastSuccessKMLDir.exists()) {
            last = lastSuccessKMLDir.isDirectory() ? lastSuccessKMLDir : lastSuccessKMLDir.getParentFile();
        }
        fc.setCurrentDirectory(last);
        return fc;
    }

    private Vector<KMLPlacemark> getPlacemarksFromKML(File kmlFile) {
        Vector<KMLPlacemark> ret = new Vector<KMLPlacemark>();
        try {
            DocumentBuilder builder = this.docBuilderFactory.newDocumentBuilder();
            FileInputStream fis = new FileInputStream(kmlFile);
            Document docProfiles = builder.parse(fis);
            Element root = docProfiles.getDocumentElement();
            NodeList placemarkList = root.getElementsByTagName("Placemark");
            for (int i = 0; i < placemarkList.getLength(); ++i) {
                NodeList nameNd;
                String name;
                NodeList nameNdLst;
                Element placeMarkNd = (Element)placemarkList.item(i);
                String idAttStr = placeMarkNd.getAttribute("id");
                String id = null;
                if (idAttStr != null && !"".equalsIgnoreCase(idAttStr)) {
                    id = idAttStr;
                }
                if ((nameNdLst = placeMarkNd.getElementsByTagName("name")).getLength() < 1 || (name = ((Element)nameNdLst.item(0)).getTextContent()) == null || "".equalsIgnoreCase(name)) continue;
                if (id == null) {
                    id = name;
                }
                KMLPlacemark pmk = new KMLPlacemark(id, name);
                Node parentNd = placeMarkNd.getParentNode();
                if (parentNd != null && "Folder".equalsIgnoreCase(parentNd.getNodeName()) && (nameNd = ((Element)parentNd).getElementsByTagName("name")).getLength() > 0) {
                    String nameP;
                    pmk.folder = nameP = ((Element)nameNd.item(0)).getNodeValue();
                }
                boolean errorState = false;
                for (Node bn = placeMarkNd.getFirstChild(); bn != null; bn = bn.getNextSibling()) {
                    try {
                        String dName;
                        if ("styleUrl".equalsIgnoreCase(bn.getNodeName())) {
                            try {
                                pmk.styleUrl = dName = bn.getTextContent();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        if ("visibility".equalsIgnoreCase(bn.getNodeName())) {
                            try {
                                dName = bn.getTextContent();
                                pmk.visibility = this.extractAsBoolean(dName);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        if ("address".equalsIgnoreCase(bn.getNodeName())) {
                            try {
                                pmk.address = dName = bn.getTextContent();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        if ("phoneNumber".equalsIgnoreCase(bn.getNodeName())) {
                            try {
                                pmk.phoneNumber = dName = bn.getTextContent();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        if ("description".equalsIgnoreCase(bn.getNodeName())) {
                            try {
                                pmk.description = dName = bn.getTextContent();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        if (!"Point".equalsIgnoreCase(bn.getNodeName())) continue;
                        for (Node cn = bn.getFirstChild(); cn != null; cn = cn.getNextSibling()) {
                            if (!"coordinates".equalsIgnoreCase(cn.getNodeName())) continue;
                            try {
                                String dName2 = cn.getTextContent();
                                double[] pointCoord = this.extractPointCoordinates(dName2);
                                pmk.latDegrees = pointCoord[0];
                                pmk.lonDegrees = pointCoord[1];
                                pmk.altitude = pointCoord[2];
                                continue;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                errorState = true;
                            }
                        }
                        continue;
                    }
                    catch (Exception e) {
                        NeptusLog.pub().debug((Object)e.getMessage());
                        errorState = true;
                    }
                }
                if (errorState) continue;
                ret.add(pmk);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    private double[] extractPointCoordinates(String value) throws ArrayIndexOutOfBoundsException, NumberFormatException {
        String[] sValues = value.split(",");
        if (sValues.length < 2) {
            throw new ArrayIndexOutOfBoundsException("At least 2 values are mandatory, found " + sValues.length);
        }
        double[] ret = new double[]{Double.parseDouble(sValues[1]), Double.parseDouble(sValues[0]), sValues.length < 3 ? 0.0 : Double.parseDouble(sValues[2])};
        return ret;
    }

    private boolean extractAsBoolean(String value) {
        if ("1".equalsIgnoreCase(value)) {
            value = "true";
        } else if ("0".equalsIgnoreCase(value)) {
            value = "false";
        }
        boolean boolValue = Boolean.parseBoolean(value);
        return boolValue;
    }

    public static void main(String[] args) {
        try {
            OutputMonitor.setDisable(true);
            Logger.getRootLogger().setLevel(Level.FATAL);
            NeptusLog.pubRoot().setLevel(Level.FATAL);
            ConfigFetch.initialize();
            Logger.getRootLogger().setLevel(Level.FATAL);
            NeptusLog.wasteRoot().setLevel(Level.OFF);
            NeptusLog.pubRoot().setLevel(Level.FATAL);
            if (ConfigFetch.isOSEqual((short)1)) {
                GuiUtils.setLookAndFeel();
            } else {
                GuiUtils.setSystemLookAndFeel();
            }
            PluginUtils.loadPlugins();
            WorldMapPanel panel = new WorldMapPanel();
            panel.getJFrame(null);
            panel.jFrame.setDefaultCloseOperation(3);
            panel.jFrame.setSize(790, 580);
            GuiUtils.centerOnScreen(panel.jFrame);
        }
        catch (Error | Exception e) {
            e.printStackTrace();
        }
    }

    static {
        if (new File("../conf").exists()) {
            ROOT_PREFIX = "../";
        } else {
            ROOT_PREFIX = "";
            new File("conf").mkdir();
        }
    }

    private static class KMLPlacemark
    extends KMLFeatureAbstractType {
        public double latDegrees = 0.0;
        public double lonDegrees = 0.0;
        public double altitude = 0.0;

        public KMLPlacemark(String id, String name) {
            super(id, name);
        }

        public KMLPlacemark(String name) {
            super(name);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof KMLPlacemark) {
                return this.id.equals(((KMLPlacemark)obj).id);
            }
            return false;
        }
    }

    private static class KMLFeatureAbstractType {
        public final String id;
        public String name;
        public boolean visibility = true;
        public String address = null;
        public String phoneNumber = null;
        public String description = null;
        public String styleUrl = null;
        public String folder = null;

        public KMLFeatureAbstractType(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public KMLFeatureAbstractType(String name) {
            this.id = name;
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (obj instanceof KMLFeatureAbstractType) {
                return this.id.equals(((KMLFeatureAbstractType)obj).id);
            }
            return false;
        }
    }
}

