/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.colormap;

import java.awt.Point;
import java.util.ArrayList;

class CHull {
    CHull() {
    }

    private static int distance(Point p1, Point p2, Point p3) {
        int x1 = p1.x;
        int x2 = p2.x;
        int x3 = p3.x;
        int y1 = p1.y;
        int y2 = p2.y;
        int y3 = p3.y;
        return x1 * y2 + x3 * y1 + x2 * y3 - x3 * y2 - x2 * y1 - x1 * y3;
    }

    static ArrayList<Point> cHull(ArrayList<Point> array) {
        int size = array.size();
        if (size < 2) {
            return null;
        }
        Point l = array.get(0);
        Point r = array.get(size - 1);
        ArrayList<Point> path = new ArrayList<Point>();
        path.add(l);
        CHull.cHull(array, l, r, path);
        path.add(r);
        CHull.cHull(array, r, l, path);
        return path;
    }

    static void cHull(ArrayList<Point> points, Point l, Point r, ArrayList<Point> path) {
        if (points.size() < 3) {
            return;
        }
        int maxDist = 0;
        Point p = null;
        for (Point pt : points) {
            int tmp;
            if (pt == l || pt == r || (tmp = CHull.distance(l, r, pt)) <= maxDist) continue;
            maxDist = tmp;
            p = pt;
        }
        if (p == null) {
            return;
        }
        ArrayList<Point> left = new ArrayList<Point>();
        ArrayList<Point> right = new ArrayList<Point>();
        left.add(l);
        right.add(p);
        for (Point pt : points) {
            if (CHull.distance(l, p, pt) > 0) {
                left.add(pt);
                continue;
            }
            if (CHull.distance(p, r, pt) <= 0) continue;
            right.add(pt);
        }
        left.add(p);
        right.add(r);
        CHull.cHull(left, l, p, path);
        path.add(p);
        CHull.cHull(right, p, r, path);
    }
}

