/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.colormap;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.util.GuiUtils;

public class ColorBar
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int HORIZONTAL_ORIENTATION = 0;
    public static final int VERTICAL_ORIENTATION = 1;
    int orientation = 0;
    ColorMap cmap = ColorMapFactory.createGrayScaleColorMap();
    BufferedImage cachedImage = new BufferedImage(1, 1, 2);

    public ColorBar() {
        this.setBorder(BorderFactory.createBevelBorder(1));
    }

    public ColorBar(int orientation) {
        this();
        this.orientation = orientation;
    }

    public ColorBar(int orientation, ColorMap cmap) {
        this();
        this.orientation = orientation;
        this.setCmap(cmap);
    }

    @Override
    public void paint(Graphics g) {
        if (this.getWidth() != this.cachedImage.getWidth() || this.getHeight() != this.cachedImage.getHeight()) {
            int i;
            this.cachedImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            Graphics2D g2d = (Graphics2D)this.cachedImage.getGraphics();
            if (this.orientation == 0) {
                for (i = 0; i < this.cachedImage.getWidth(); ++i) {
                    double pos = (double)i / (double)this.cachedImage.getWidth();
                    g2d.setColor(this.cmap.getColor(pos));
                    g2d.drawLine(i, 0, i, this.cachedImage.getHeight());
                }
            }
            if (this.orientation == 1) {
                for (i = 0; i < this.cachedImage.getHeight(); ++i) {
                    g2d.setColor(this.cmap.getColor((double)i / (double)this.cachedImage.getHeight()));
                    g2d.drawLine(0, this.cachedImage.getHeight() - i, this.cachedImage.getWidth(), this.cachedImage.getHeight() - i);
                }
            }
        }
        g.drawImage(this.cachedImage, 0, 0, null);
    }

    public ColorMap getCmap() {
        return this.cmap;
    }

    public void setCmap(ColorMap cmap) {
        this.cmap = cmap;
    }

    public static void main(String[] args) {
        GuiUtils.testFrame(new ColorBar(0, ColorMapFactory.createAllColorsColorMap()), "Spring", 400, 75);
        GuiUtils.testFrame(new ColorBar(0, ColorMapFactory.createHotColorMap()), "Hot", 400, 75);
        GuiUtils.testFrame(new ColorBar(0, ColorMapFactory.createJetColorMap()), "Jet", 400, 75);
        GuiUtils.testFrame(new ColorBar(0, ColorMapFactory.createBoneColorMap()), "Bone", 400, 75);
        GuiUtils.testFrame(new ColorBar(0, ColorMapFactory.createGrayScaleColorMap()), "Gray", 400, 75);
    }
}

