/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.colormap;

import java.awt.Color;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Vector;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.colormap.ColorBar;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.InterpolationColorMap;
import pt.lsts.neptus.colormap.TabulatedColorMap;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.GuiUtils;

public class ColorMapFactory {
    public static Vector<String> colorMapNamesList = new Vector();
    private static ColorMap storeDataColormap;
    private static ColorMap grayscale;
    private static ColorMap white;
    private static ColorMap hot;
    private static ColorMap allColors;
    private static ColorMap rgb;
    private static ColorMap bluered;
    private static ColorMap autumn;
    private static ColorMap cool;
    private static ColorMap jet;
    private static ColorMap spring;
    private static ColorMap bone;
    private static ColorMap copper;
    private static ColorMap summer;
    private static ColorMap winter;
    private static ColorMap pink;
    private static ColorMap greenradar;
    private static ColorMap redYellowGreen;
    private static ColorMap rainbow;
    private static ColorMap bronze;
    private static ColorMap sscanmap;

    private ColorMapFactory() {
    }

    public static ColorMap getColorMapByName(String name) {
        if ("autumn".equalsIgnoreCase(name)) {
            return ColorMapFactory.createAutumnColorMap();
        }
        if ("bone".equalsIgnoreCase(name)) {
            return ColorMapFactory.createBoneColorMap();
        }
        if ("cool".equalsIgnoreCase(name)) {
            return ColorMapFactory.createCoolColorMap();
        }
        if ("copper".equalsIgnoreCase(name)) {
            return ColorMapFactory.createCopperColorMap();
        }
        if ("gray".equalsIgnoreCase(name)) {
            return ColorMapFactory.createGrayScaleColorMap();
        }
        if ("hot".equalsIgnoreCase(name)) {
            return ColorMapFactory.createHotColorMap();
        }
        if ("jet".equalsIgnoreCase(name)) {
            return ColorMapFactory.createJetColorMap();
        }
        if ("pink".equalsIgnoreCase(name)) {
            return ColorMapFactory.createPinkColorMap();
        }
        if ("spring".equalsIgnoreCase(name)) {
            return ColorMapFactory.createSpringColorMap();
        }
        if ("summer".equalsIgnoreCase(name)) {
            return ColorMapFactory.createSummerColorMap();
        }
        if ("winter".equalsIgnoreCase(name)) {
            return ColorMapFactory.createWinterColorMap();
        }
        if ("allColors".equalsIgnoreCase(name)) {
            return ColorMapFactory.createAllColorsColorMap();
        }
        if ("redGreenBlue".equalsIgnoreCase(name)) {
            return ColorMapFactory.createRedGreenBlueColorMap();
        }
        if ("blueToRed".equalsIgnoreCase(name)) {
            return ColorMapFactory.createRedGreenBlueColorMap();
        }
        if ("white".equalsIgnoreCase(name)) {
            return ColorMapFactory.createWhiteColorMap();
        }
        if ("greenRadar".equalsIgnoreCase(name)) {
            return ColorMapFactory.createGreenRadarColorMap();
        }
        if ("rainbow".equalsIgnoreCase(name)) {
            return ColorMapFactory.createRainbowColormap();
        }
        if ("redYellowGreen".equalsIgnoreCase(name)) {
            return ColorMapFactory.createRedYellowGreenColorMap();
        }
        if ("bronze".equalsIgnoreCase(name)) {
            return ColorMapFactory.createBronzeColormap();
        }
        for (int i = 0; i < ColorMap.cmaps.length; ++i) {
            if (!ColorMap.cmaps[i].toString().equalsIgnoreCase(name)) continue;
            return ColorMap.cmaps[i];
        }
        return ColorMapFactory.createJetColorMap();
    }

    public static ColorMap createStoreDataColormap() {
        if (storeDataColormap == null) {
            storeDataColormap = new InterpolationColorMap(I18n.text("Store Data Colormap"), new double[]{0.0, 0.333333, 0.666666, 1.0}, new Color[]{new Color(0, 0, 0), new Color(255, 0, 0), new Color(255, 255, 0), new Color(255, 255, 255)});
        }
        return storeDataColormap;
    }

    public static ColorMap createGrayScaleColorMap() {
        if (grayscale == null) {
            grayscale = new InterpolationColorMap(I18n.textc("Gray scale", "Colormap name"), new double[]{0.0, 1.0}, new Color[]{new Color(0, 0, 0), new Color(255, 255, 255)});
        }
        return grayscale;
    }

    public static ColorMap createWhiteColorMap() {
        if (white == null) {
            white = new InterpolationColorMap(I18n.textc("All white", "Colormap name"), new double[]{0.0, 1.0}, new Color[]{Color.white, Color.white});
        }
        return white;
    }

    public static ColorMap createHotColorMap() {
        if (hot == null) {
            InputStreamReader isr = new InputStreamReader(ClassLoader.getSystemResourceAsStream("colormaps/hot.colormap"));
            try {
                hot = new TabulatedColorMap(isr);
            }
            catch (Exception e) {
                NeptusLog.pub().debug((Object)e.getMessage());
                hot = new InterpolationColorMap(I18n.textc("Hot", "Colormap name"), new double[]{0.0, 0.3333333, 0.66666666, 1.0}, new Color[]{Color.BLACK, Color.RED, Color.YELLOW, Color.WHITE});
            }
        }
        return hot;
    }

    public static ColorMap createAllColorsColorMap() {
        if (allColors == null) {
            allColors = new InterpolationColorMap(I18n.textc("All Colors", "Colormap name"), new double[]{0.0, 0.3333333, 0.66666666, 1.0}, new Color[]{Color.BLACK, Color.BLUE, Color.YELLOW, Color.WHITE});
        }
        return allColors;
    }

    public static ColorMap createRedGreenBlueColorMap() {
        if (rgb == null) {
            rgb = new InterpolationColorMap(I18n.textc("RGB", "Colormap name"), new double[]{0.0, 0.5, 1.0}, new Color[]{new Color(255, 0, 0), new Color(0, 255, 0), new Color(0, 0, 255)});
        }
        return rgb;
    }

    public static ColorMap createBlueToRedColorMap() {
        if (bluered == null) {
            bluered = new InterpolationColorMap(I18n.textc("Blue to Red", "Colormap name"), new double[]{0.0, 1.0}, new Color[]{Color.BLUE, Color.RED});
        }
        return bluered;
    }

    public static ColorMap createAutumnColorMap() {
        if (autumn == null) {
            autumn = new InterpolationColorMap(I18n.textc("Autumn", "Colormap name"), new double[]{0.0, 1.0}, new Color[]{Color.RED, Color.YELLOW});
        }
        return autumn;
    }

    public static ColorMap createCoolColorMap() {
        if (cool == null) {
            cool = new InterpolationColorMap(I18n.textc("Cool", "Colormap name"), new double[]{0.0, 1.0}, new Color[]{Color.CYAN, Color.MAGENTA});
        }
        return cool;
    }

    public static ColorMap createJetColorMap() {
        if (jet == null) {
            try {
                InputStreamReader isr = new InputStreamReader(ClassLoader.getSystemResourceAsStream("colormaps/jet.colormap"));
                jet = new TabulatedColorMap(isr);
            }
            catch (Exception e) {
                NeptusLog.pub().debug((Object)e.getMessage());
                jet = new InterpolationColorMap(I18n.textc("Jet", "Colormap name"), new double[]{0.0, 0.25, 0.5, 0.75, 1.0}, new Color[]{Color.blue, Color.cyan, Color.yellow, Color.red, new Color(128, 0, 0)});
            }
        }
        return jet;
    }

    public static ColorMap createSpringColorMap() {
        if (spring == null) {
            spring = new InterpolationColorMap(I18n.textc("Spring", "Colormap name"), new double[]{0.0, 1.0}, new Color[]{Color.magenta, Color.yellow});
        }
        return spring;
    }

    public static ColorMap createBoneColorMap() {
        if (bone == null) {
            bone = new InterpolationColorMap(I18n.textc("Bone", "Colormap name"), new double[]{0.0, 0.375, 0.75, 1.0}, new Color[]{new Color(0, 0, 1), new Color(81, 81, 113), new Color(166, 198, 198), Color.white});
        }
        return bone;
    }

    public static ColorMap createCopperColorMap() {
        if (copper == null) {
            copper = new InterpolationColorMap(I18n.textc("Copper", "Colormap name"), new double[]{0.0, 0.7869, 0.8125, 1.0}, new Color[]{Color.black, new Color(253, 158, 100), new Color(255, 161, 103), new Color(255, 199, 127)});
        }
        return copper;
    }

    public static ColorMap createSummerColorMap() {
        if (summer == null) {
            summer = new InterpolationColorMap(I18n.textc("Summer", "Colormap name"), new double[]{0.0, 1.0}, new Color[]{new Color(0, 128, 102), new Color(255, 255, 102)});
        }
        return summer;
    }

    public static ColorMap createWinterColorMap() {
        if (winter == null) {
            winter = new InterpolationColorMap(I18n.textc("Winter", "Colormap name"), new double[]{0.0, 1.0}, new Color[]{Color.blue, new Color(0, 255, 128)});
        }
        return winter;
    }

    public static ColorMap createPinkColorMap() {
        if (pink == null) {
            pink = new InterpolationColorMap(I18n.textc("Pink", "Colormap name"), new double[]{0.0, 0.015625, 0.03125, 0.046875, 0.375, 0.75, 1.0}, new Color[]{new Color(30, 0, 0), new Color(50, 26, 26), new Color(64, 37, 37), new Color(75, 45, 45), new Color(194, 126, 126), new Color(232, 232, 180), new Color(255, 255, 255)});
        }
        return pink;
    }

    public static ColorMap createGreenRadarColorMap() {
        if (greenradar == null) {
            greenradar = new InterpolationColorMap(I18n.textc("GreenRadar", "Colormap name"), new double[]{0.0, 1.0}, new Color[]{Color.black, Color.green});
        }
        return greenradar;
    }

    public static ColorMap createGreenToRedColorMap() {
        if (redYellowGreen == null) {
            redYellowGreen = new InterpolationColorMap(I18n.textc("GreenToRed", "Colormap name"), new double[]{0.0, 0.5, 1.0}, new Color[]{Color.green, Color.yellow, Color.red});
        }
        return redYellowGreen;
    }

    public static ColorMap createRedYellowGreenColorMap() {
        if (redYellowGreen == null) {
            redYellowGreen = new InterpolationColorMap(I18n.textc("RedYellowGreen", "Colormap name"), new double[]{0.0, 0.5, 1.0}, new Color[]{Color.red, Color.yellow, Color.green});
        }
        return redYellowGreen;
    }

    public static ColorMap createRainbowColormap() {
        if (rainbow == null) {
            rainbow = new InterpolationColorMap(I18n.textc("Rainbow", "Colormap name"), new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 1.0}, new Color[]{Color.magenta.darker().darker().darker(), Color.magenta, Color.blue, Color.cyan, Color.green, Color.yellow, Color.orange, Color.red, Color.red.darker().darker().darker()});
        }
        return rainbow;
    }

    public static ColorMap createBronzeColormap() {
        if (bronze == null) {
            InputStreamReader isr = new InputStreamReader(ClassLoader.getSystemResourceAsStream("colormaps/bronze.colormap"));
            try {
                bronze = new TabulatedColorMap(isr);
                ((InterpolationColorMap)bronze).setName(I18n.textc("Bronze", "Colormap name"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bronze;
    }

    public static ColorMap createSideScanColorMap() {
        if (sscanmap == null) {
            sscanmap = new InterpolationColorMap(I18n.textc("Sidescan", "Colormap name"), new double[]{0.0, 1.0}, new Color[]{new Color(-256, true), new Color(-1, true)});
        }
        return sscanmap;
    }

    public static ColorMap createInvertedColorMap(InterpolationColorMap original) {
        double[] inv = new double[original.getValues().length];
        Color[] colors = new Color[inv.length];
        int j = inv.length;
        for (int i = 0; i < inv.length; ++i) {
            inv[i] = original.getValues()[i];
            colors[i] = original.getColor(Math.max(0.001, original.getValues()[--j]));
        }
        return new InterpolationColorMap(I18n.text("Inverted") + " " + original.toString(), inv, colors);
    }

    public static void main(String[] args) {
        ColorBar bar = new ColorBar(0, ColorMapFactory.createInvertedColorMap((InterpolationColorMap)ColorMapFactory.createAutumnColorMap()));
        ColorBar bar2 = new ColorBar(0, ColorMapFactory.createAutumnColorMap());
        GuiUtils.testFrame(bar, bar.getCmap().toString());
        GuiUtils.testFrame(bar2, bar2.getCmap().toString());
    }

    static {
        colorMapNamesList.add("Autumn");
        colorMapNamesList.add("Bone");
        colorMapNamesList.add("Cool");
        colorMapNamesList.add("Copper");
        colorMapNamesList.add("Gray");
        colorMapNamesList.add("Hot");
        colorMapNamesList.add("Jet");
        colorMapNamesList.add("Pink");
        colorMapNamesList.add("Spring");
        colorMapNamesList.add("Summer");
        colorMapNamesList.add("Winter");
        colorMapNamesList.add("AllColors");
        colorMapNamesList.add("RedGreenBlue");
        colorMapNamesList.add("BlueToRed");
        colorMapNamesList.add("White");
        colorMapNamesList.add("Rainbow");
        colorMapNamesList.add("Bronze");
        colorMapNamesList.add("StoreData");
        Collections.sort(colorMapNamesList);
        storeDataColormap = null;
        grayscale = null;
        white = null;
        hot = null;
        allColors = null;
        rgb = null;
        bluered = null;
        autumn = null;
        cool = null;
        jet = null;
        spring = null;
        bone = null;
        copper = null;
        summer = null;
        winter = null;
        pink = null;
        greenradar = null;
        redYellowGreen = null;
        rainbow = null;
        bronze = null;
        sscanmap = null;
    }
}

