/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.colormap;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.colormap.DataDiscretizer;
import pt.lsts.neptus.colormap.InterpolationColorMap;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.ws.Location;

public class ColorMapUtils {
    public static int HORIZONTAL_ORIENTATION = 1;
    public static int VERTICAL_ORIENTATION = 2;

    private static void generateInterpolatedColorMap(Rectangle2D bounds, Point2D[] points, Double[] values, Graphics2D destination, double width, double height, int alpha, ColorMap colorMap, double min, double max) {
        int i;
        if (points.length != values.length || points.length == 0) {
            System.err.println("Number of locations must be positive and match the number of values!");
            return;
        }
        int numX = width >= 100.0 ? 100 : (int)width;
        int numY = height >= 100.0 ? 100 : (int)height;
        int numValues = numX * numY;
        double[] xGrid = new double[numValues];
        double[] yGrid = new double[numValues];
        double[] zGrid = new double[numValues];
        double minX = bounds.getMinX();
        double maxX = bounds.getMaxX();
        double minY = bounds.getMinY();
        double maxY = bounds.getMaxY();
        double dxGrid = (maxX - minX) / (double)numX;
        double dyGrid = (maxY - minY) / (double)numY;
        double x = 0.0;
        for (int i2 = 0; i2 < numX; ++i2) {
            x = i2 == 0 ? minX : (x += dxGrid);
            double y = 0.0;
            for (int j = 0; j < numY; ++j) {
                int k = numY * i2 + j;
                xGrid[k] = x;
                y = j == 0 ? minY : (y += dyGrid);
                yGrid[k] = y;
            }
        }
        double power = 2.0;
        for (int kGrid = 0; kGrid < xGrid.length; ++kGrid) {
            double dTotal = 0.0;
            zGrid[kGrid] = 0.0;
            for (int k = 0; k < values.length; ++k) {
                if (values[k] == null) continue;
                double xPt = points[k].getX();
                double yPt = points[k].getY();
                double d = Point2D.distance(xPt, yPt, xGrid[kGrid], yGrid[kGrid]);
                d = (d = Math.pow(d, power)) > 0.0 ? 1.0 / d : 1.0E20;
                int n = kGrid;
                zGrid[n] = zGrid[n] + values[k] * d;
                dTotal += d;
            }
            zGrid[kGrid] = zGrid[kGrid] / dTotal;
        }
        for (i = 0; i < zGrid.length; ++i) {
            if (zGrid[i] < min) {
                min = zGrid[i];
            }
            if (!(zGrid[i] > max)) continue;
            max = zGrid[i];
        }
        for (i = 0; i < zGrid.length; ++i) {
            zGrid[i] = (zGrid[i] - min) / (max - min);
        }
        double[][] vals = new double[numX][numY];
        for (int i3 = 0; i3 < numX; ++i3) {
            for (int j = 0; j < numY; ++j) {
                vals[i3][j] = zGrid[i3 * numX + j];
            }
        }
        ColorMapUtils.getInterpolatedData(vals, colorMap, destination, width, height, alpha);
    }

    public static void generateInterpolatedColorMap(Rectangle2D bounds, DataDiscretizer.DataPoint[] data, int var, Graphics2D destination, double width, double height, int alpha, ColorMap colorMap, double minValue, double maxValue) {
        Point2D[] points = new Point2D[data.length];
        Double[] values = new Double[data.length];
        for (int i = 0; i < data.length; ++i) {
            points[i] = data[i].getPoint2D();
            values[i] = data[i].getValues()[var];
        }
        ColorMapUtils.generateInterpolatedColorMap(bounds, points, values, destination, width, height, alpha, colorMap, minValue, maxValue);
    }

    public static void generateColorMap(DataDiscretizer.DataPoint[] data, Graphics2D destination, double width, double height, int alpha, ColorMap colorMap) {
        Point2D[] points = new Point2D[data.length];
        Double[] values = new Double[data.length];
        for (int i = 0; i < data.length; ++i) {
            points[i] = data[i].getPoint2D();
            values[i] = data[i].getValue();
        }
        ColorMapUtils.generateColorMap(points, values, destination, width, height, alpha, colorMap, false);
    }

    public static ColorMap invertColormap(ColorMap original, int numColors) {
        double[] values = new double[numColors];
        Color[] colors = new Color[numColors];
        if (original instanceof InterpolationColorMap) {
            return ColorMapFactory.createInvertedColorMap((InterpolationColorMap)original);
        }
        for (int i = 0; i < numColors; ++i) {
            values[i] = (double)i / (double)numColors;
            colors[i] = original.getColor(1.0 - (double)i / (double)numColors);
        }
        return new InterpolationColorMap(values, colors);
    }

    private static void generateInterpolatedColorMap(Point2D[] points, Double[] values, Graphics2D destination, double width, double height, int alpha, ColorMap colorMap) {
        double minY;
        double minX;
        if (points.length != values.length || points.length == 0) {
            System.err.println("Number of locations must be positive and match the number of values!");
            return;
        }
        double maxX = minX = points[0].getX();
        double maxY = minY = points[0].getY();
        for (int i = 0; i < points.length; ++i) {
            if (points[i].getX() < minX) {
                minX = points[i].getX();
            } else if (points[i].getX() > maxX) {
                maxX = points[i].getX();
            }
            if (points[i].getY() < minY) {
                minY = points[i].getY();
                continue;
            }
            if (!(points[i].getY() > maxY)) continue;
            maxY = points[i].getY();
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
        ColorMapUtils.generateInterpolatedColorMap((Rectangle2D)bounds, points, values, destination, width, height, alpha, colorMap, ColorMapUtils.getMin(values), ColorMapUtils.getMax(values));
    }

    private static double getMin(Double[] values) {
        Double min = null;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || min != null && !(values[i] < min)) continue;
            min = values[i];
        }
        return min;
    }

    private static double getMax(Double[] values) {
        Double max = null;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || max != null && !(values[i] > max)) continue;
            max = values[i];
        }
        return max;
    }

    private static void generateInterpolatedColorMap(Location[] locs, Double[] values, Graphics2D destination, double width, double height, int alpha, ColorMap colorMap) {
        if (locs.length != values.length || locs.length == 0) {
            System.err.println("Number of locations must be positive and match the number of values!");
            return;
        }
        Point2D[] points = new Point2D[locs.length];
        double minLong = -locs[0].getAbsoluteLongitudeDouble();
        double maxLat = locs[0].getAbsoluteLatitudeDouble();
        for (int i = 0; i < locs.length; ++i) {
            if (-locs[i].getAbsoluteLongitudeDouble() < minLong) {
                minLong = -locs[i].getAbsoluteLongitudeDouble();
            }
            if (!(locs[i].getAbsoluteLatitudeDouble() > maxLat)) continue;
            maxLat = locs[i].getAbsoluteLatitudeDouble();
        }
        Location topCorner = new Location(maxLat, minLong);
        double[] of = locs[0].getNEDOffsetFrom(topCorner);
        double minX = of[1];
        double minY = -of[0];
        double maxX = of[1];
        double maxY = -of[0];
        for (int i = 0; i < locs.length; ++i) {
            double[] offsets = locs[i].getNEDOffsetFrom(topCorner);
            points[i] = new Point2D.Double(offsets[1], -offsets[0]);
            if (-offsets[0] > maxY) {
                maxY = -offsets[0];
            }
            if (offsets[1] > maxX) {
                maxX = offsets[1];
            }
            if (-offsets[0] < minY) {
                minY = -offsets[0];
            }
            if (!(offsets[1] < minX)) continue;
            minX = offsets[1];
        }
        ColorMapUtils.generateInterpolatedColorMap(points, values, destination, width, height, alpha, colorMap);
    }

    public static void getInterpolatedData(double[][] data, ColorMap colormap, Graphics2D bg, double width, double height, int alpha) {
        BufferedImage tmp = new BufferedImage(data.length, data[0].length, 2);
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                tmp.setRGB(i, j, colormap.getColor(data[i][j]).getRGB());
            }
        }
        bg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        bg.scale(width / (double)tmp.getWidth(), height / (double)tmp.getHeight());
        bg.drawImage((Image)tmp, 0, 0, null);
    }

    public static void generateColorMap(Rectangle2D bounds, Point2D[] points, Double[] vals, Graphics2D destination, double width, double height, int alpha, ColorMap colorMap, double min, double max) {
        ColorMapUtils.generateInterpolatedColorMap(bounds, points, vals, destination, width, height, alpha, colorMap, min, max);
        double minX = bounds.getMinX();
        double maxX = bounds.getMaxX();
        double minY = bounds.getMinY();
        double maxY = bounds.getMaxY();
        Graphics2D g = destination;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.black);
        double scaleX = width / (maxX - minX);
        double scaleY = height / (maxY - minY);
        for (int i = 0; i < points.length; ++i) {
            double dx = (points[i].getX() - minX) * scaleX;
            double dy = (points[i].getY() - minY) * scaleY;
            g.translate(dx, dy);
            g.drawLine(-3, -3, 3, 3);
            g.drawLine(-3, 3, 3, -3);
            g.drawString("" + vals[i], 10, 10);
            g.translate(-dx, -dy);
        }
    }

    public static Rectangle2D getBounds(DataDiscretizer.DataPoint[] points) {
        double minY;
        double minX;
        if (points.length == 0) {
            return null;
        }
        double maxX = minX = points[0].getPoint2D().getX();
        double maxY = minY = points[0].getPoint2D().getY();
        for (int i = 0; i < points.length; ++i) {
            Point2D pt = points[i].getPoint2D();
            if (pt.getX() < minX) {
                minX = pt.getX();
            } else if (pt.getX() > maxX) {
                maxX = pt.getX();
            }
            if (pt.getY() < minY) {
                minY = pt.getY();
                continue;
            }
            if (!(pt.getY() > maxY)) continue;
            maxY = pt.getY();
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    public static Rectangle2D getBounds(Point2D[] points) {
        double minY;
        double minX;
        if (points.length == 0) {
            return null;
        }
        double maxX = minX = points[0].getX();
        double maxY = minY = points[0].getY();
        for (int i = 0; i < points.length; ++i) {
            if (points[i].getX() < minX) {
                minX = points[i].getX();
            } else if (points[i].getX() > maxX) {
                maxX = points[i].getX();
            }
            if (points[i].getY() < minY) {
                minY = points[i].getY();
                continue;
            }
            if (!(points[i].getY() > maxY)) continue;
            maxY = points[i].getY();
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    public static void generateColorMap(Point2D[] points, Double[] vals, Graphics2D destination, double width, double height, int alpha, ColorMap colorMap, boolean drawPoints) {
        double minY;
        double minX;
        ColorMapUtils.generateInterpolatedColorMap(points, vals, destination, width, height, alpha, colorMap);
        if (points.length == 0) {
            return;
        }
        double maxX = minX = points[0].getX();
        double maxY = minY = points[0].getY();
        for (int i = 0; i < points.length; ++i) {
            if (points[i].getX() < minX) {
                minX = points[i].getX();
            } else if (points[i].getX() > maxX) {
                maxX = points[i].getX();
            }
            if (points[i].getY() < minY) {
                minY = points[i].getY();
                continue;
            }
            if (!(points[i].getY() > maxY)) continue;
            maxY = points[i].getY();
        }
        if (drawPoints) {
            Graphics2D g = destination;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(Color.black);
            double scaleX = width / (maxX - minX);
            double scaleY = height / (maxY - minY);
            for (int i = 0; i < points.length; ++i) {
                double dx = (points[i].getX() - minX) * scaleX;
                double dy = (points[i].getY() - minY) * scaleY;
                g.translate(dx, dy);
                g.drawLine(-3, -3, 3, 3);
                g.drawLine(-3, 3, 3, -3);
                g.drawString("" + GuiUtils.getNeptusDecimalFormat(1).format(vals[i]), 10, 10);
                g.translate(-dx, -dy);
            }
        }
    }

    public static void generateColorMap(Location[] locs, Double[] vals, Graphics2D destination, double width, double height, int alpha, ColorMap colorMap) {
        ColorMapUtils.generateInterpolatedColorMap(locs, vals, destination, width, height, alpha, colorMap);
        Point2D[] points = new Point2D[locs.length];
        double minLong = -locs[0].getAbsoluteLongitudeDouble();
        double maxLat = locs[0].getAbsoluteLatitudeDouble();
        for (int i = 0; i < locs.length; ++i) {
            if (-locs[i].getAbsoluteLongitudeDouble() < minLong) {
                minLong = -locs[i].getAbsoluteLongitudeDouble();
            }
            if (!(locs[i].getAbsoluteLatitudeDouble() > maxLat)) continue;
            maxLat = locs[i].getAbsoluteLatitudeDouble();
        }
        Location topCorner = new Location(maxLat, minLong);
        double[] of = locs[0].getNEDOffsetFrom(topCorner);
        double minX = of[1];
        double minY = -of[0];
        double maxX = of[1];
        double maxY = -of[0];
        for (int i = 0; i < locs.length; ++i) {
            double[] offsets = locs[i].getNEDOffsetFrom(topCorner);
            points[i] = new Point2D.Double(offsets[1], -offsets[0]);
            if (-offsets[0] > maxY) {
                maxY = -offsets[0];
            }
            if (offsets[1] > maxX) {
                maxX = offsets[1];
            }
            if (-offsets[0] < minY) {
                minY = -offsets[0];
            }
            if (!(offsets[1] < minX)) continue;
            minX = offsets[1];
        }
        Graphics2D g = destination;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.black);
        double scaleX = width / (maxX - minX);
        double scaleY = height / (maxY - minY);
        for (int i = 0; i < points.length; ++i) {
            double dx = (points[i].getX() - minX) * scaleX;
            double dy = (points[i].getY() - minY) * scaleY;
            g.translate(dx, dy);
            g.drawLine(-3, -3, 3, 3);
            g.drawLine(-3, 3, 3, -3);
            g.drawString("" + vals[i], 10, 10);
            g.translate(-dx, -dy);
        }
    }

    public static Image getBar(ColorMap cmap, int orientation, int width, int height) {
        int i;
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g2d = (Graphics2D)img.getGraphics();
        if (orientation == HORIZONTAL_ORIENTATION) {
            for (i = 0; i < img.getWidth(); ++i) {
                double pos = (double)i / (double)img.getWidth();
                g2d.setColor(cmap.getColor(pos));
                g2d.drawLine(i, 0, i, img.getHeight());
            }
        }
        if (orientation == VERTICAL_ORIENTATION) {
            for (i = 0; i < img.getHeight(); ++i) {
                g2d.setColor(cmap.getColor((double)i / (double)img.getHeight()));
                g2d.drawLine(0, i, img.getWidth(), i);
            }
        }
        return img;
    }

    public static void main(String[] args) {
        Location loc = new Location(41.0, -8.0);
        Location loc0 = new Location(loc);
        Location loc1 = new Location(loc);
        Location loc2 = new Location(loc);
        Location loc3 = new Location(loc);
        Location loc4 = new Location(loc);
        Location loc5 = new Location(loc);
        loc1.translate(15.0, 8.5, 0.0);
        loc2.translate(5.0, 10.0, 0.0);
        loc3.translate(10.0, 7.0, 0.0);
        loc4.translate(3.0, 5.0, 0.0);
        loc5.translate(0.0, 12.0, 20.0);
        Location[] locs = new Location[]{loc0, loc1, loc2};
        Double[] values = new Double[]{0.0, 600.0, 340.0};
        BufferedImage img = new BufferedImage(800, 600, 2);
        ColorMapUtils.generateColorMap(locs, values, (Graphics2D)img.getGraphics(), img.getWidth(), img.getHeight(), 255, ColorMapFactory.createInvertedColorMap((InterpolationColorMap)ColorMapFactory.createGrayScaleColorMap()));
        JLabel lbl = new JLabel(new ImageIcon(img));
        GuiUtils.testFrame(lbl);
    }
}

