/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.colormap;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.colormap.ColorBar;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.colormap.ColorMapUtils;
import pt.lsts.neptus.renderer2d.ImageLayer;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.GuiUtils;

@LayerPriority(priority=-100)
public class ColormapOverlay
implements Renderer2DPainter {
    protected LinkedHashMap<Point, Double> cellSums = new LinkedHashMap();
    protected LinkedHashMap<Point, Integer> count = new LinkedHashMap();
    protected LinkedHashMap<Point, Double> average = new LinkedHashMap();
    protected int minN = Integer.MAX_VALUE;
    protected int minE = Integer.MAX_VALUE;
    protected int maxN = Integer.MIN_VALUE;
    protected int maxE = Integer.MIN_VALUE;
    protected double minVal = Double.MAX_VALUE;
    protected double maxVal = -1.7976931348623157E308;
    protected LocationType topLeft = null;
    protected int cellWidth = 3;
    protected LocationType ref = null;
    protected BufferedImage generated = null;
    protected BufferedImage scaled = null;
    protected String name;
    protected ColorMap colormap;
    protected ColorBar cb;
    protected boolean inverted;
    protected int transparency = 0;
    double lastZoom = -1.0;

    public ColormapOverlay(String name, int cellWidth, boolean inverted, int transparency) {
        this.name = name;
        this.cellWidth = cellWidth;
        this.inverted = inverted;
        this.transparency = transparency;
    }

    public void addSampleUseMax(LocationType location, double value) {
        if (this.ref == null) {
            this.ref = new LocationType(location.convertToAbsoluteLatLonDepth());
        }
        double[] offsets = location.getOffsetFrom(this.ref);
        int northing = (int)offsets[0] / this.cellWidth * this.cellWidth;
        this.minN = Math.min(this.minN, northing);
        this.maxN = Math.max(this.maxN, northing);
        int easting = (int)offsets[1] / this.cellWidth * this.cellWidth;
        this.minE = Math.min(this.minE, easting);
        this.maxE = Math.max(this.maxE, easting);
        Point loc = new Point(northing, easting);
        if (!this.count.containsKey(loc)) {
            this.count.put(loc, 1);
            this.cellSums.put(loc, value);
        } else {
            if (this.cellSums.get(loc) > value) {
                return;
            }
            this.cellSums.put(loc, value);
        }
        this.minVal = Math.min(this.minVal, value);
        this.maxVal = Math.max(this.maxVal, value);
    }

    public void addSample(LocationType location, double value) {
        if (this.ref == null) {
            this.ref = new LocationType(location);
            this.ref.convertToAbsoluteLatLonDepth();
        }
        double[] offsets = location.getOffsetFrom(this.ref);
        int northing = (int)offsets[0] / this.cellWidth * this.cellWidth;
        this.minN = Math.min(this.minN, northing);
        this.maxN = Math.max(this.maxN, northing);
        int easting = (int)offsets[1] / this.cellWidth * this.cellWidth;
        this.minE = Math.min(this.minE, easting);
        this.maxE = Math.max(this.maxE, easting);
        this.minVal = Math.min(this.minVal, value);
        this.maxVal = Math.max(this.maxVal, value);
        Point loc = new Point(northing, easting);
        if (!this.count.containsKey(loc)) {
            this.count.put(loc, 1);
            this.cellSums.put(loc, value);
        } else {
            this.count.put(loc, this.count.get(loc) + 1);
            this.cellSums.put(loc, this.cellSums.get(loc) + value);
        }
    }

    public void computeAverage() {
        for (Map.Entry<Point, Double> entry : this.cellSums.entrySet()) {
            this.average.put(entry.getKey(), entry.getValue() / (double)this.count.get(entry.getKey()).intValue());
        }
    }

    public double[][] fillInData() {
        int startN = this.minN - this.cellWidth * 3;
        int startE = this.minE - this.cellWidth * 3;
        int endN = this.maxN + this.cellWidth * 3;
        int endE = this.maxE + this.cellWidth * 3;
        double[][] data = new double[(endE - startE) / this.cellWidth + 1][(endN - startN) / this.cellWidth + 1];
        for (int n = startN; n <= endN; n += this.cellWidth) {
            int y = (endN - n) / this.cellWidth;
            for (int e = startE; e <= endE; e += this.cellWidth) {
                int x = (e - startE) / this.cellWidth;
                Point ne = new Point(n, e);
                if (this.average.containsKey(ne)) {
                    data[x][y] = this.average.get(ne);
                    continue;
                }
                double sumValues = 0.0;
                double sumDistance = 0.0;
                int count = 0;
                for (Map.Entry<Point, Double> avg : this.average.entrySet()) {
                    double d = ne.distance(avg.getKey());
                    if (d > (double)(this.cellWidth * 3)) continue;
                    d = d * d * d;
                    ++count;
                    d = d > 0.0 ? 1.0 / d : 1.0E20;
                    sumDistance += d;
                    sumValues += d * avg.getValue();
                }
                data[x][y] = count > 1 ? sumValues / sumDistance : this.minVal - 1.0;
            }
        }
        return data;
    }

    public double[][] generateGrid(Point2D min, Point2D max) {
        this.computeAverage();
        min.setLocation(this.minN, this.minE);
        max.setLocation(this.maxN, this.maxE);
        return this.fillInData();
    }

    public BufferedImage generateImage(ColorMap colormap) {
        BufferedImage image;
        this.computeAverage();
        this.colormap = colormap;
        if (this.inverted) {
            this.colormap = ColorMapUtils.invertColormap(this.colormap, 255);
        }
        double[][] data = this.fillInData();
        this.topLeft = new LocationType(this.ref);
        this.topLeft.translatePosition((double)this.maxN + (double)this.cellWidth * 3.5, (double)this.minE - (double)this.cellWidth * 3.5, 0.0);
        if (this.transparency == 0) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            image = gc.createCompatibleImage(data.length, data[0].length, 2);
        } else {
            image = new BufferedImage(data.length, data[0].length, 2);
        }
        this.maxVal = Math.ceil(this.maxVal);
        this.minVal = Math.floor(this.minVal);
        double amplitude = this.maxVal - this.minVal;
        for (int x = 0; x < data.length; ++x) {
            for (int y = 0; y < data[0].length; ++y) {
                if (!(data[x][y] >= this.minVal)) continue;
                Color c = this.colormap.getColor((data[x][y] - this.minVal) / amplitude);
                if (this.transparency != 0) {
                    image.setRGB(x, y, new Color(c.getRed(), c.getGreen(), c.getBlue(), this.transparency).getRGB());
                    continue;
                }
                image.setRGB(x, y, c.getRGB());
            }
        }
        return image;
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        if (this.generated == null) {
            this.generated = this.generateImage(ColorMapFactory.createJetColorMap());
        }
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        Point2D corner = renderer.getScreenPosition(this.topLeft);
        Graphics2D copy = (Graphics2D)g.create();
        g.translate(corner.getX(), corner.getY());
        g.scale((float)this.cellWidth * renderer.getZoom(), (float)this.cellWidth * renderer.getZoom());
        g.rotate(-renderer.getRotation());
        g.drawImage(this.generated, 0, 0, this.generated.getWidth(), this.generated.getHeight(), 0, 0, this.generated.getWidth(), this.generated.getHeight(), renderer);
        g.rotate(renderer.getRotation());
        g.translate(-corner.getX(), -corner.getY());
        this.drawLegend(copy);
    }

    public ImageLayer getImageLayer() {
        LocationType bottomRight = new LocationType(this.topLeft);
        if (this.generated == null) {
            this.generated = this.generateImage(ColorMapFactory.createJetColorMap());
        }
        bottomRight.translatePosition(-this.generated.getHeight() * this.cellWidth, this.generated.getWidth() * this.cellWidth, 0.0);
        return new ImageLayer(this.name, this.generated, this.topLeft, bottomRight);
    }

    protected void drawLegend(Graphics2D g) {
        if (this.cb == null) {
            this.cb = this.inverted ? new ColorBar(1, ColorMapUtils.invertColormap(this.colormap, 80)) : new ColorBar(1, this.colormap);
            this.cb.setSize(15, 80);
        }
        g.setColor(Color.black);
        Font prev = g.getFont();
        g.setFont(new Font("Helvetica", 1, 14));
        g.setFont(prev);
        g.translate(5, 5);
        this.cb.paint(g);
        try {
            if (this.minVal != Double.MAX_VALUE) {
                g.drawString(GuiUtils.getNeptusDecimalFormat(2).format((this.maxVal + this.minVal) / 2.0), 15, 45);
            }
            if (this.inverted) {
                if (this.minVal == Double.MAX_VALUE) {
                    g.drawString("+\u221e", 15, 80);
                    g.drawString("-\u221e", 15, 10);
                } else {
                    g.drawString(GuiUtils.getNeptusDecimalFormat(2).format(this.maxVal), 15, 80);
                    g.drawString(GuiUtils.getNeptusDecimalFormat(2).format(this.minVal), 15, 10);
                }
            } else if (this.minVal == Double.MAX_VALUE) {
                g.drawString("-\u221e", 15, 80);
                g.drawString("+\u221e", 15, 10);
            } else {
                g.drawString(GuiUtils.getNeptusDecimalFormat(2).format(this.maxVal), 15, 10);
                g.drawString(GuiUtils.getNeptusDecimalFormat(2).format(this.minVal), 15, 80);
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
        }
    }

    public static void main(String[] args) throws Exception {
        LsfIndex index = new LsfIndex(new File("/home/zp/Desktop/logs-noptilus/lauv-noptilus-1/20121106/154008_rows_noptilus/Data.lsf"));
        ColormapOverlay overlay = new ColormapOverlay("Test", 20, false, 0);
        for (EstimatedState x : index.getIterator(EstimatedState.class)) {
            LocationType loc = new LocationType(Math.toDegrees(x.getLat()), Math.toDegrees(x.getLon()));
            loc.translatePosition(x.getX(), x.getY(), 0.0);
            overlay.addSample(loc, x.getTimestamp());
        }
        StateRenderer2D renderer = new StateRenderer2D(overlay.ref);
        renderer.addPostRenderPainter(overlay, "Overlay");
        GuiUtils.testFrame(renderer);
    }
}

