/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.colormap;

import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Vector;
import pt.lsts.neptus.colormap.CHull;

public class DataDiscretizer {
    private final LinkedHashMap<String, DataPoint> points = new LinkedHashMap();
    public double maxX = Double.NaN;
    public double maxY = Double.NaN;
    public double minX = Double.NaN;
    public double minY = Double.NaN;
    public double[] minVal = null;
    public double[] maxVal = null;
    private double cellWidth = 5.0;

    public DataDiscretizer(double cellWidth) {
        this.cellWidth = cellWidth;
    }

    public void addPoint(Number x, Number y, Number value) {
        this.addPoint(x.doubleValue(), y.doubleValue(), value.doubleValue());
    }

    public void addPoint(Number x, Number y, Number[] values) {
        double[] vals = new double[values.length];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = values[i].doubleValue();
        }
        this.addPoint(x.doubleValue(), y.doubleValue(), vals);
    }

    public void addPoint(double x, double y, double[] values) {
        int i;
        if (Double.isNaN(this.maxX)) {
            this.maxX = this.minX = x;
            this.maxY = this.minY = y;
            this.minVal = new double[values.length];
            this.maxVal = new double[values.length];
            for (i = 0; i < values.length; ++i) {
                this.minVal[i] = this.maxVal[i] = values[i];
            }
        } else {
            if (x > this.maxX) {
                this.maxX = x;
            }
            if (x < this.minX) {
                this.minX = x;
            }
            if (y > this.maxY) {
                this.maxY = y;
            }
            if (y < this.minY) {
                this.minY = y;
            }
            for (i = 0; i < this.minVal.length; ++i) {
                if (values[i] < this.minVal[i]) {
                    this.minVal[i] = values[i];
                }
                if (!(values[i] > this.maxVal[i])) continue;
                this.maxVal[i] = values[i];
            }
        }
        int x_ = (int)(Math.floor(x / this.cellWidth) * this.cellWidth);
        int y_ = (int)(Math.floor(y / this.cellWidth) * this.cellWidth);
        String id = x_ + "," + y_;
        if (this.points.containsKey(id)) {
            this.points.get(id).addValue(values);
        } else {
            this.points.put(id, new DataPoint(x_, y_, values));
        }
    }

    public void addPoint(double x, double y, double value) {
        this.addPoint(x, y, new double[]{value});
    }

    public DataPoint[] getDataPoints(int minValues) {
        Vector<DataPoint> dps = new Vector<DataPoint>();
        for (DataPoint dp : this.points.values()) {
            if (dp.numValues < minValues) continue;
            dps.add(dp);
        }
        return dps.toArray(new DataPoint[0]);
    }

    public DataPoint[] getDataPoints() {
        return this.points.values().toArray(new DataPoint[0]);
    }

    public int getAmountDataPoints() {
        return this.points.size();
    }

    public ArrayList<Point> computeConvexHull() {
        ArrayList<Point> array = new ArrayList<Point>();
        for (DataPoint dp : this.points.values()) {
            array.add(new Point(dp.x, dp.y));
        }
        Collections.sort(array, new Comparator<Point>(){

            @Override
            public int compare(Point pt1, Point pt2) {
                int r = pt1.x - pt2.x;
                if (r != 0) {
                    return r;
                }
                return pt1.y - pt2.y;
            }
        });
        return CHull.cHull(array);
    }

    public GeneralPath getCHullShape() {
        GeneralPath cHullShape = new GeneralPath();
        ArrayList<Point> chull = this.computeConvexHull();
        cHullShape.reset();
        if (chull.size() > 3) {
            cHullShape.reset();
            for (int i = 0; i < chull.size(); ++i) {
                if (i == 0) {
                    cHullShape.moveTo(chull.get((int)i).x, chull.get((int)i).y);
                    continue;
                }
                cHullShape.lineTo(chull.get((int)i).x, chull.get((int)i).y);
            }
            cHullShape.closePath();
        }
        return cHullShape;
    }

    public class DataPoint {
        private final int x;
        private final int y;
        private int numValues;
        double[] sum;

        public DataPoint(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public DataPoint(int x, int y, double value) {
            this(x, y);
            this.addValue(value);
        }

        public DataPoint(int x, int y, double[] values) {
            this(x, y);
            this.addValue(values);
        }

        public void addValue(double value) {
            this.addValue(new double[]{value});
        }

        public void addValue(double[] values) {
            if (this.numValues == 0) {
                this.sum = new double[values.length];
            }
            ++this.numValues;
            for (int i = 0; i < values.length; ++i) {
                int n = i;
                this.sum[n] = this.sum[n] + values[i];
            }
        }

        public double getValue() {
            return this.numValues > 0 ? this.sum[0] / (double)this.numValues : Double.NaN;
        }

        public double[] getValues() {
            double[] ret = new double[this.sum.length];
            for (int i = 0; i < this.sum.length; ++i) {
                ret[i] = this.numValues > 0 ? this.sum[i] / (double)this.numValues : Double.NaN;
            }
            return ret;
        }

        public Point2D getPoint2D() {
            return new Point2D.Double(this.x, this.y);
        }

        public String toString() {
            return "(" + this.x + "," + this.y + ")=" + this.getValue();
        }
    }
}

