/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.colormap;

import java.awt.Color;
import java.beans.PropertyEditor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.gui.editor.ColorMapPropertyEditor;
import pt.lsts.neptus.plugins.PropertyType;

public class InterpolationColorMap
implements ColorMap,
PropertyType {
    protected double[] values = new double[]{0.0, 1.0};
    protected Color[] colors = new Color[]{Color.BLACK, Color.WHITE};
    protected boolean debug = false;
    protected String name;

    @Override
    public void fromString(String value) {
        ColorMap cmap = ColorMapFactory.getColorMapByName(value);
        if (cmap instanceof InterpolationColorMap) {
            InterpolationColorMap icm = (InterpolationColorMap)cmap;
            this.colors = icm.colors;
            this.values = icm.values;
            this.name = icm.name;
        }
    }

    @Override
    public Class<? extends PropertyEditor> getPropertyEditor() {
        return ColorMapPropertyEditor.class;
    }

    public InterpolationColorMap(double[] values, Color[] colors) {
        this("Unknown", values, colors);
    }

    public InterpolationColorMap(String name, double[] values, Color[] colors) {
        this.name = name;
        if (values.length != colors.length) {
            System.err.println("The values[] and colors[] sizes don't match!");
            return;
        }
        this.values = values;
        this.colors = colors;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public InterpolationColorMap(Reader reader) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(reader);
        Vector<Color> colorsV = new Vector<Color>();
        while ((line = br.readLine()) != null) {
            String[] parts;
            if (line.charAt(0) == '#' || (parts = line.split("[ \t,]+")).length < 3) continue;
            int r = (int)(Double.parseDouble(parts[0]) * 255.0);
            int g = (int)(Double.parseDouble(parts[1]) * 255.0);
            int b = (int)(Double.parseDouble(parts[2]) * 255.0);
            colorsV.add(new Color(r, g, b));
        }
        this.colors = colorsV.toArray(new Color[0]);
        this.values = new double[colorsV.size()];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = (double)i / (double)(this.values.length - 1);
        }
    }

    public InterpolationColorMap(File file) throws FileNotFoundException, IOException {
        this(new FileReader(file));
    }

    public InterpolationColorMap(String filename) throws FileNotFoundException, IOException {
        this(new File(filename));
    }

    public static void main(String[] args) throws Exception {
        InterpolationColorMap cmap = new InterpolationColorMap("c:/cmap.txt");
        NeptusLog.pub().info((Object)("<###> " + cmap.getColor(0.1f)));
    }

    @Override
    public Color getColor(double value) {
        int pos;
        if (this.debug) {
            NeptusLog.pub().info((Object)"<###>getColor()");
        }
        if (value >= this.values[this.values.length - 1]) {
            return this.colors[this.values.length - 1];
        }
        if (value <= this.values[0]) {
            return this.colors[0];
        }
        value = Math.min(value, this.values[this.values.length - 1]);
        value = Math.max(value, this.values[0]);
        for (pos = 0; pos < this.values.length && value > this.values[pos]; ++pos) {
        }
        if (pos == 0) {
            return this.colors[0];
        }
        if (pos == this.values.length) {
            return this.colors[this.colors.length - 1];
        }
        return this.interpolate(this.values[pos - 1], this.colors[pos - 1], value, this.values[pos], this.colors[pos]);
    }

    private Color interpolate(double belowValue, Color belowColor, double value, double aboveValue, Color aboveColor) {
        if (this.debug) {
            NeptusLog.pub().info((Object)"<###>interpolate()");
        }
        double totalDist = aboveValue - belowValue;
        double aboveDist = (value - belowValue) / totalDist;
        double belowDist = (aboveValue - value) / totalDist;
        if (this.debug) {
            NeptusLog.pub().info((Object)("<###>aboveDist=" + aboveDist + ", belowDist=" + belowDist));
        }
        return new Color((int)((double)belowColor.getRed() * belowDist + (double)aboveColor.getRed() * aboveDist), (int)((double)belowColor.getGreen() * belowDist + (double)aboveColor.getGreen() * aboveDist), (int)((double)belowColor.getBlue() * belowDist + (double)aboveColor.getBlue() * aboveDist));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double[] getValues() {
        return this.values;
    }

    public void setValues(double[] values) {
        this.values = values;
    }

    public Color[] getColors() {
        return this.colors;
    }

    public void setColors(Color[] colors) {
        this.colors = colors;
    }
}

