/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.net.telnet.EchoOptionHandler;
import org.apache.commons.net.telnet.InvalidTelnetOptionException;
import org.apache.commons.net.telnet.SuppressGAOptionHandler;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.TelnetNotificationHandler;
import org.apache.commons.net.telnet.TelnetOptionHandler;
import org.apache.commons.net.telnet.TerminalTypeOptionHandler;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.CommUtil;
import pt.lsts.neptus.types.comm.CommMean;
import pt.lsts.neptus.types.comm.protocol.AdjustTimeShellArgs;
import pt.lsts.neptus.types.comm.protocol.ProtocolArgs;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class ApacheAdjustDate
implements Runnable,
TelnetNotificationHandler {
    private TelnetClient tc = null;

    public boolean adjustDateTime(String vehicleId) {
        VehicleType vehicle = VehiclesHolder.getVehicleById(vehicleId);
        if (vehicle == null) {
            NeptusLog.pub().error((Object)("ApacheAdjustDate :: No vehicle found for id: " + vehicleId));
            return false;
        }
        CommMean cm = CommUtil.getActiveCommMeanForProtocol(vehicle, "telnet");
        if (cm == null) {
            NeptusLog.pub().error((Object)("ApacheAdjustDate :: No active CommMean for telnet protocol for vehicle with id: " + vehicleId));
            return false;
        }
        String host = cm.getHostAddress();
        int port = 23;
        String user = cm.getUserName();
        String password = cm.getPassword();
        this.tc = new TelnetClient();
        TerminalTypeOptionHandler ttopt = new TerminalTypeOptionHandler("VT100", false, false, true, false);
        EchoOptionHandler echoopt = new EchoOptionHandler(true, false, true, false);
        SuppressGAOptionHandler gaopt = new SuppressGAOptionHandler(true, true, true, true);
        try {
            this.tc.addOptionHandler((TelnetOptionHandler)ttopt);
            this.tc.addOptionHandler((TelnetOptionHandler)echoopt);
            this.tc.addOptionHandler((TelnetOptionHandler)gaopt);
        }
        catch (IOException | InvalidTelnetOptionException e) {
            NeptusLog.pub().error((Object)("ApacheAdjustDate :: Error registering option handlers: " + e.getMessage()));
        }
        try {
            this.tc.connect(host, port);
            Thread reader = new Thread(this);
            OutputStream outstr = this.tc.getOutputStream();
            DataOutputStream dostream = new DataOutputStream(outstr);
            reader.start();
            try {
                dostream.writeBytes(user + "\n");
                dostream.flush();
                dostream.writeBytes(password + "\n");
                dostream.flush();
                String command = this.getAdjustDateCommand(vehicle);
                dostream.writeBytes(command + "\n");
                dostream.flush();
                NeptusLog.pub().info((Object)("Date to set in vehicle '" + vehicleId + "': " + command));
                Thread.sleep(5000L);
                this.tc.disconnect();
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)("ApacheAdjustDate :: : " + e.getMessage()));
            }
        }
        catch (SocketException e1) {
            NeptusLog.pub().error((Object)("ApacheAdjustDate :: : " + e1.getMessage()));
            return false;
        }
        catch (IOException e1) {
            NeptusLog.pub().error((Object)("ApacheAdjustDate :: : " + e1.getMessage()));
            return false;
        }
        return true;
    }

    private String getAdjustDateCommand(VehicleType vehicle) {
        ProtocolArgs adjParamBase = vehicle.getProtocolsArgs().get("time-shell");
        AdjustTimeShellArgs adjParam = null;
        adjParam = adjParamBase != null ? (AdjustTimeShellArgs)adjParamBase : new AdjustTimeShellArgs();
        String dateTime = "date ";
        String yearFormat = !adjParam.isSetYear() ? "" : (adjParam.isUse2DigitYear() ? "yy" : "yyyy");
        String secondsFormat = !adjParam.isSetSeconds() ? "" : ".ss";
        SimpleDateFormat dateFormater = new SimpleDateFormat("MMddHHmm" + yearFormat + secondsFormat);
        Date trialTime = new Date();
        dateTime = dateTime + dateFormater.format(trialTime);
        if (adjParam.isUseHwClock()) {
            dateTime = dateTime + " && hwclock --systohc";
        }
        return dateTime;
    }

    public void receivedNegotiation(int negotiation_code, int option_code) {
        String command = null;
        if (negotiation_code == 1) {
            command = "DO";
        } else if (negotiation_code == 2) {
            command = "DONT";
        } else if (negotiation_code == 3) {
            command = "WILL";
        } else if (negotiation_code == 4) {
            command = "WONT";
        }
        NeptusLog.pub().info((Object)("<###>Received " + command + " for option code " + option_code));
    }

    @Override
    public void run() {
        InputStream instr = this.tc.getInputStream();
        try {
            byte[] buff = new byte[1024];
            int ret_read = 0;
            do {
                if ((ret_read = instr.read(buff)) <= 0) continue;
                String ret = new String(buff, 0, ret_read);
                NeptusLog.pub().info((Object)(this + " :: ApacheAdjustDate:: Echo >" + ret));
            } while (ret_read >= 0);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)("Exception while reading socket:" + e.getMessage()));
        }
        try {
            this.tc.disconnect();
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)("Exception while closing telnet:" + e.getMessage()));
        }
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        new ApacheAdjustDate().adjustDateTime("rov-ies");
    }
}

