/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.CommUtil;
import pt.lsts.neptus.comm.FTPException;
import pt.lsts.neptus.types.comm.CommMean;
import pt.lsts.neptus.types.comm.protocol.FTPArgs;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;

public class ApacheFTP {
    public static boolean ftp(String action, String filename, String hostDirectory, String localDirectory, String vehicleId) throws IOException, FTPException {
        VehicleType vehicle = VehiclesHolder.getVehicleById(vehicleId);
        if (vehicle == null) {
            NeptusLog.pub().error((Object)("ApacheFTP :: No vehicle found for id: " + vehicleId));
            return false;
        }
        CommMean cm = CommUtil.getActiveCommMeanForProtocol(vehicle, "ftp");
        if (cm == null) {
            NeptusLog.pub().error((Object)("ApacheFTP :: No active CommMean for ftp protocol for vehicle with id: " + vehicleId));
            return false;
        }
        try {
            FTPArgs ftpArgs = (FTPArgs)cm.getProtocolsArgs().get("ftp");
            String host = cm.getHostAddress();
            int port = 21;
            String user = cm.getUserName();
            String password = cm.getPassword();
            String mode = ftpArgs.getTransferMode();
            String connMode = ftpArgs.getConnectionMode();
            return ApacheFTP.ftp(action, filename, hostDirectory, localDirectory, host, port, user, password, mode, connMode);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e.getStackTrace());
            return false;
        }
    }

    public static boolean ftp(String action, String filename, String hostDirectory, String localDirectory, String host, int port, String user, String password, String mode, String connMode) throws IOException, FTPException {
        FTPClient ftp = new FTPClient();
        try {
            ftp.connect(host);
            NeptusLog.pub().debug((Object)("ApacheFTP:: Connected to " + host + "."));
            NeptusLog.pub().debug((Object)("ApacheFTP:: Reply string " + ftp.getReplyString() + "."));
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                ftp.disconnect();
                NeptusLog.pub().debug((Object)"ApacheFTP:: FTP server refused connection.");
                return false;
            }
        }
        catch (IOException e) {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException f) {
                    NeptusLog.pub().error((Object)f.getStackTrace());
                }
            }
            NeptusLog.pub().debug((Object)"ApacheFTP:: Could not connect to server.");
            return false;
        }
        if (!ftp.login(user, password)) {
            NeptusLog.pub().debug((Object)"ApacheFTP:: Login failed.");
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException f) {
                    NeptusLog.pub().error((Object)f.getMessage());
                }
            }
            FTPException fe = new FTPException("Login failed");
            fe.setExceptionCode((short)0);
            throw fe;
        }
        NeptusLog.pub().debug((Object)("ApacheFTP:: Remote system is " + ftp.getSystemType() + "."));
        if (connMode.equalsIgnoreCase("pasv")) {
            ftp.enterLocalPassiveMode();
        } else {
            ftp.enterLocalActiveMode();
        }
        try {
            if (mode.equalsIgnoreCase("ASCII")) {
                ftp.setFileType(0);
            } else {
                ftp.setFileType(2);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException f) {
                    NeptusLog.pub().error((Object)f.getMessage());
                }
            }
            return false;
        }
        if (action.equals("get")) {
            try {
                FileOutputStream fos;
                if (hostDirectory != null) {
                    ftp.changeWorkingDirectory(hostDirectory);
                }
                if (localDirectory != null) {
                    fos = new FileOutputStream(localDirectory + "/" + filename);
                    ftp.retrieveFile(filename, (OutputStream)fos);
                } else {
                    fos = new FileOutputStream(filename);
                    ftp.retrieveFile(filename, (OutputStream)fos);
                }
            }
            catch (IOException e) {
                NeptusLog.pub().error((Object)("ApacheFTP::get:: " + e.getMessage()));
                if (ftp.isConnected()) {
                    try {
                        ftp.disconnect();
                    }
                    catch (IOException f) {
                        NeptusLog.pub().error((Object)f.getMessage());
                    }
                }
                return false;
            }
            NeptusLog.pub().info((Object)"ApacheFTP::get:: done");
        } else if (action.equals("put")) {
            try {
                FileInputStream fis;
                if (hostDirectory != null) {
                    ftp.changeWorkingDirectory(hostDirectory);
                }
                if (localDirectory != null) {
                    fis = new FileInputStream(localDirectory + "/" + filename);
                    ftp.storeFile(filename, (InputStream)fis);
                } else {
                    fis = new FileInputStream(filename);
                    ftp.storeFile(filename, (InputStream)fis);
                }
            }
            catch (IOException e) {
                NeptusLog.pub().debug((Object)("ApacheFTP::put:: " + e.getMessage()));
                if (ftp.isConnected()) {
                    try {
                        ftp.disconnect();
                    }
                    catch (IOException f) {
                        NeptusLog.pub().error((Object)f.getMessage());
                    }
                }
                return false;
            }
            NeptusLog.pub().debug((Object)"ApacheFTP::put:: done");
        } else {
            NeptusLog.pub().debug((Object)"ApacheFTP:: Unknown action...");
            return false;
        }
        if (!ftp.logout()) {
            NeptusLog.pub().debug((Object)"ApacheFTP:: Logout failed...");
        }
        if (ftp.isConnected()) {
            try {
                ftp.disconnect();
            }
            catch (IOException f) {
                NeptusLog.pub().error((Object)f.getStackTrace());
            }
        }
        return true;
    }
}

