/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.apache.commons.net.telnet.EchoOptionHandler;
import org.apache.commons.net.telnet.InvalidTelnetOptionException;
import org.apache.commons.net.telnet.SimpleOptionHandler;
import org.apache.commons.net.telnet.SuppressGAOptionHandler;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.TelnetNotificationHandler;
import org.apache.commons.net.telnet.TelnetOptionHandler;
import org.apache.commons.net.telnet.TerminalTypeOptionHandler;
import pt.lsts.neptus.NeptusLog;

public class ApacheTelnet
implements Runnable,
TelnetNotificationHandler {
    static TelnetClient tc = null;

    public static void main(String[] args) throws IOException {
        FileOutputStream fout = null;
        if (args.length < 1) {
            System.err.println("Usage: TelnetClientExample1 <remote-ip> [<remote-port>]");
            System.exit(1);
        }
        String remoteip = args[0];
        int remoteport = args.length > 1 ? Integer.parseInt(args[1]) : 23;
        try {
            fout = new FileOutputStream("spy.log", true);
        }
        catch (Exception e) {
            System.err.println("Exception while opening the spy file: " + e.getMessage());
        }
        tc = new TelnetClient();
        TerminalTypeOptionHandler ttopt = new TerminalTypeOptionHandler("VT100", false, false, true, false);
        EchoOptionHandler echoopt = new EchoOptionHandler(true, false, true, false);
        SuppressGAOptionHandler gaopt = new SuppressGAOptionHandler(true, true, true, true);
        try {
            tc.addOptionHandler((TelnetOptionHandler)ttopt);
            tc.addOptionHandler((TelnetOptionHandler)echoopt);
            tc.addOptionHandler((TelnetOptionHandler)gaopt);
        }
        catch (InvalidTelnetOptionException e) {
            System.err.println("Error registering option handlers: " + e.getMessage());
        }
        while (true) {
            boolean end_loop = false;
            try {
                tc.connect(remoteip, remoteport);
                Thread reader = new Thread(new ApacheTelnet());
                tc.registerNotifHandler((TelnetNotificationHandler)new ApacheTelnet());
                NeptusLog.pub().info((Object)"<###>TelnetClientExample");
                NeptusLog.pub().info((Object)"<###>Type AYT to send an AYT telnet command");
                NeptusLog.pub().info((Object)"<###>Type OPT to print a report of status of options (0-24)");
                NeptusLog.pub().info((Object)"<###>Type REGISTER to register a new SimpleOptionHandler");
                NeptusLog.pub().info((Object)"<###>Type UNREGISTER to unregister an OptionHandler");
                NeptusLog.pub().info((Object)"<###>Type SPY to register the spy (connect to port 3333 to spy)");
                NeptusLog.pub().info((Object)"<###>Type UNSPY to stop spying the connection");
                reader.start();
                OutputStream outstr = tc.getOutputStream();
                byte[] buff = new byte[1024];
                int ret_read = 0;
                do {
                    try {
                        int opcode;
                        ret_read = System.in.read(buff);
                        if (ret_read <= 0) continue;
                        if (new String(buff, 0, ret_read).startsWith("AYT")) {
                            try {
                                NeptusLog.pub().info((Object)"<###>Sending AYT");
                                NeptusLog.pub().info((Object)("<###>AYT response:" + tc.sendAYT(5000L)));
                            }
                            catch (Exception e) {
                                System.err.println("Exception waiting AYT response: " + e.getMessage());
                            }
                            continue;
                        }
                        if (new String(buff, 0, ret_read).startsWith("OPT")) {
                            NeptusLog.pub().info((Object)"<###>Status of options:");
                            for (int ii = 0; ii < 25; ++ii) {
                                NeptusLog.pub().info((Object)("<###>Local Option " + ii + ":" + tc.getLocalOptionState(ii) + " Remote Option " + ii + ":" + tc.getRemoteOptionState(ii)));
                            }
                            continue;
                        }
                        if (new String(buff, 0, ret_read).startsWith("REGISTER")) {
                            StringTokenizer st = new StringTokenizer(new String(buff));
                            try {
                                st.nextToken();
                                opcode = new Integer(st.nextToken());
                                boolean initlocal = new Boolean(st.nextToken());
                                boolean initremote = new Boolean(st.nextToken());
                                boolean acceptlocal = new Boolean(st.nextToken());
                                boolean acceptremote = new Boolean(st.nextToken());
                                SimpleOptionHandler opthand = new SimpleOptionHandler(opcode, initlocal, initremote, acceptlocal, acceptremote);
                                tc.addOptionHandler((TelnetOptionHandler)opthand);
                            }
                            catch (Exception e) {
                                if (e instanceof InvalidTelnetOptionException) {
                                    System.err.println("Error registering option: " + e.getMessage());
                                    continue;
                                }
                                System.err.println("Invalid REGISTER command.");
                                System.err.println("Use REGISTER optcode initlocal initremote acceptlocal acceptremote");
                                System.err.println("(optcode is an integer.)");
                                System.err.println("(initlocal, initremote, acceptlocal, acceptremote are boolean)");
                            }
                            continue;
                        }
                        if (new String(buff, 0, ret_read).startsWith("UNREGISTER")) {
                            StringTokenizer st = new StringTokenizer(new String(buff));
                            try {
                                st.nextToken();
                                opcode = new Integer(st.nextToken());
                                tc.deleteOptionHandler(opcode);
                            }
                            catch (Exception e) {
                                if (e instanceof InvalidTelnetOptionException) {
                                    System.err.println("Error unregistering option: " + e.getMessage());
                                    continue;
                                }
                                System.err.println("Invalid UNREGISTER command.");
                                System.err.println("Use UNREGISTER optcode");
                                System.err.println("(optcode is an integer)");
                            }
                            continue;
                        }
                        if (new String(buff, 0, ret_read).startsWith("SPY")) {
                            try {
                                tc.registerSpyStream((OutputStream)fout);
                            }
                            catch (Exception e) {
                                NeptusLog.pub().error((Object)e.getMessage());
                            }
                            continue;
                        }
                        if (new String(buff, 0, ret_read).startsWith("UNSPY")) {
                            tc.stopSpyStream();
                            continue;
                        }
                        try {
                            outstr.write(buff, 0, ret_read);
                            outstr.flush();
                        }
                        catch (Exception e) {
                            NeptusLog.pub().error((Object)e.getMessage());
                            end_loop = true;
                        }
                    }
                    catch (Exception e) {
                        NeptusLog.pub().error((Object)e.getMessage());
                        end_loop = true;
                    }
                } while (ret_read > 0 && !end_loop);
                try {
                    tc.disconnect();
                }
                catch (Exception e) {
                    System.err.println("Exception while connecting:" + e.getMessage());
                }
                continue;
            }
            catch (Exception e) {
                System.err.println("Exception while connecting:" + e.getMessage());
                System.exit(1);
                continue;
            }
            break;
        }
    }

    public void receivedNegotiation(int negotiation_code, int option_code) {
        String command = null;
        if (negotiation_code == 1) {
            command = "DO";
        } else if (negotiation_code == 2) {
            command = "DONT";
        } else if (negotiation_code == 3) {
            command = "WILL";
        } else if (negotiation_code == 4) {
            command = "WONT";
        }
        NeptusLog.pub().info((Object)("<###>Received " + command + " for option code " + option_code));
    }

    @Override
    public void run() {
        InputStream instr = tc.getInputStream();
        try {
            byte[] buff = new byte[1024];
            int ret_read = 0;
            do {
                if ((ret_read = instr.read(buff)) <= 0) continue;
                System.out.print(new String(buff, 0, ret_read));
            } while (ret_read >= 0);
        }
        catch (Exception e) {
            System.err.println("Exception while reading socket:" + e.getMessage());
        }
        try {
            tc.disconnect();
        }
        catch (Exception e) {
            System.err.println("Exception while closing telnet:" + e.getMessage());
        }
    }
}

