/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.ProgressMonitor;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class HTTPUtils {
    private static LinkedHashMap<String, String> cache = new LinkedHashMap();
    private static ReentrantLock lock = new ReentrantLock();

    public static String post(String url, String content) {
        try {
            URLConnection conn = new URL(url).openConnection();
            conn.setDoOutput(true);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream()));
            bw.write(content);
            bw.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String result = "";
            String line = reader.readLine();
            while (line != null) {
                result = result.concat(line + "\n");
                line = reader.readLine();
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "ERROR";
        }
    }

    public static String getUsingCache(String url) {
        if (!cache.containsKey(url)) {
            cache.put(url, HTTPUtils.get(url));
        }
        return cache.get(url);
    }

    public static String get(String url) {
        lock.lock();
        String result = "";
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            result = "";
            String line = reader.readLine();
            while (line != null) {
                result = result.concat(line + "\n");
                line = reader.readLine();
            }
            lock.unlock();
            return result;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)("Error in HTTPUtils.get(" + url + ")"), (Throwable)e);
            lock.unlock();
            return null;
        }
    }

    public static String put(String url, String content) {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("PUT");
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream()));
            bw.write(content);
            bw.flush();
            bw.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String result = "[" + conn.getResponseCode() + "] ";
            String line = reader.readLine();
            while (line != null) {
                result = result.concat(line + "\n");
                line = reader.readLine();
            }
            conn.disconnect();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (conn != null) {
                conn.disconnect();
            }
            return null;
        }
    }

    public static boolean isValidURL(String url) {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setConnectTimeout(3000);
            conn.connect();
            conn.disconnect();
            return conn.getResponseCode() >= 200 && conn.getResponseCode() < 300;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) {
        NeptusLog.pub().info((Object)("<###> " + HTTPUtils.downloadFile("http://www.mirrorservice.org/sites/download.eclipse.org/eclipseMirror/technology/epp/downloads/release/20070702/eclipse-java-europa-win32.zip", "files/downloads/file.zip")));
    }

    public static long getRemoteFileLength(String url) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setConnectTimeout(3000);
            connection.connect();
            long length = connection.getContentLength();
            connection.disconnect();
            return length;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public static String getPrettySizeString(long bytes) {
        double size;
        String[] sizes = new String[]{"B", "KiB", "MiB", "GiB", "TiB", "PiB", "You wish bytes"};
        int sizeIndex = 0;
        for (size = (double)bytes; size > 1024.0; size /= 1024.0) {
            ++sizeIndex;
        }
        if (Math.floor(size) != size) {
            return GuiUtils.getNeptusDecimalFormat(1).format(size) + " " + sizes[sizeIndex];
        }
        return GuiUtils.getNeptusDecimalFormat(0).format(size) + " " + sizes[sizeIndex];
    }

    public static String downloadFile(String url, String destination) {
        File destFile;
        NumberFormat df = DecimalFormat.getInstance(Locale.US);
        df.setGroupingUsed(false);
        df.setMaximumFractionDigits(2);
        if (!HTTPUtils.isValidURL(url)) {
            return "The URL '" + url + "' is not available.";
        }
        long contentLength = HTTPUtils.getRemoteFileLength(url);
        if (contentLength == -1L) {
            NeptusLog.pub().warn((Object)("HTTPUtils.download('" + url + "'): Unknown file length. Resuming is disabled."));
        } else {
            NeptusLog.pub().info((Object)("Downloading '" + url + "' (" + HTTPUtils.getPrettySizeString(contentLength) + " bytes) to " + destination));
        }
        ProgressMonitor mon = null;
        if (contentLength > 4096L) {
            mon = new ProgressMonitor(ConfigFetch.getSuperParentFrame(), "Downloading '" + url + "'", "Downloaded 0 bytes (0%)", 0, (int)contentLength);
        }
        if ((destFile = new File(destination)).exists() && destFile.canRead()) {
            NeptusLog.pub().info((Object)("HTTPUtils.download('" + url + "'): Destination file will be overwritten."));
        } else {
            destFile.getParentFile().mkdirs();
        }
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setConnectTimeout(3000);
            conn.connect();
            int bytesRead = 0;
            boolean eof = false;
            byte[] buffer = new byte[4096];
            BufferedInputStream stream = new BufferedInputStream(conn.getInputStream());
            BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(destFile));
            while (!((long)bytesRead >= contentLength || eof || mon != null && mon.isCanceled())) {
                int bytes = stream.read(buffer);
                if (bytes == -1) {
                    eof = true;
                    if ((long)bytesRead >= contentLength) continue;
                    NeptusLog.pub().info((Object)("<###>Connection closed before getting entire file (" + bytesRead + " bytes read, expecting " + contentLength + ")"));
                    continue;
                }
                bytesRead += bytes;
                outStream.write(buffer, 0, bytes);
                if (mon == null) continue;
                mon.setProgress(bytesRead);
                double percent = (double)bytesRead / (double)contentLength;
                mon.setNote("Downloaded " + HTTPUtils.getPrettySizeString(bytesRead) + " (" + df.format(percent * 100.0) + "%)");
            }
            outStream.close();
            conn.disconnect();
            NeptusLog.pub().info((Object)("Downloaded '" + url + "' to '" + destination + "'"));
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getClass().getSimpleName() + " thrown while downloading (" + e.getMessage() + ")";
        }
    }
}

