/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm;

import java.awt.Component;
import pt.lsts.imc.AcousticSystems;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.comm.manager.imc.MessageDeliveryListener;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.notifications.Notification;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.StringUtils;

public class IMCSendMessageUtils {
    private static Integer requestId = 65535;

    private IMCSendMessageUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNextRequestId() {
        Integer n = requestId;
        synchronized (n) {
            requestId = requestId + 1;
            if (requestId > 65535) {
                requestId = 0;
            }
            if (requestId < 0) {
                requestId = 0;
            }
            return requestId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCurrentRequestId() {
        Integer n = requestId;
        synchronized (n) {
            return requestId;
        }
    }

    public static boolean sendMessage(IMCMessage msg, String errorTextForDialog, String ... ids) {
        return IMCSendMessageUtils.sendMessage(msg, errorTextForDialog, false, ids);
    }

    public static boolean sendMessage(IMCMessage msg, String errorTextForDialog, boolean ignoreAcousticSending, String ... ids) {
        return IMCSendMessageUtils.sendMessage(msg, null, errorTextForDialog, ignoreAcousticSending, "acoustic/operation", false, true, ids);
    }

    public static boolean sendMessage(IMCMessage msg, Component parent, String errorTextForDialog, boolean ignoreAcousticSending, boolean acousticOpUserAprovedQuestion, String ... ids) {
        return IMCSendMessageUtils.sendMessage(msg, null, errorTextForDialog, ignoreAcousticSending, "acoustic/operation", false, acousticOpUserAprovedQuestion, ids);
    }

    public static boolean sendMessage(IMCMessage msg, Component parent, String errorTextForDialog, boolean ignoreAcousticSending, String acousticOpServiceName, boolean acousticOpUseOnlyActive, boolean acousticOpUserAprovedQuestion, String ... ids) {
        return IMCSendMessageUtils.sendMessage(msg, null, null, parent, errorTextForDialog, ignoreAcousticSending, acousticOpServiceName, acousticOpUseOnlyActive, acousticOpUserAprovedQuestion, ids);
    }

    public static boolean sendMessage(IMCMessage msg, String sendProperties, MessageDeliveryListener listener, Component parent, String errorTextForDialog, boolean ignoreAcousticSending, String acousticOpServiceName, boolean acousticOpUseOnlyActive, boolean acousticOpUserAprovedQuestion, String ... ids) {
        ImcSystem[] acousticOpSysLst = !ignoreAcousticSending ? ImcSystemsHolder.lookupSystemByService(acousticOpServiceName, VehicleType.SystemTypeEnum.ALL, acousticOpUseOnlyActive) : new ImcSystem[]{};
        boolean acousticOpUserAprovalRequired = true;
        boolean acousticOpUserAproved = !acousticOpUserAprovedQuestion;
        boolean retAll = true;
        for (String sid : ids) {
            boolean ret;
            ImcSystem sysL = ImcSystemsHolder.lookupSystemByName(sid);
            if (acousticOpSysLst.length != 0 && sysL != null && !sysL.isActive()) {
                if (acousticOpUserAprovalRequired) {
                    acousticOpUserAproved = GuiUtils.confirmDialog(parent, I18n.text("Send by Acoustic Modem"), I18n.text("Some systems are not active. Do you want to send by acoustic modem?")) == 0;
                    acousticOpUserAprovalRequired = false;
                }
                ret = acousticOpUserAproved ? IMCSendMessageUtils.sendMessageByAcousticModem(msg, sid, acousticOpSysLst) : false;
            } else {
                ret = ImcMsgManager.getManager().sendMessageToSystem(msg, sid, sendProperties, listener);
            }
            boolean bl = retAll = retAll && ret;
            if (ret) continue;
            if (parent instanceof ConsolePanel) {
                ((ConsolePanel)parent).post(Notification.error(I18n.text("Send Message"), errorTextForDialog).src(I18n.text("Console")));
                continue;
            }
            GuiUtils.errorMessage(parent, I18n.text("Send Message"), errorTextForDialog);
        }
        return retAll;
    }

    public static boolean sendMessageByAcousticModem(IMCMessage msg, String system, ImcSystem[] acousticOpSysLst) {
        boolean retAll = false;
        for (ImcSystem acOpSystem : acousticOpSysLst) {
            boolean canReach = IMCSendMessageUtils.doesSystemWithAcousticCanReachSystem(acOpSystem, system);
            if (!canReach) continue;
            String id = acOpSystem.getName();
            IMCMessage msgAcousticOperation = IMCDefinition.getInstance().create("AcousticOperation", new Object[0]);
            msgAcousticOperation.setValue("op", (Object)"MSG");
            msgAcousticOperation.setValue("system", (Object)system);
            msgAcousticOperation.setValue("msg", (Object)msg);
            boolean ret = IMCSendMessageUtils.sendMessage(msgAcousticOperation, I18n.text("Error sending message by acoustic modem!"), true, id);
            retAll = retAll || ret;
        }
        return retAll;
    }

    public static boolean doesSystemWithAcousticCanReachSystem(ImcSystem acOpSystem, String system) {
        if (acOpSystem.containsData("AcousticSystems")) {
            try {
                AcousticSystems msg = (AcousticSystems)acOpSystem.retrieveData("AcousticSystems");
                String sysLst = msg.getList();
                if (StringUtils.isTokenInList(sysLst, system)) {
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

