/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm;

import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.swing.renderer.DefaultCellRenderer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.tree.DefaultAttribute;
import pt.lsts.imc.Header;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCFieldType;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IMCOutputStream;
import pt.lsts.imc.types.PlanSpecificationAdapter;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.editor.AngleEditorDegs;
import pt.lsts.neptus.gui.editor.AngleEditorRadsShowDegrees;
import pt.lsts.neptus.messages.Bitmask;
import pt.lsts.neptus.messages.Enumerated;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mp.maneuvers.CompassCalibration;
import pt.lsts.neptus.mp.maneuvers.Dislodge;
import pt.lsts.neptus.mp.maneuvers.Elevator;
import pt.lsts.neptus.mp.maneuvers.FollowPath;
import pt.lsts.neptus.mp.maneuvers.FollowSystem;
import pt.lsts.neptus.mp.maneuvers.FollowTrajectory;
import pt.lsts.neptus.mp.maneuvers.Goto;
import pt.lsts.neptus.mp.maneuvers.HeadingSpeedDepth;
import pt.lsts.neptus.mp.maneuvers.IMCSerialization;
import pt.lsts.neptus.mp.maneuvers.Loiter;
import pt.lsts.neptus.mp.maneuvers.PopUp;
import pt.lsts.neptus.mp.maneuvers.RowsManeuver;
import pt.lsts.neptus.mp.maneuvers.StationKeeping;
import pt.lsts.neptus.mp.maneuvers.Unconstrained;
import pt.lsts.neptus.mp.maneuvers.VehicleFormation;
import pt.lsts.neptus.mp.maneuvers.YoYo;
import pt.lsts.neptus.plugins.PluginProperty;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MarkElement;
import pt.lsts.neptus.types.map.TransponderElement;
import pt.lsts.neptus.types.mission.ConditionType;
import pt.lsts.neptus.types.mission.HomeReference;
import pt.lsts.neptus.types.mission.MapMission;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.TransitionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.PropertiesLoader;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class IMCUtils {
    static MissionType mt;
    static Vector<String> plansList;

    public static String translateImcIdToSystem(int imcId) {
        return IMCUtils.translateImcIdToSystem(new ImcId16(imcId));
    }

    public static String translateImcIdToSystem(ImcId16 imcId) {
        ImcSystem sys = ImcSystemsHolder.lookupSystem(imcId);
        if (sys != null) {
            return sys.getName();
        }
        VehicleType veh = VehiclesHolder.getVehicleWithImc(imcId);
        if (veh != null) {
            return veh.getName();
        }
        return "";
    }

    public static ImcId16 translateSystemToImcId(String system) {
        ImcSystem sysList = ImcSystemsHolder.lookupSystemByName(system);
        if (sysList != null) {
            return sysList.getId();
        }
        VehicleType veh = VehiclesHolder.getVehicleById(system);
        if (veh != null) {
            return veh.getImcId() != ImcId16.NULL_ID ? veh.getImcId() : ImcId16.NULL_ID;
        }
        return ImcId16.NULL_ID;
    }

    public static String reduceSystemName(String name) {
        if (name.length() <= 9) {
            return name;
        }
        if ((name = name.replaceAll("^lauv-", "")).length() <= 9) {
            return name;
        }
        if ((name = name.replaceAll("[- _|]", "")).length() <= 9) {
            return name;
        }
        String ret = name.substring(Math.max(0, name.length() - 9));
        ret = ret.replaceAll("^[- _|]", "");
        return ret;
    }

    public static void writeAsLsf(IMCMessage message, OutputStream os) {
        IMCOutputStream ios = new IMCOutputStream(os);
        try {
            message.serialize(ios);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static IMCMessage[] parseLsf(InputStream is) throws IOException {
        Vector<IMCMessage> msgs = new Vector<IMCMessage>();
        IMCDefinition imcDef = IMCDefinition.getInstance();
        while (is.available() > 0) {
            try {
                IMCMessage m = imcDef.nextMessage(is);
                msgs.add(m);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return msgs.toArray(new IMCMessage[0]);
    }

    public static void writeAsTxt(IMCMessage message, OutputStream os) {
        try {
            message.dump(os);
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Vector<IMCMessage> extractMessagesFromMessageListMsg(IMCMessage list) {
        Vector<IMCMessage> ret = new Vector<IMCMessage>();
        if (list == null) {
            return ret;
        }
        do {
            IMCMessage inner;
            if ((inner = list.getMessage("msg")) == null) continue;
            ret.add(inner);
        } while ((list = list.getMessage("next")) != null);
        return ret;
    }

    public static IMCMessage packAsMessageList(Collection<IMCMessage> messages) {
        IMCMessage m = IMCDefinition.getInstance().create("MessageList", new Object[0]);
        IMCMessage prev = null;
        IMCMessage first = m;
        for (IMCMessage msg : messages) {
            m.setValue("msg", (Object)msg);
            m.setValue("next", null);
            if (prev != null) {
                prev.setValue("next", (Object)m);
            }
            prev = m;
            m = IMCDefinition.getInstance().create("MessageList", new Object[0]);
        }
        return first;
    }

    public static Document getAsImcXml(IMCMessage[] messages) {
        Document doc = DocumentHelper.createDocument();
        Element el = DocumentHelper.createElement((String)"imc");
        doc.setRootElement(el);
        el.addAttribute("version", IMCDefinition.getInstance().getVersion());
        for (IMCMessage msg : messages) {
            Element msgEl = el.addElement("message");
            IMCUtils.fillInMessage(msg, msgEl);
            try {
                msgEl.addAttribute("time", msg.getHeader().getString("timestamp"));
                msgEl.addAttribute("src", msg.getHeader().getString("src"));
                msgEl.addAttribute("dst", msg.getHeader().getString("dst"));
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e.getStackTrace());
            }
        }
        return doc;
    }

    public static String getAsHtml(IMCMessage message) {
        return "<html><h1>" + message.getAbbrev() + "</h1>" + IMCUtils.getAsInnerHtml(message) + "</html>";
    }

    private static String getAsInnerHtml(IMCMessage msg) {
        if (msg == null) {
            return "null";
        }
        String ret = "<table border=1><tr bgcolor='blue'><th>" + msg.getAbbrev() + "</th><th>" + msg.getFieldNames().length + " fields</th></tr>";
        for (String fieldName : msg.getFieldNames()) {
            String value = msg.getString(fieldName);
            if (msg.getTypeOf(fieldName).equalsIgnoreCase("message") && msg.getValue(fieldName) != null) {
                value = IMCUtils.getAsInnerHtml(msg.getMessage(fieldName));
            }
            ret = ret + "<tr><td>" + fieldName + "=</td><td>" + value + "</td></tr>";
        }
        return ret + "</table>";
    }

    private static void fillInMessage(IMCMessage msg, Element el) {
        el.addAttribute("name", msg.getMessageType().getShortName());
        for (String fieldName : msg.getMessageType().getFieldNames()) {
            Element fieldEl = el.addElement("field");
            fieldEl.addAttribute("name", fieldName);
            fieldEl.addAttribute("type", msg.getMessageType().getFieldType(fieldName).getTypeName());
            if (!msg.getMessageType().getFieldType(fieldName).equals((Object)"message")) {
                fieldEl.setText(msg.getString(fieldName));
                continue;
            }
            IMCUtils.fillInMessage(msg.getMessage(fieldName), el.addElement("inline"));
        }
    }

    private static IMCMessage parseMessage(Element elem) {
        String name = elem.selectSingleNode("@name").getText();
        IMCMessage msg = IMCDefinition.getInstance().create(name, new Object[0]);
        Node timeEl = elem.selectSingleNode("@time");
        Node srcEl = elem.selectSingleNode("@src");
        Node dstEl = elem.selectSingleNode("@dst");
        long time = System.currentTimeMillis();
        if (timeEl != null) {
            time = (long)(Double.parseDouble(timeEl.getText()) * 1000.0);
            msg.getHeader().setTimestamp((double)(time / 1000L));
        }
        if (srcEl != null) {
            msg.getHeader().setValue("src", (Object)srcEl.getText());
        }
        if (dstEl != null) {
            msg.getHeader().setValue("dst", (Object)dstEl.getText());
        }
        List fieldElems = elem.selectNodes("field");
        for (Object mo : fieldElems) {
            Element fieldElem = (Element)mo;
            String ftype = fieldElem.selectSingleNode("@type").getText();
            String fname = fieldElem.selectSingleNode("@name").getText();
            if (!ftype.equals("message")) {
                if (msg.getMessageType().getFieldMeanings(fname) == null) continue;
                long val = (Long)msg.getMessageType().getFieldMeanings(fname).get(fieldElem.getText());
                msg.setValue(fname, (Object)val);
                continue;
            }
            IMCMessage inline = IMCUtils.parseMessage((Element)fieldElem.selectSingleNode("inline"));
            msg.setValue(fname, (Object)inline);
        }
        return msg;
    }

    public static IMCMessage[] parseImcXml(String xml) throws DocumentException {
        Vector<IMCMessage> messages = new Vector<IMCMessage>();
        Document doc = DocumentHelper.parseText((String)xml);
        List msgs = doc.selectNodes("imc/message");
        for (Object mo : msgs) {
            messages.add(IMCUtils.parseMessage((Element)mo));
        }
        return messages.toArray(new IMCMessage[0]);
    }

    public static IMCMessage generateReportedState(LocationType lt, String sid, double roll, double pitch, double yaw, double time) {
        double[] lld = lt.getAbsoluteLatLonDepth();
        IMCMessage msg = IMCDefinition.getInstance().create("ReportedState", new Object[0]);
        msg.setValue("lat", (Object)Math.toRadians(lld[0]));
        msg.setValue("lon", (Object)Math.toRadians(lld[1]));
        msg.setValue("depth", (Object)lld[2]);
        sid = sid != null ? sid : "null";
        msg.setValue("sid", (Object)sid);
        msg.setValue("s_type", (Object)254);
        msg.setValue("roll", (Object)roll);
        msg.setValue("pitch", (Object)pitch);
        msg.setValue("yaw", (Object)yaw);
        msg.setValue("rcpTime", (Object)time);
        return msg;
    }

    public static IMCMessage generateHomeReferenceMessage(MissionType mt) {
        MissionType miss = mt;
        if (miss == null) {
            GuiUtils.errorMessage(ConfigFetch.getSuperParentAsFrame(), "Send HomeRef", "Missing attached mission!");
            return null;
        }
        HomeReference homeRef = miss.getHomeRef();
        LocationType absLoc = new LocationType();
        absLoc.setLocation(homeRef);
        absLoc = absLoc.getNewAbsoluteLatLonDepth();
        IMCMessage msgHomeRef = IMCDefinition.getInstance().create("HomeRef", new Object[0]);
        msgHomeRef.setValue("lat", (Object)absLoc.getLatitudeRads());
        msgHomeRef.setValue("lon", (Object)absLoc.getLongitudeRads());
        msgHomeRef.setValue("depth", (Object)absLoc.getDepth());
        return msgHomeRef;
    }

    public static IMCMessage[] generateLblBeaconSetup(MissionType mt) {
        MissionType miss = mt;
        LinkedList<TransponderElement> transpondersList = new LinkedList<TransponderElement>();
        LinkedHashMap<String, MapMission> mapList = miss.getMapsList();
        Vector<IMCMessage> msgs = new Vector<IMCMessage>();
        for (MapMission mpm : mapList.values()) {
            LinkedHashMap<String, TransponderElement> transList = mpm.getMap().getTranspondersList();
            for (TransponderElement tmp : transList.values()) {
                transpondersList.add(tmp);
            }
        }
        for (int i = 0; i < transpondersList.size(); ++i) {
            int id;
            TransponderElement transp = (TransponderElement)transpondersList.get(i);
            LocationType tPos = transp.getCenterLocation();
            Object absLoc = tPos.getNewAbsoluteLatLonDepth();
            IMCMessage msgBeaconSetup = IMCDefinition.getInstance().create("LblBeaconSetup", new Object[0]);
            String nStr = transp.getId() + "";
            msgBeaconSetup.setValue("beacon", (Object)nStr);
            msgBeaconSetup.setValue("lat", (Object)((LocationType)absLoc).getLatitudeRads());
            msgBeaconSetup.setValue("lon", (Object)((LocationType)absLoc).getLongitudeRads());
            msgBeaconSetup.setValue("depth", (Object)((LocationType)absLoc).getDepth());
            int queryChannel = 0;
            int replyChannel = 0;
            int transponderDelay = 0;
            PropertiesLoader propConf = transp.getPropConf();
            if (propConf == null) {
                GuiUtils.errorMessage(ConfigFetch.getSuperParentAsFrame(), "Send transponders", "Bad configuration for transponder " + transp.getId() + "!");
                return null;
            }
            String propId = propConf.getProperty("id");
            String prop1 = propConf.getProperty("interrogation channel");
            String prop2 = propConf.getProperty("reply channel");
            String prop3 = propConf.getProperty("transponder delay (msecs.)");
            try {
                id = (int)Double.parseDouble(propId);
                queryChannel = (int)Double.parseDouble(prop1);
                replyChannel = (int)Double.parseDouble(prop2);
                transponderDelay = (int)Double.parseDouble(prop3);
            }
            catch (NumberFormatException e2) {
                GuiUtils.errorMessage(ConfigFetch.getSuperParentAsFrame(), "Send transponders", "Bad configuration parsing for transponder " + transp.getId() + "!");
                NeptusLog.pub().error((Object)e2.getStackTrace());
                return null;
            }
            msgBeaconSetup.setValue("id", (Object)id);
            msgBeaconSetup.setValue("query_channel", (Object)queryChannel);
            msgBeaconSetup.setValue("reply_channel", (Object)replyChannel);
            msgBeaconSetup.setValue("transponder_delay", (Object)transponderDelay);
            msgs.add(msgBeaconSetup);
        }
        return msgs.toArray(new IMCMessage[0]);
    }

    public static IMCMessage generatePlanSpecification(PlanType plan) {
        if (plan == null || !(plan instanceof PlanType)) {
            return null;
        }
        PlanType iPlan = plan;
        IMCMessage msgPlanSpecification = iPlan.asIMCPlan();
        return msgPlanSpecification;
    }

    public static PlanType parsePlanSpecification(MissionType mission, IMCMessage msg) {
        PlanType plan = new PlanType(mission);
        PlanSpecificationAdapter adapter = new PlanSpecificationAdapter(msg);
        plan.setId(adapter.getPlanId());
        Vector<IMCMessage> planStartActions = new Vector<IMCMessage>();
        Vector<IMCMessage> planEndActions = new Vector<IMCMessage>();
        long vid = msg.getSrc();
        ImcId16 imcid = new ImcId16(vid);
        VehicleType sender = VehiclesHolder.getVehicleWithImc(imcid);
        if (sender != null) {
            plan.setVehicle(sender);
        } else {
            vid = msg.getDst();
            imcid = new ImcId16(vid);
            sender = VehiclesHolder.getVehicleWithImc(imcid);
            if (sender != null) {
                plan.setVehicle(sender);
            }
        }
        Vector sact = adapter.getPlanStartActions();
        Vector eact = adapter.getPlanEndActions();
        if (sact != null) {
            planStartActions.addAll(sact);
        }
        if (eact != null) {
            planEndActions.addAll(eact);
        }
        if (!planStartActions.isEmpty()) {
            plan.getStartActions().parseMessages(planStartActions);
        }
        if (!planEndActions.isEmpty()) {
            plan.getEndActions().parseMessages(planEndActions);
        }
        Map msgManeuvers = adapter.getAllManeuvers();
        for (Map.Entry entry : msgManeuvers.entrySet()) {
            Vector endActions;
            Maneuver maneuver = IMCUtils.parseManeuver((IMCMessage)entry.getValue());
            maneuver.setId((String)entry.getKey());
            Vector startActions = adapter.getManeuverStartActions((String)entry.getKey());
            if (startActions != null) {
                maneuver.getStartActions().parseMessages(startActions);
            }
            if ((endActions = adapter.getManeuverEndActions((String)entry.getKey())) != null) {
                maneuver.getEndActions().parseMessages(endActions);
            }
            plan.getGraph().addManeuver(maneuver);
        }
        for (PlanSpecificationAdapter.Transition trans : adapter.getAllTransitions()) {
            plan.getGraph().addTransition(trans.getSourceManeuver(), trans.getDestManeuver(), trans.getConditions());
        }
        plan.getGraph().setInitialManeuver(adapter.getFirstManeuverId());
        return plan;
    }

    public static Maneuver parseManeuver(IMCMessage message) {
        Maneuver m = null;
        if (message.getAbbrev().equalsIgnoreCase("goto")) {
            m = new Goto();
        }
        if (message.getAbbrev().equalsIgnoreCase("loiter")) {
            m = new Loiter();
        } else if (message.getAbbrev().equalsIgnoreCase("teleoperation")) {
            m = new Unconstrained();
        } else if (message.getAbbrev().equalsIgnoreCase("elementalmaneuver")) {
            m = new HeadingSpeedDepth();
        } else if (message.getAbbrev().equalsIgnoreCase("yoyo")) {
            m = new YoYo();
        } else if (message.getAbbrev().equalsIgnoreCase("popup")) {
            m = new PopUp();
        } else if (message.getAbbrev().equalsIgnoreCase("stationkeeping")) {
            m = new StationKeeping();
        } else if (message.getAbbrev().equalsIgnoreCase("rowsmaneuver") || message.getAbbrev().equalsIgnoreCase("rows")) {
            m = new RowsManeuver();
        } else if (message.getAbbrev().equalsIgnoreCase("followpath")) {
            m = FollowPath.createFollowPathOrPattern(message);
        } else if (message.getAbbrev().equalsIgnoreCase("followtrajectory")) {
            m = new FollowTrajectory();
        } else if (message.getAbbrev().equalsIgnoreCase("followsystem")) {
            m = new FollowSystem();
        } else if (message.getAbbrev().equalsIgnoreCase("vehicleformation")) {
            m = new VehicleFormation();
        } else if (message.getAbbrev().equalsIgnoreCase("elevator")) {
            m = new Elevator();
        } else if (message.getAbbrev().equalsIgnoreCase("compasscalibration")) {
            m = new CompassCalibration();
        } else if (message.getAbbrev().equalsIgnoreCase("dislodge")) {
            m = new Dislodge();
        }
        if (m != null) {
            ((IMCSerialization)((Object)m)).parseIMCMessage(message);
        } else {
            m = new Unconstrained();
        }
        return m;
    }

    public static void parseManeuverTransition(String sourceManeuver, IMCMessage message, Vector<TransitionType> transitions) {
        IMCMessage next;
        if (message == null) {
            return;
        }
        String destMan = message.getAsString("dest_man");
        if (!"_done_".equalsIgnoreCase(destMan)) {
            TransitionType tt = new TransitionType(sourceManeuver, message.getAsString("dest_man"));
            ConditionType condition = new ConditionType();
            condition.setCondition(message.getAsString("conditions"));
            tt.setCondition(condition);
            transitions.add(tt);
        }
        if ((next = message.getMessage("next")) != null) {
            IMCUtils.parseManeuverTransition(sourceManeuver, next, transitions);
        }
    }

    public static IMCMessage generateLoadMissionCmd(PlanType plan) {
        IMCMessage specs = IMCUtils.generatePlanSpecification(plan);
        IMCMessage msgPlanCommand = IMCDefinition.getInstance().create("PlanCommand", new Object[0]);
        boolean isPlan = true;
        if (msgPlanCommand == null) {
            msgPlanCommand = IMCDefinition.getInstance().create("MissionCommand", new Object[0]);
            isPlan = false;
        }
        if (isPlan) {
            msgPlanCommand.setValue("plan_id", (Object)plan.getId());
        } else {
            msgPlanCommand.setValue("mission_id", (Object)plan.getId());
        }
        msgPlanCommand.setValue("maneuver_id", (Object)"");
        msgPlanCommand.setValue("command", (Object)"LOAD");
        msgPlanCommand.setValue("argument", (Object)specs);
        return msgPlanCommand;
    }

    public static LocationType lookForStartPosition(MissionType mt) {
        MarkElement startEl = null;
        Vector<MarkElement> marks = MapGroup.getMapGroupInstance(mt).getAllObjectsOfType(MarkElement.class);
        for (MarkElement el : marks) {
            if (!el.getId().equals("start")) continue;
            startEl = el;
            break;
        }
        LocationType absLoc = new LocationType();
        if (startEl == null && mt != null) {
            NeptusLog.pub().warn((Object)"Couldn't find startup position. Returning homeref position");
            HomeReference homeRef = mt.getHomeRef();
            absLoc = homeRef.getNewAbsoluteLatLonDepth();
            return null;
        }
        if (startEl != null) {
            NeptusLog.pub().warn((Object)"Unable to retrieve homeref from mission type.");
            absLoc.setLocation(startEl.getCenterLocation());
            absLoc = absLoc.getNewAbsoluteLatLonDepth();
        }
        return absLoc;
    }

    public static IMCMessage generateNavStartupMessage(MissionType mt) {
        LocationType absLoc = IMCUtils.lookForStartPosition(mt);
        IMCMessage msgNavStartPoint = IMCDefinition.getInstance().create("NavigationStartupPoint", new Object[0]);
        msgNavStartPoint.setValue("lat", (Object)absLoc.getLatitudeRads());
        msgNavStartPoint.setValue("lon", (Object)absLoc.getLongitudeRads());
        msgNavStartPoint.setValue("depth", (Object)absLoc.getDepth());
        return msgNavStartPoint;
    }

    public static boolean sendMessage(IMCMessage message, InetSocketAddress target) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IMCOutputStream sb = new IMCOutputStream((OutputStream)baos);
        try {
            message.serialize(sb);
            IMCUtils.sendUdpMsg(target, baos.toByteArray(), baos.size());
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
            return false;
        }
        return true;
    }

    public static boolean sendMissionConfiguration(MissionType mt, String planId, InetSocketAddress destination) {
        IMCMessage[] transps;
        if (!mt.getIndividualPlansList().containsKey(planId)) {
            NeptusLog.pub().error((Object)("Couldn't find the plan '" + planId + "' in the given mission"));
            return false;
        }
        Vector<IMCMessage> msgs = new Vector<IMCMessage>();
        IMCMessage msg = IMCUtils.generateHomeReferenceMessage(mt);
        msgs.add(msg);
        msg = IMCUtils.generateNavStartupMessage(mt);
        msgs.add(msg);
        for (IMCMessage m : transps = IMCUtils.generateLblBeaconSetup(mt)) {
            msgs.add(m);
        }
        NeptusLog.pub().info((Object)("<###>Sending the mission spec (plan) to " + destination.getHostName() + ":" + destination.getPort() + "..."));
        msg = IMCUtils.generatePlanSpecification(mt.getIndividualPlansList().get(planId));
        msgs.add(msg);
        msg = IMCUtils.generateLoadMissionCmd(mt.getIndividualPlansList().get(planId));
        msgs.add(msg);
        IMCUtils.sendMsgs(destination, msgs);
        return true;
    }

    public static boolean sendMsgs(InetSocketAddress destination, Vector<IMCMessage> msgs) {
        try {
            DatagramSocket sock = new DatagramSocket();
            sock.connect(destination);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IMCOutputStream ios = new IMCOutputStream((OutputStream)baos);
            try {
                for (IMCMessage message : msgs) {
                    message.serialize(ios);
                    sock.send(new DatagramPacket(baos.toByteArray(), baos.size()));
                    message.dump((OutputStream)System.out);
                }
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
                sock.close();
                return false;
            }
            sock.close();
            return true;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
            return false;
        }
    }

    public static boolean sendUdpMsg(InetSocketAddress destination, byte[] msg, int size) {
        try {
            DatagramSocket sock = new DatagramSocket();
            sock.connect(destination);
            sock.send(new DatagramPacket(msg, size));
            sock.close();
            return true;
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
            return false;
        }
    }

    public static IMCMessage sendHomeReference(VehicleType vt, MissionType mt) {
        IMCMessage msg = IMCUtils.generateHomeReferenceMessage(mt);
        if (msg == null) {
            return null;
        }
        String vid = vt.getId();
        if (!ImcMsgManager.getManager().isRunning()) {
            GuiUtils.errorMessage(ConfigFetch.getSuperParentAsFrame(), "Send HomeRef", "IMC comms. are not running!");
            return null;
        }
        boolean ret = ImcMsgManager.getManager().sendMessageToVehicle(msg, vid, (String)null);
        if (!ret) {
            GuiUtils.errorMessage(ConfigFetch.getSuperParentAsFrame(), "Send HomeRef", "Error sending HomeRef message!");
        }
        return msg;
    }

    public static boolean sendTransponderConfigurations(VehicleType vt, MissionType mt) {
        if (!ImcMsgManager.getManager().isRunning()) {
            GuiUtils.errorMessage(ConfigFetch.getSuperParentAsFrame(), "Send Transponders", "IMC comms. are not running!");
            return false;
        }
        String vid = vt.getId();
        int i$ = 0;
        IMCMessage[] lblSetupMsgs = IMCUtils.generateLblBeaconSetup(mt);
        IMCMessage[] arr$ = lblSetupMsgs;
        int len$ = arr$.length;
        if (i$ < len$) {
            IMCMessage msg = arr$[i$];
            boolean ret = ImcMsgManager.getManager().sendMessageToVehicle(msg, vid, (String)null);
            if (!ret) {
                GuiUtils.errorMessage(ConfigFetch.getSuperParentAsFrame(), "Send Start Mission Command", "Error sending MissionCommand message!");
            }
            return false;
        }
        if (lblSetupMsgs.length > 0) {
            String missionlog = GuiUtils.getLogFileName("mission_state", "zip");
            mt.asZipFile(missionlog, true);
        }
        return true;
    }

    public static boolean isServiceProvided(String services, String scheme, String name) {
        Vector<URI> ret = IMCUtils.getServiceProvided(services, scheme, name);
        return ret.size() != 0;
    }

    public static Vector<URI> getServiceProvided(String services, String scheme, String name) {
        String[] servicesList = services.split(";");
        Vector<URI> uriList = new Vector<URI>();
        if (name == null || "".equalsIgnoreCase(name)) {
            return uriList;
        }
        for (String str : servicesList) {
            try {
                String path;
                URI url1 = URI.create(str.trim());
                if (scheme != null && !"".equalsIgnoreCase(scheme) && !scheme.equalsIgnoreCase("*") && !scheme.equalsIgnoreCase(url1.getScheme()) || (path = url1.getPath()) == null || "".equalsIgnoreCase(path) || !path.startsWith("/" + name.trim()) && !name.equalsIgnoreCase("*")) continue;
                uriList.add(url1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return uriList;
    }

    public static final String getUidFromServices(String services) {
        String ud;
        String ret = null;
        Vector<URI> strLst = IMCUtils.getServiceProvided(services, "*", "uid");
        if (strLst.size() == 0) {
            strLst = IMCUtils.getServiceProvided(services, "dune", "*");
        }
        if (strLst.size() != 0 && (ud = strLst.get(0).toString()) != null) {
            ret = ud;
        }
        return ret;
    }

    public static IMCMessage asMessageList(Collection<IMCMessage> list) {
        IMCMessage first = null;
        IMCMessage previous = null;
        for (IMCMessage m : list) {
            IMCMessage cur = IMCDefinition.getInstance().create("MessageList", new Object[]{"msg", m});
            if (previous != null) {
                previous.setValue("next", (Object)cur);
            } else {
                first = cur;
            }
            previous = cur;
        }
        return first;
    }

    public static IMCMessage getEmptyMessageList() {
        return IMCDefinition.getInstance().create("MessageList", new Object[0]);
    }

    public static LocationType parseLocation(IMCMessage imcEstimatedState) {
        LocationType loc = new LocationType();
        loc.setLatitudeDegs(Math.toDegrees(imcEstimatedState.getDouble("lat")));
        loc.setLongitudeDegs(Math.toDegrees(imcEstimatedState.getDouble("lon")));
        loc.setOffsetNorth(imcEstimatedState.getDouble("x"));
        loc.setOffsetEast(imcEstimatedState.getDouble("y"));
        loc.setOffsetDown(imcEstimatedState.getDouble("z"));
        double depth = imcEstimatedState.getDouble("depth");
        double height = imcEstimatedState.getDouble("height");
        double altitude = imcEstimatedState.getDouble("alt");
        if (depth != -1.0) {
            loc.setDepth(depth);
        } else if (altitude != -1.0) {
            loc.setDepth(-altitude);
        } else {
            loc.setDepth(-height);
        }
        return loc;
    }

    public static SystemPositionAndAttitude parseState(IMCMessage imcEstimatedState) {
        return new SystemPositionAndAttitude(IMCUtils.parseLocation(imcEstimatedState), imcEstimatedState.getDouble("phi"), imcEstimatedState.getDouble("theta"), imcEstimatedState.getDouble("psi"));
    }

    public static IMCMessage getLblConfig(MissionType mt) {
        int i;
        IMCMessage lblConfig = IMCDefinition.getInstance().create("LblConfig", new Object[0]);
        LinkedList<TransponderElement> transpondersList = new LinkedList<TransponderElement>();
        LinkedHashMap<String, MapMission> mapList = mt.getMapsList();
        for (MapMission mpm : mapList.values()) {
            LinkedHashMap<String, TransponderElement> transList = mpm.getMap().getTranspondersList();
            for (TransponderElement tmp : transList.values()) {
                transpondersList.add(tmp);
            }
        }
        Vector<IMCMessage> beaconMessages = new Vector<IMCMessage>();
        for (i = 0; i < transpondersList.size(); ++i) {
            TransponderElement transp = (TransponderElement)transpondersList.get(i);
            Object absLoc = transp.getCenterLocation().getNewAbsoluteLatLonDepth();
            try {
                int queryChannel = (int)Double.parseDouble(transp.getPropConf().getProperty("interrogation channel"));
                int replyChannel = (int)Double.parseDouble(transp.getPropConf().getProperty("reply channel"));
                int transpDelay = (int)Double.parseDouble(transp.getPropConf().getProperty("transponder delay (msecs.)"));
                IMCMessage lblBeacon = IMCDefinition.getInstance().create("LblBeacon", new Object[]{"beacon", transp.getId(), "lat", ((LocationType)absLoc).getLatitudeRads(), "lon", ((LocationType)absLoc).getLongitudeRads(), "depth", ((LocationType)absLoc).getDepth(), "query_channel", queryChannel, "reply_channel", replyChannel, "transponder_delay", transpDelay});
                beaconMessages.add(lblBeacon);
                continue;
            }
            catch (NumberFormatException e2) {
                NeptusLog.pub().error((Object)e2.getStackTrace());
                return null;
            }
        }
        Collections.sort(beaconMessages, new Comparator<IMCMessage>(){

            @Override
            public int compare(IMCMessage o1, IMCMessage o2) {
                return ("" + o1.getValue("beacon")).compareToIgnoreCase("" + o2.getValue("beacon"));
            }
        });
        for (i = 0; i < 6; ++i) {
            if (i >= beaconMessages.size()) continue;
            lblConfig.setValue("beacon" + i, beaconMessages.get(i));
        }
        return lblConfig;
    }

    public static LocationType getLocation(IMCMessage estimatedStateMsg) {
        LocationType loc = new LocationType();
        loc.setLatitudeRads(estimatedStateMsg.getDouble("lat"));
        loc.setLongitudeRads(estimatedStateMsg.getDouble("lon"));
        loc.setDepth(estimatedStateMsg.getDouble("depth"));
        loc.translatePosition(estimatedStateMsg.getDouble("x"), estimatedStateMsg.getDouble("y"), estimatedStateMsg.getDouble("z"));
        return loc;
    }

    public static void setProperties(Property[] properties, IMCMessage message) {
        for (Property p : properties) {
            try {
                if (p.getCategory() != null && p.getCategory().equals("header")) {
                    try {
                        message.getHeader().setValue(p.getName(), p.getValue());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (message.getMessageType().getFieldUnits(p.getName()) != null) {
                    if (message.getMessageType().getFieldUnits(p.getName()).equalsIgnoreCase("Enumerated")) {
                        message.setValue(p.getName(), p.getValue());
                        continue;
                    }
                    if (message.getMessageType().getFieldUnits(p.getName()).equalsIgnoreCase("Bitmask")) {
                        message.setValue(p.getName(), p.getValue());
                        continue;
                    }
                    if (message.getMessageType().getFieldUnits(p.getName()).equalsIgnoreCase("TupleList")) {
                        message.setValue(p.getName(), p.getValue());
                        continue;
                    }
                    message.setValue(p.getName(), p.getValue());
                    continue;
                }
                if (message.getMessageType().getFieldType(p.getName()) == IMCFieldType.TYPE_PLAINTEXT) {
                    message.setValue(p.getName(), p.getValue());
                    continue;
                }
                message.setValue(p.getName(), p.getValue());
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e, (Throwable)e);
            }
        }
    }

    public static Vector<PluginProperty> getProperties(IMCMessage message) {
        return IMCUtils.getProperties(message, false);
    }

    public static Vector<PluginProperty> getProperties(final IMCMessage message, boolean ignoreHeaderFields) {
        Vector<PluginProperty> properties = new Vector<PluginProperty>();
        if (!ignoreHeaderFields) {
            Header headerType = IMCDefinition.getInstance().createHeader();
            for (String hf : headerType.getFieldNames()) {
                try {
                    Object fieldValue = message.getHeader().getValue(hf);
                    PluginProperty ap = null;
                    if (fieldValue == null) continue;
                    if (hf.equalsIgnoreCase("src") || hf.equalsIgnoreCase("dst")) {
                        fieldValue = new ImcId16(fieldValue);
                    }
                    ap = new PluginProperty(hf, fieldValue.getClass(), fieldValue);
                    ap.setDisplayName(headerType.getLongFieldName(hf));
                    ap.setCategory("header");
                    if (hf.equalsIgnoreCase("time") || hf.equalsIgnoreCase("mgid") || hf.equalsIgnoreCase("sync") || hf.equalsIgnoreCase("size")) {
                        ap.setEditable(false);
                    }
                    if (hf.equalsIgnoreCase("sync")) {
                        PropertiesEditor.getPropertyRendererRegistry().registerRenderer((Property)ap, (TableCellRenderer)new DefaultCellRenderer(){
                            {
                                this.setShowOddAndEvenRows(false);
                            }

                            protected String convertToString(Object value) {
                                try {
                                    Number nb = (Number)value;
                                    return "0x" + Long.toHexString(nb.longValue()) + " (" + nb + ")";
                                }
                                catch (Exception e) {
                                    return super.convertToString(value);
                                }
                            }
                        });
                    }
                    properties.add(ap);
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)e.getStackTrace());
                }
            }
        }
        for (final String fi : message.getMessageType().getFieldNames()) {
            try {
                Object fieldValue = message.getValue(fi);
                if (message.getMessageType().getFieldUnits(fi) != null) {
                    if (message.getMessageType().getFieldUnits(fi).equalsIgnoreCase("Enumerated")) {
                        Enumerated em = new Enumerated(message.getMessageType().getFieldPossibleValues(fi), message.getLong(fi));
                        fieldValue = em;
                    } else if (message.getMessageType().getFieldUnits(fi).equalsIgnoreCase("Bitmask") || message.getMessageType().getFieldUnits(fi).equalsIgnoreCase("Bitfield")) {
                        Bitmask bm = new Bitmask(message.getMessageType().getFieldPossibleValues(fi), message.getLong(fi));
                        fieldValue = bm;
                    }
                }
                PluginProperty ap = null;
                if (fieldValue != null) {
                    ap = new PluginProperty(fi, fieldValue.getClass(), fieldValue);
                    ap.setDisplayName(message.getMessageType().getFullFieldName(fi));
                } else {
                    try {
                        Class type = message.getMessageType().getFieldType(fi).getJavaType();
                        ap = new PluginProperty(fi, type, type.newInstance());
                        ap.setDisplayName(message.getMessageType().getFullFieldName(fi));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                ap.setCategory("payload");
                String fieldName = fi;
                fieldName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                String desc = "<html>" + fi;
                if (message.getMessageType().getFieldUnits(fi) != null && !"".equalsIgnoreCase(message.getMessageType().getFieldUnits(fi))) {
                    desc = desc.concat(" (" + message.getMessageType().getFieldUnits(fi) + ")");
                }
                try {
                    Object min = message.getClass().getField(fieldName + "_MIN").get(message);
                    Object max = message.getClass().getField(fieldName + "_MAX").get(message);
                    String d = desc + "<br>[ " + min + " .. " + max + " ]</html>";
                    ap.setShortDescription(d);
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)e.getMessage());
                    ap.setShortDescription(desc);
                }
                if ("rad".equalsIgnoreCase(message.getMessageType().getFieldUnits(fi)) || "radians".equalsIgnoreCase(message.getMessageType().getFieldUnits(fi))) {
                    PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)ap, AngleEditorRadsShowDegrees.class);
                    PropertiesEditor.getPropertyRendererRegistry().registerRenderer((Property)ap, (TableCellRenderer)new DefaultCellRenderer(){
                        {
                            this.setShowOddAndEvenRows(false);
                        }

                        protected String convertToString(Object value) {
                            try {
                                Number nb = (Number)value;
                                return Math.toDegrees(nb.doubleValue()) + "\u00b0 deg";
                            }
                            catch (Exception e) {
                                return super.convertToString(value);
                            }
                        }
                    });
                } else if ("deg".equalsIgnoreCase(message.getMessageType().getFieldUnits(fi)) || "degrees".equalsIgnoreCase(message.getMessageType().getFieldUnits(fi))) {
                    PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)ap, AngleEditorDegs.class);
                    PropertiesEditor.getPropertyRendererRegistry().registerRenderer((Property)ap, (TableCellRenderer)new DefaultCellRenderer(){
                        {
                            this.setShowOddAndEvenRows(false);
                        }

                        protected String convertToString(Object value) {
                            try {
                                Number nb = (Number)value;
                                return nb.doubleValue() + "\u00b0 deg";
                            }
                            catch (Exception e) {
                                return super.convertToString(value);
                            }
                        }
                    });
                } else if (!("Enumerated".equalsIgnoreCase(message.getMessageType().getFieldUnits(fi)) || "Bitmask".equalsIgnoreCase(message.getMessageType().getFieldUnits(fi)) || "Bitfield".equalsIgnoreCase(message.getMessageType().getFieldUnits(fi)))) {
                    PropertiesEditor.getPropertyRendererRegistry().registerRenderer((Property)ap, (TableCellRenderer)new DefaultCellRenderer(){
                        {
                            this.setShowOddAndEvenRows(false);
                        }

                        protected String convertToString(Object value) {
                            String funits = message.getMessageType().getFieldUnits(fi);
                            return super.convertToString(value) + " " + (funits != null ? funits : "");
                        }
                    });
                }
                properties.add(ap);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
                GuiUtils.errorMessage(null, e);
            }
        }
        return properties;
    }

    public static void dumpPayloadBytes(IMCMessage message) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IMCOutputStream ios = new IMCOutputStream((OutputStream)baos);
        IMCDefinition.getInstance().serializeFields(message, ios);
        byte[] data = baos.toByteArray();
        for (int i = 0; i < data.length; ++i) {
            if (i % 10 == 0) {
                System.out.print(" ");
            }
            System.out.printf("%02X", data[i]);
        }
    }

    public static String getSystemType(int imcId) {
        int sys_selector = 57344;
        int vtype_selector = 6144;
        int sys_type = (imcId & sys_selector) >> 13;
        switch (sys_type) {
            case 0: 
            case 1: {
                switch ((imcId & vtype_selector) >> 11) {
                    case 0: {
                        return "UUV";
                    }
                    case 1: {
                        return "ROV";
                    }
                    case 2: {
                        return "USV";
                    }
                    case 3: {
                        return "UAV";
                    }
                }
                return "UXV";
            }
            case 2: {
                return "CCU";
            }
        }
        String name = IMCDefinition.getInstance().getResolver().resolve(imcId).toLowerCase();
        if (name.contains("ccu")) {
            return "CCU";
        }
        if (name.contains("argos")) {
            return "Argos Tag";
        }
        if (name.contains("spot")) {
            return "SPOT Tag";
        }
        if (name.contains("manta")) {
            return "Gateway";
        }
        return "Unknown";
    }

    public static void testSysTypeResolution() throws Exception {
        String address_url = "file:///home/zp/Desktop/IMC_Addresses.xml";
        URLConnection conn = new URL(address_url).openConnection();
        Document doc = DocumentHelper.parseText((String)IOUtils.toString((InputStream)conn.getInputStream()));
        List nodes = doc.getRootElement().selectNodes("address/@id");
        for (int i = 0; i < nodes.size(); ++i) {
            DefaultAttribute addrElem = (DefaultAttribute)nodes.get(i);
            int id = Integer.parseInt(addrElem.getText().replaceAll("0x", ""), 16);
            String name = IMCDefinition.getInstance().getResolver().resolve(id);
            System.out.println(addrElem.getText() + "," + name + " --> " + IMCUtils.getSystemType(id));
        }
    }

    static {
        plansList = new Vector();
    }
}

