/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.types.comm.CommMean;

public class PingSend {
    public static int TIME_OUT = 500;
    public static int ECHO_PORT = 7;
    public static int FTP_PORT = 21;
    public static int SSH_PORT = 22;
    public static int TELNET_PORT = 23;
    public static int HTTP_PORT = 80;
    public static int NUVP1_PORT = 6002;

    public static boolean ping(String host) {
        try {
            InetAddress address = InetAddress.getByName(host);
            boolean ret = address.isReachable(TIME_OUT);
            NeptusLog.pub().info((Object)("Pinging " + host + "... " + Boolean.toString(ret)));
            return ret;
        }
        catch (UnknownHostException e) {
            NeptusLog.pub().info((Object)e.getMessage());
            return false;
        }
        catch (IOException e) {
            NeptusLog.pub().info((Object)("I/O exception connecting to " + host + " (" + e.getMessage() + ")."));
            return false;
        }
    }

    public static boolean activityTest(CommMean cm) {
        int[] testPorts = new int[]{21, 23, 22, 80, 7};
        return PingSend.activityTest(cm, testPorts);
    }

    public static boolean activityTest(CommMean cm, int port) {
        int[] testPorts = new int[]{port};
        return PingSend.activityTest(cm, testPorts);
    }

    public static boolean activityTest(CommMean cm, int[] testPorts) {
        int i;
        boolean isActive = false;
        Socket echoSocket = null;
        for (i = 0; i < testPorts.length; ++i) {
            try {
                echoSocket = new Socket();
                echoSocket.connect(new InetSocketAddress(cm.getHostAddress(), testPorts[i]), TIME_OUT);
                isActive = true;
                echoSocket.close();
                break;
            }
            catch (UnknownHostException e) {
                NeptusLog.pub().info((Object)("Don't know about host: " + cm.getHostAddress() + "." + e.getMessage()));
                return false;
            }
            catch (IOException e) {
                NeptusLog.pub().info((Object)("Couldn't get I/O for the connection to: " + cm.getHostAddress() + " [" + testPorts[i] + "]." + e.getMessage()));
                continue;
            }
        }
        if (isActive) {
            NeptusLog.pub().info((Object)("Able to get I/O for the connection to: " + cm.getHostAddress() + " [" + testPorts[i] + "]."));
        }
        return isActive;
    }

    public static void main(String[] args) throws IOException {
        byte[] buf = new byte[100];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(buf.length);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeByte(250);
        buf = byteArrayOutputStream.toByteArray();
        CommMean cm = new CommMean();
        cm.setHostAddress("localhost");
        PingSend.ping(cm.getHostAddress());
        PingSend.activityTest(cm);
        cm.setHostAddress("whale.fe.up.pt");
        PingSend.ping(cm.getHostAddress());
        PingSend.activityTest(cm);
        cm.setHostAddress("192.168.106.32");
        PingSend.ping(cm.getHostAddress());
        PingSend.activityTest(cm);
        cm.setHostAddress("dceg.fe.up.pt");
        PingSend.ping(cm.getHostAddress());
        PingSend.activityTest(cm);
        cm.setHostAddress("192.168.106.15");
        PingSend.ping(cm.getHostAddress());
        PingSend.activityTest(cm);
        cm.setHostAddress("192.168.106.183");
        PingSend.ping(cm.getHostAddress());
        PingSend.activityTest(cm);
        cm.setHostAddress("192.168.106.33");
        PingSend.ping(cm.getHostAddress());
        PingSend.activityTest(cm);
    }
}

