/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.iridium;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Vector;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCInputStream;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IMCOutputStream;
import pt.lsts.imc.RemoteSensorInfo;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.comm.iridium.IridiumMessage;
import pt.lsts.neptus.comm.iridium.Position;
import pt.lsts.neptus.types.coord.LocationType;

public class DeviceUpdate
extends IridiumMessage {
    protected LinkedHashMap<Integer, Position> positions = new LinkedHashMap();

    public LinkedHashMap<Integer, Position> getPositions() {
        return this.positions;
    }

    public DeviceUpdate() {
        super(2001);
    }

    @Override
    public int serializeFields(IMCOutputStream out) throws Exception {
        int read = 0;
        for (Position p : this.positions.values()) {
            out.writeUnsignedShort(p.id);
            read += 2;
            out.writeUnsignedInt(Math.round(p.timestamp));
            read += 4;
            out.writeInt((int)Math.round(Math.toDegrees(p.latRads) * 1000000.0));
            read += 4;
            out.writeInt((int)Math.round(Math.toDegrees(p.lonRads) * 1000000.0));
            read += 4;
        }
        return read;
    }

    @Override
    public int deserializeFields(IMCInputStream in) throws Exception {
        this.positions.clear();
        int read = 0;
        try {
            while (true) {
                Position pos = new Position();
                pos.id = in.readUnsignedShort();
                read += 2;
                pos.timestamp = in.readUnsignedInt();
                read += 4;
                pos.latRads = Math.toRadians((double)in.readInt() / 1000000.0);
                read += 4;
                pos.lonRads = Math.toRadians((double)in.readInt() / 1000000.0);
                read += 4;
                this.positions.put(pos.id, pos);
            }
        }
        catch (Exception e) {
            return read;
        }
    }

    @Override
    public Collection<IMCMessage> asImc() {
        Vector<IMCMessage> msgs = new Vector<IMCMessage>();
        for (Position pos : this.positions.values()) {
            RemoteSensorInfo sensorInfo = new RemoteSensorInfo();
            sensorInfo.setLat(pos.latRads);
            sensorInfo.setLon(pos.lonRads);
            sensorInfo.setTimestamp(pos.timestamp);
            sensorInfo.setAlt(0.0);
            sensorInfo.setId(IMCDefinition.getInstance().getResolver().resolve(pos.id));
            sensorInfo.setSrc(this.getSource());
            sensorInfo.setDst(this.getDestination());
            sensorInfo.setSensorClass(IMCUtils.getSystemType(pos.id));
            msgs.add((IMCMessage)sensorInfo);
        }
        return msgs;
    }

    @Override
    public String toString() {
        String s = super.toString();
        s = s + "\t[" + this.positions.size() + " positions]\n";
        for (Position p : this.positions.values()) {
            s = s + "\t * (" + IMCDefinition.getInstance().getResolver().resolve(p.id) + ") --> " + new LocationType(Math.toDegrees(p.latRads), Math.toDegrees(p.lonRads)) + "\n";
        }
        return s;
    }
}

