/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.iridium;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IridiumMsgRx;
import pt.lsts.imc.IridiumMsgTx;
import pt.lsts.imc.IridiumTxStatus;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.iridium.IridiumMessage;
import pt.lsts.neptus.comm.iridium.IridiumMessageListener;
import pt.lsts.neptus.comm.iridium.IridiumMessenger;
import pt.lsts.neptus.comm.iridium.IridiumProvider;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.messages.MessageFilter;
import pt.lsts.neptus.messages.TypedMessageFilter;
import pt.lsts.neptus.messages.listener.MessageInfo;
import pt.lsts.neptus.messages.listener.MessageListener;
import pt.lsts.neptus.types.vehicle.VehicleType;

@IridiumProvider(id="imc", name="IMC Iridium messenger", description="Uses visible IMC systems capable of sending Iridium messages and processes incoming Iridium messages transmitted via IMC")
public class DuneIridiumMessenger
implements IridiumMessenger,
MessageListener<MessageInfo, IMCMessage> {
    boolean available = false;
    protected int req_id = (int)(Math.random() * 65535.0);
    protected Vector<IridiumMessage> messagesReceived = new Vector();
    protected HashSet<IridiumMessageListener> listeners = new HashSet();

    @Override
    public void addListener(IridiumMessageListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IridiumMessageListener listener) {
        this.listeners.remove(listener);
    }

    public DuneIridiumMessenger() {
        ImcMsgManager.getManager().addListener(this, (MessageFilter)new TypedMessageFilter(IridiumMsgRx.class.getSimpleName(), IridiumTxStatus.class.getSimpleName()));
    }

    public void onMessage(MessageInfo info, IMCMessage msg) {
        if (msg.getMgid() == 170) {
            try {
                IridiumMessage m = IridiumMessage.deserialize(msg.getRawData("data"));
                this.messagesReceived.add(m);
                NeptusLog.pub().info((Object)("Received a " + m.getClass().getSimpleName() + " from " + msg.getSourceName()));
                for (IridiumMessageListener listener : this.listeners) {
                    listener.messageReceived(m);
                }
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        } else if (msg.getMgid() == 172) {
            // empty if block
        }
    }

    @Override
    public void sendMessage(IridiumMessage msg) throws Exception {
        Collection<String> providers = this.getIridiumServiceProviders();
        if (providers.isEmpty()) {
            throw new Exception("No Iridium service providers are available");
        }
        ImcSystem system = ImcSystemsHolder.lookupSystemByName(providers.iterator().next());
        System.out.println("Subscribed to Iridium Device Updates through " + system.getName());
        msg.setSource(system.getId().intValue());
        IridiumMsgTx tx = new IridiumMsgTx();
        tx.setReqId(++this.req_id % 65535);
        tx.setTtl(3600);
        tx.setData(msg.serialize());
        if (!ImcMsgManager.getManager().sendMessageToSystem((IMCMessage)tx, system.getName())) {
            throw new Exception("Error while sending message to " + system.getName() + " via IMC.");
        }
    }

    public Collection<String> getIridiumServiceProviders() {
        ArrayList<String> names = new ArrayList<String>();
        ImcSystem[] providers = ImcSystemsHolder.lookupSystemByService("iridium", VehicleType.SystemTypeEnum.ALL, true);
        if (providers != null) {
            for (ImcSystem s : providers) {
                names.add(s.getName());
            }
        }
        return names;
    }

    @Override
    public Collection<IridiumMessage> pollMessages(Date timeSince) throws Exception {
        return new Vector<IridiumMessage>();
    }

    @Override
    public String getName() {
        return "DUNE Iridium Messenger";
    }

    @Override
    public boolean isAvailable() {
        return !this.getIridiumServiceProviders().isEmpty();
    }

    @Override
    public void cleanup() {
        this.listeners.clear();
        this.messagesReceived.clear();
    }

    public String toString() {
        return this.getName();
    }
}

