/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.iridium;

import com.google.gson.Gson;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.iridium.DeviceUpdate;
import pt.lsts.neptus.comm.iridium.IridiumMessage;
import pt.lsts.neptus.comm.iridium.IridiumMessageListener;
import pt.lsts.neptus.comm.iridium.IridiumMessenger;
import pt.lsts.neptus.comm.iridium.IridiumProvider;
import pt.lsts.neptus.comm.iridium.Position;
import pt.lsts.neptus.util.ByteUtil;

@IridiumProvider(id="hub", name="HUB Iridium Messenger", description="Uses the HUB web server to send and receive messages")
public class HubIridiumMessenger
implements IridiumMessenger {
    protected boolean available = true;
    protected String serverUrl = "http://hub.lsts.pt/api/v1/";
    protected String systemsUrl = this.serverUrl + "systems";
    protected String activeSystemsUrl = this.systemsUrl + "/active";
    protected String messagesUrl = this.serverUrl + "iridium";
    protected int timeoutMillis = 10000;
    protected HashSet<IridiumMessageListener> listeners = new HashSet();
    private static TimeZone tz = TimeZone.getTimeZone("UTC");
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public DeviceUpdate pollActiveDevices() throws Exception {
        Gson gson = new Gson();
        URL url = new URL(this.activeSystemsUrl);
        HubSystemMsg[] sys = (HubSystemMsg[])gson.fromJson((Reader)new InputStreamReader(url.openStream()), HubSystemMsg[].class);
        DeviceUpdate up = new DeviceUpdate();
        for (HubSystemMsg s : sys) {
            Position pos = new Position();
            pos.id = s.imcid;
            pos.latRads = s.coordinates[0];
            pos.lonRads = s.coordinates[1];
            pos.timestamp = (double)HubIridiumMessenger.stringToDate(s.updated_at).getTime() / 1000.0;
            pos.posType = Position.PosType.Unknown;
            up.getPositions().put(pos.id, pos);
        }
        return up;
    }

    @Override
    public void addListener(IridiumMessageListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IridiumMessageListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void sendMessage(IridiumMessage msg) throws Exception {
        byte[] data = msg.serialize();
        data = new String(Hex.encodeHex((byte[])data)).getBytes();
        URL u = new URL(this.messagesUrl);
        HttpURLConnection conn = (HttpURLConnection)u.openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/hub");
        conn.setRequestProperty("Content-Length", String.valueOf(data.length * 2));
        conn.setConnectTimeout(this.timeoutMillis);
        OutputStream os = conn.getOutputStream();
        os.write(data);
        os.close();
        InputStream is = conn.getInputStream();
        ByteArrayOutputStream incoming = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)incoming);
        is.close();
        NeptusLog.pub().info((Object)("Sent " + msg.getClass().getSimpleName() + " through HTTP: " + conn.getResponseCode() + " " + conn.getResponseMessage()));
        try {
            this.logHubInteraction(msg.getClass().getSimpleName() + " (" + msg.getMessageType() + ")", this.messagesUrl, conn.getRequestMethod(), "" + conn.getResponseCode(), ByteUtil.encodeToHex(msg.serialize()), new String(incoming.toByteArray()));
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
        }
        if (conn.getResponseCode() != 201) {
            throw new Exception("Server returned " + conn.getResponseCode() + ": " + conn.getResponseMessage());
        }
    }

    public synchronized void logHubInteraction(String message, String url, String method, String statusCode, String requestData, String responseData) throws Exception {
        if (!new File("log/hub.log").exists()) {
            BufferedWriter tmp = new BufferedWriter(new FileWriter(new File("log/hub.log"), false));
            tmp.write("Time of Day, Message Type, URL, Method, Status Code, Request Data (hex encoded), Response Data\n");
            tmp.close();
        }
        BufferedWriter postWriter = new BufferedWriter(new FileWriter(new File("log/hub.log"), true));
        String out = dateFormat.format(new Date());
        out = out + ", " + message;
        out = out + ", " + url;
        out = out + ", " + method;
        out = out + ", " + statusCode;
        out = out + ", " + requestData;
        out = out + ", " + responseData;
        NeptusLog.pub().info((Object)out);
        postWriter.write(out + "\n");
        postWriter.close();
    }

    @Override
    public Collection<IridiumMessage> pollMessages(Date timeSince) throws Exception {
        NeptusLog.pub().info((Object)("Polling messages since " + HubIridiumMessenger.dateToString(timeSince)));
        String since = null;
        if (timeSince != null) {
            since = HubIridiumMessenger.dateToString(timeSince);
        }
        URL u = new URL(this.messagesUrl + "?since=" + since);
        if (since == null) {
            u = new URL(this.messagesUrl);
        }
        HttpURLConnection conn = (HttpURLConnection)u.openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("GET");
        conn.setConnectTimeout(this.timeoutMillis);
        Gson gson = new Gson();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)conn.getInputStream(), (OutputStream)baos);
        this.logHubInteraction("Iridium Poll", u.toString(), conn.getRequestMethod(), "" + conn.getResponseCode(), "", new String(baos.toByteArray()));
        if (conn.getResponseCode() != 200) {
            throw new Exception("Hub iridium server returned " + conn.getResponseCode() + ": " + conn.getResponseMessage());
        }
        HubMessage[] msgs = (HubMessage[])gson.fromJson(baos.toString(), HubMessage[].class);
        Vector<IridiumMessage> ret = new Vector<IridiumMessage>();
        for (HubMessage m : msgs) {
            ret.add(m.message());
        }
        return ret;
    }

    @Override
    public String getName() {
        return "HUB Iridium Messenger";
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    public HubSystemMsg[] retrieveSystems() throws Exception {
        Gson gson = new Gson();
        URL url = new URL(this.systemsUrl);
        return (HubSystemMsg[])gson.fromJson((Reader)new InputStreamReader(url.openStream()), HubSystemMsg[].class);
    }

    public static String dateToString(Date d) {
        return dateFormat.format(d);
    }

    public static Date stringToDate(String d) {
        try {
            return dateFormat.parse(d);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void cleanup() {
        this.listeners.clear();
    }

    public static void main(String[] args) throws Exception {
        HubIridiumMessenger messenger = new HubIridiumMessenger();
        Date d = new Date(System.currentTimeMillis() - 216000000L);
        System.out.println(HubIridiumMessenger.dateToString(d));
        System.out.println(messenger.pollMessages(d).size());
    }

    public String toString() {
        return this.getName();
    }

    static {
        dateFormat.setTimeZone(tz);
    }

    public static class HubSystemMsg {
        public int imcid;
        public String name;
        public String updated_at;
        public String created_at;
        public Double[] coordinates;
        public String pos_error_class;

        public Date updatedAt() {
            return HubIridiumMessenger.stringToDate(this.updated_at);
        }

        public Date createdAt() {
            return HubIridiumMessenger.stringToDate(this.created_at);
        }
    }

    public static class HubMessage {
        int type;
        String msg;
        String updated_at;

        public IridiumMessage message() throws Exception {
            byte[] data = Hex.decodeHex((char[])this.msg.toCharArray());
            return IridiumMessage.deserialize(data);
        }

        public Date updatedAt() {
            return HubIridiumMessenger.stringToDate(this.updated_at);
        }
    }
}

