/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.iridium;

import java.io.DataInput;
import java.util.Collection;
import java.util.Vector;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCInputStream;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IMCOutputStream;
import pt.lsts.neptus.comm.iridium.IridiumMessage;

public class ImcIridiumMessage
extends IridiumMessage {
    protected IMCMessage msg;
    public static int MaxPayloadSize = 258;

    public ImcIridiumMessage() {
        super(2010);
    }

    @Override
    public int serializeFields(IMCOutputStream out) throws Exception {
        if (this.msg != null) {
            out.writeUnsignedShort(this.msg.getMgid());
            out.writeUnsignedInt((long)((int)this.msg.getTimestamp()));
            int size = 6 + IMCDefinition.getInstance().serializeFields(this.msg, out);
            return size;
        }
        return 0;
    }

    @Override
    public int deserializeFields(IMCInputStream in) throws Exception {
        int type = in.readUnsignedShort();
        long timestamp = in.readUnsignedInt();
        this.msg = IMCDefinition.getInstance().create(IMCDefinition.getInstance().getMessageName(type), new Object[0]);
        this.msg.setTimestamp((double)timestamp);
        try {
            IMCDefinition.getInstance().deserializeFields(this.msg, (DataInput)in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.msg.getPayloadSize() + 6;
    }

    public final IMCMessage getMsg() {
        return this.msg;
    }

    public final void setMsg(IMCMessage msg) {
        if (msg != null) {
            this.source = msg.getSrc();
            this.destination = msg.getDst();
        }
        this.msg = msg;
    }

    @Override
    public Collection<IMCMessage> asImc() {
        Vector<IMCMessage> vec = new Vector<IMCMessage>();
        if (this.msg != null) {
            vec.add(this.msg);
        }
        return vec;
    }

    @Override
    public String toString() {
        String s = super.toString();
        return s + "\tMessage: " + this.getMsg().toString();
    }
}

