/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.iridium;

import java.util.Collection;
import java.util.Vector;
import pt.lsts.imc.IMCInputStream;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IMCOutputStream;
import pt.lsts.imc.TextMessage;
import pt.lsts.neptus.comm.iridium.IridiumMessage;
import pt.lsts.neptus.plugins.NeptusProperty;

public class IridiumCommand
extends IridiumMessage {
    String command;
    @NeptusProperty(name="Send device updates", description="may increase communications costs!")
    public boolean sendDeviceUpdates;
    @NeptusProperty(name="Delay, in seconds, between device updates")
    public long secondsBetweenUpdates;
    @NeptusProperty(name="Use Iridium hardware", description="may increase communications costs!")
    public boolean useIridium;

    public IridiumCommand() {
        super(2005);
    }

    @Override
    public int serializeFields(IMCOutputStream out) throws Exception {
        out.writePlaintext(this.command);
        out.close();
        return this.command.getBytes("ISO-8859-1").length + 2;
    }

    @Override
    public int deserializeFields(IMCInputStream in) throws Exception {
        int len = in.readUnsignedShort();
        byte[] data = new byte[len];
        in.readFully(data);
        this.command = new String(data, "ISO-8859-1");
        return data.length + 2;
    }

    public final String getCommand() {
        return this.command;
    }

    public final void setCommand(String command) {
        this.command = command;
    }

    @Override
    public Collection<IMCMessage> asImc() {
        Vector<IMCMessage> msgs = new Vector<IMCMessage>();
        msgs.add((IMCMessage)new TextMessage("iridium", this.command));
        return msgs;
    }

    @Override
    public String toString() {
        String s = super.toString();
        return s + "\tCommand: " + this.getCommand() + "\n";
    }
}

