/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.iridium;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.JOptionPane;
import org.apache.commons.codec.binary.Hex;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IMCUtil;
import pt.lsts.imc.IridiumMsgTx;
import pt.lsts.imc.MessagePart;
import pt.lsts.imc.net.IMCFragmentHandler;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.iridium.DuneIridiumMessenger;
import pt.lsts.neptus.comm.iridium.ExtendedDeviceUpdate;
import pt.lsts.neptus.comm.iridium.HubIridiumMessenger;
import pt.lsts.neptus.comm.iridium.ImcIridiumMessage;
import pt.lsts.neptus.comm.iridium.IridiumMessage;
import pt.lsts.neptus.comm.iridium.IridiumMessenger;
import pt.lsts.neptus.comm.iridium.Position;
import pt.lsts.neptus.comm.iridium.RockBlockIridiumMessenger;
import pt.lsts.neptus.comm.iridium.SimulatedMessenger;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.util.ByteUtil;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.conf.GeneralPreferences;

public class IridiumManager {
    private static IridiumManager instance = null;
    private DuneIridiumMessenger duneMessenger;
    private RockBlockIridiumMessenger rockBlockMessenger;
    private HubIridiumMessenger hubMessenger;
    private SimulatedMessenger simMessenger;
    private ScheduledExecutorService service = null;
    public static final int IRIDIUM_MTU = 270;
    public static final int IRIDIUM_HEADER = 6;
    private Runnable pollMessages = new Runnable(){
        Date lastTime = new Date(System.currentTimeMillis() - 3600000L);

        @Override
        public void run() {
            try {
                Date now = new Date();
                Collection<IridiumMessage> msgs = IridiumManager.this.getCurrentMessenger().pollMessages(this.lastTime);
                for (IridiumMessage m : msgs) {
                    IridiumManager.this.processMessage(m);
                }
                this.lastTime = now;
            }
            catch (Exception e) {
                e.printStackTrace();
                NeptusLog.pub().error((Object)e);
            }
        }
    };

    private IridiumManager() {
        this.duneMessenger = new DuneIridiumMessenger();
        this.rockBlockMessenger = new RockBlockIridiumMessenger();
        this.hubMessenger = new HubIridiumMessenger();
        this.simMessenger = new SimulatedMessenger();
    }

    public IridiumMessenger getCurrentMessenger() {
        switch (GeneralPreferences.iridiumMessenger) {
            case DuneIridiumMessenger: {
                return this.duneMessenger;
            }
            case HubIridiumMessenger: {
                return this.hubMessenger;
            }
            case RockBlockIridiumMessenger: {
                return this.rockBlockMessenger;
            }
        }
        return this.simMessenger;
    }

    public boolean isAvailable() {
        return this.getCurrentMessenger().isAvailable();
    }

    public synchronized boolean isActive() {
        return this.service != null;
    }

    public void processMessage(IridiumMessage msg) {
        try {
            IridiumMsgTx transmission = new IridiumMsgTx();
            transmission.setData(msg.serialize());
            transmission.setSrc(msg.getSource());
            transmission.setDst(msg.getDestination());
            transmission.setTimestamp((double)msg.timestampMillis / 1000.0);
            ImcMsgManager.getManager().postInternalMessage("IridiumManager", (IMCMessage)transmission);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
        }
        Collection<IMCMessage> msgs = msg.asImc();
        for (IMCMessage m : msgs) {
            ImcMsgManager.getManager().postInternalMessage("iridium", m);
        }
    }

    public void selectMessenger(Component parent) {
        Object op = JOptionPane.showInputDialog(parent, "Select Iridium provider", "Iridium Provider", 3, ImageUtils.createImageIcon("images/satellite.png"), (Object[])IridiumMessengerEnum.values(), (Object)GeneralPreferences.iridiumMessenger);
        if (op != null) {
            GeneralPreferences.iridiumMessenger = (IridiumMessengerEnum)((Object)op);
            GeneralPreferences.saveProperties();
        }
    }

    public synchronized void start() {
        if (this.service != null) {
            this.stop();
        }
        ImcMsgManager.registerBusListener(this);
        this.service = Executors.newScheduledThreadPool(1);
        this.service.scheduleAtFixedRate(this.pollMessages, 0L, 5L, TimeUnit.MINUTES);
    }

    public synchronized void stop() {
        if (this.service != null) {
            this.service.shutdownNow();
            this.service = null;
        }
        ImcMsgManager.unregisterBusListener(this);
    }

    public static IridiumManager getManager() {
        if (instance == null) {
            instance = new IridiumManager();
        }
        return instance;
    }

    public static Collection<ImcIridiumMessage> iridiumEncode(IMCMessage msg) throws Exception {
        if (msg.getPayloadSize() < ImcIridiumMessage.MaxPayloadSize) {
            ImcIridiumMessage m = new ImcIridiumMessage();
            m.setSource(msg.getSrc());
            m.setDestination(msg.getDst());
            m.timestampMillis = msg.getTimestampMillis();
            m.msg = msg;
            return Arrays.asList(m);
        }
        MessagePart[] parts = new IMCFragmentHandler(IMCDefinition.getInstance()).fragment(msg, ImcIridiumMessage.MaxPayloadSize + IMCDefinition.getInstance().headerLength());
        ArrayList<ImcIridiumMessage> ret = new ArrayList<ImcIridiumMessage>();
        for (MessagePart mp : parts) {
            ImcIridiumMessage m = new ImcIridiumMessage();
            m.setSource(msg.getSrc());
            m.setDestination(msg.getDst());
            m.timestampMillis = msg.getTimestampMillis();
            m.msg = mp;
            ret.add(m);
        }
        return ret;
    }

    public static void testMessageSerialization() {
        IMCDefinition defs = IMCDefinition.getInstance();
        for (String abbrev : defs.getMessageNames()) {
            IMCMessage m = defs.create(abbrev, new Object[0]);
            IMCUtil.fillWithRandomData((IMCMessage)m);
            System.out.println("Message of type " + m.getAbbrev() + " and size " + m.getPayloadSize());
            System.out.println(m);
            try {
                Collection<ImcIridiumMessage> msgs = IridiumManager.iridiumEncode(m);
                System.out.println(" ==> " + msgs.size() + " messages");
                for (ImcIridiumMessage msg : msgs) {
                    ByteUtil.dumpAsHex("Iridium message of type " + msg.getMessageType(), msg.serialize(), System.out);
                    for (byte b : msg.serialize()) {
                        System.out.printf("%02X", b);
                    }
                    System.out.println();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void send(IridiumMessage msg) throws Exception {
        NeptusLog.pub().info((Object)("Sending iridum message via " + this.getCurrentMessenger().getName() + ": " + ByteUtil.encodeToHex(msg.serialize())));
        this.getCurrentMessenger().sendMessage(msg);
    }

    public static void main(String[] args) throws Exception {
        String hexText = "ffff0000db07002247545653000000000000000041002147545653000000000000000042000147545653000000000000000031000047545653000000000000000032000047545653000000000000000030";
        byte[] data = Hex.decodeHex((char[])hexText.toCharArray());
        ExtendedDeviceUpdate devupd = (ExtendedDeviceUpdate)IridiumMessage.deserialize(data);
        for (Position p : devupd.positions.values()) {
            System.out.println((Object)p.posType);
        }
    }

    public static enum IridiumMessengerEnum {
        DuneIridiumMessenger,
        RockBlockIridiumMessenger,
        HubIridiumMessenger,
        SimulatedMessenger;

    }
}

