/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.iridium;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCInputStream;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IMCOutputStream;
import pt.lsts.neptus.comm.iridium.ActivateSubscription;
import pt.lsts.neptus.comm.iridium.DeactivateSubscription;
import pt.lsts.neptus.comm.iridium.DesiredAssetPosition;
import pt.lsts.neptus.comm.iridium.DeviceUpdate;
import pt.lsts.neptus.comm.iridium.ExtendedDeviceUpdate;
import pt.lsts.neptus.comm.iridium.ImcIridiumMessage;
import pt.lsts.neptus.comm.iridium.IridiumCommand;
import pt.lsts.neptus.comm.iridium.TargetAssetPosition;

public abstract class IridiumMessage
implements Comparable<IridiumMessage> {
    public int source;
    public int destination;
    public int message_type;
    public long timestampMillis = System.currentTimeMillis();
    private static LinkedHashMap<Integer, Class<? extends IridiumMessage>> iridiumTypes = new LinkedHashMap();

    public abstract int serializeFields(IMCOutputStream var1) throws Exception;

    public abstract int deserializeFields(IMCInputStream var1) throws Exception;

    public abstract Collection<IMCMessage> asImc();

    public IridiumMessage(int msgType) {
        this.message_type = msgType;
    }

    public byte[] serialize() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IMCOutputStream ios = new IMCOutputStream((OutputStream)baos);
        ios.setBigEndian(false);
        int size = 6;
        ios.writeUnsignedShort(this.source);
        ios.writeUnsignedShort(this.destination);
        ios.writeUnsignedShort(this.message_type);
        return Arrays.copyOf(baos.toByteArray(), size += this.serializeFields(ios));
    }

    public static IridiumMessage deserialize(byte[] data) throws Exception {
        IMCInputStream iis = new IMCInputStream((InputStream)new ByteArrayInputStream(data), IMCDefinition.getInstance());
        iis.setBigEndian(false);
        int source = iis.readUnsignedShort();
        int dest = iis.readUnsignedShort();
        int mgid = iis.readUnsignedShort();
        IridiumMessage m = null;
        if (!iridiumTypes.containsKey(mgid)) {
            iis.close();
            throw new Exception("Unrecognized message type: " + mgid);
        }
        m = iridiumTypes.get(mgid).newInstance();
        if (m != null) {
            m.setSource(source);
            m.setDestination(dest);
            m.setMessageType(mgid);
            m.deserializeFields(iis);
        }
        iis.close();
        return m;
    }

    public final int getSource() {
        return this.source;
    }

    public final void setSource(int source) {
        this.source = source;
    }

    public final int getDestination() {
        return this.destination;
    }

    public final void setDestination(int destination) {
        this.destination = destination;
    }

    public final int getMessageType() {
        return this.message_type;
    }

    public final void setMessageType(int message_type) {
        this.message_type = message_type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Message of type " + this.getClass().getSimpleName() + " {\n");
        sb.append("\tSource: " + IMCDefinition.getInstance().getResolver().resolve(this.getSource()) + "\n");
        sb.append("\tDestination: " + IMCDefinition.getInstance().getResolver().resolve(this.getDestination()) + "\n");
        return sb.toString();
    }

    @Override
    public int compareTo(IridiumMessage o) {
        return (int)(this.timestampMillis - o.timestampMillis);
    }

    static {
        iridiumTypes.put(2001, DeviceUpdate.class);
        iridiumTypes.put(2003, ActivateSubscription.class);
        iridiumTypes.put(2004, DeactivateSubscription.class);
        iridiumTypes.put(2005, IridiumCommand.class);
        iridiumTypes.put(2006, DesiredAssetPosition.class);
        iridiumTypes.put(2007, TargetAssetPosition.class);
        iridiumTypes.put(2010, ImcIridiumMessage.class);
        iridiumTypes.put(2011, ExtendedDeviceUpdate.class);
    }
}

