/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.iridium;

import java.util.HashMap;
import java.util.Map;

public class Position {
    public int id;
    public double latRads;
    public double lonRads;
    public double timestamp;
    public PosType posType = PosType.Unknown;
    private static final Map<Long, PosType> intToTypeMap = new HashMap<Long, PosType>();

    public static PosType fromImcId(int imcId) {
        int sys_selector = 57344;
        int vtype_selector = 6144;
        int sys_type = (imcId & sys_selector) >> 13;
        switch (sys_type) {
            case 0: 
            case 1: {
                switch ((imcId & vtype_selector) >> 11) {
                    case 0: {
                        return PosType.AUV;
                    }
                    case 1: {
                        return PosType.AUV;
                    }
                    case 2: {
                        return PosType.ASV;
                    }
                    case 3: {
                        return PosType.UAV;
                    }
                }
                return PosType.Unknown;
            }
            case 2: {
                return PosType.CCU;
            }
        }
        return PosType.Unknown;
    }

    public static PosType fromInt(int i) {
        PosType type = intToTypeMap.get(i);
        if (type == null) {
            return PosType.Unknown;
        }
        return type;
    }

    static {
        for (PosType type : PosType.values()) {
            intToTypeMap.put(type.value, type);
        }
    }

    public static enum PosType {
        Unknown(0L, 0L, "Unknown / Other"),
        AUV(17L, 0L, "Autonomous Underwater Vehicle"),
        UAV(18L, 0L, "Unmanned Aerial Vehicle"),
        ASV(19L, 0L, "Autonomous Surface Vehicle"),
        CCU(101L, 0L, "Command and Control Unit"),
        SpotTag(103L, 0L, "SPOT satellite tag"),
        Argos0(48L, 3000L, "Argos tag position of class 0 (more than 1500 m of uncertainty radius)"),
        Argos1(49L, 1500L, "Argos tag position of class 1 (500 m < uncertainty radius < 1500 m)"),
        Argos2(50L, 500L, "Argos tag position of class 2 (250 m < uncertainty radius < 500 m)"),
        Argos3(51L, 250L, "Argos tag position of class 3 (uncertainty radius < 250 m)"),
        ArgosA(65L, 3000L, "Argos tag position of class A (uncertainty radius > 1500 m, 3 transmissions)"),
        ArgosB(66L, 3000L, "Argos tag position of class B (uncertainty radius > 1500 m, 2 transmissions)"),
        ArgosG(71L, 100L, "Argos tag position of class G (GPS, uncertainty radius < 100 m)"),
        ArgosZ(90L, 0L, "Argos tag position of class Z (no position obtained)");

        protected long value;
        protected long uncertainty;
        protected String desc;

        public long value() {
            return this.value;
        }

        public long uncertainty() {
            return this.uncertainty;
        }

        public String desc() {
            return this.desc;
        }

        private PosType(long value, long uncertainty, String desc) {
            this.value = value;
            this.desc = desc;
        }
    }
}

