/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.iridium;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.BodyPart;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeMultipart;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.iridium.IridiumMessage;
import pt.lsts.neptus.comm.iridium.IridiumMessageListener;
import pt.lsts.neptus.comm.iridium.IridiumMessenger;
import pt.lsts.neptus.comm.iridium.IridiumProvider;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.data.Pair;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.types.comm.protocol.IridiumArgs;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.ByteUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

@IridiumProvider(id="rock7", name="RockBlock Messenger", description="Sends Iridium messages directly via RockBlock web service and receives new messages by polling a gmail address")
public class RockBlockIridiumMessenger
implements IridiumMessenger {
    protected boolean available = true;
    protected String serverUrl = "https://secure.rock7mobile.com/rockblock/MT";
    protected HashSet<IridiumMessageListener> listeners = new HashSet();
    private static long lastSuccess = -1L;
    @NeptusProperty
    private boolean alwaysAskForPassword = false;
    @NeptusProperty
    private String rockBlockPassword = null;
    @NeptusProperty
    private String rockBlockUsername = null;
    @NeptusProperty
    private String gmailUsername = null;
    @NeptusProperty
    private String gmailPassword = null;
    @NeptusProperty
    private String gmailAccount = "lsts.iridium";
    private boolean askRockBlockPassword = true;
    private boolean askGmailPassword = true;
    private Pattern pattern;

    public RockBlockIridiumMessenger() {
        try {
            PluginUtils.loadProperties("conf/rockblock.props", (Object)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.askGmailPassword = this.askRockBlockPassword = this.alwaysAskForPassword;
        this.pattern = Pattern.compile("APPLICATION/OCTET-STREAM; name=(\\d+)-(\\d+)\\.bin");
    }

    private String getRockBlockUsername() {
        if (this.rockBlockUsername == null) {
            return "";
        }
        return this.rockBlockUsername;
    }

    private String getRockBlockPassword() {
        if (this.rockBlockPassword == null) {
            return "";
        }
        return StringUtils.newStringUtf8((byte[])DatatypeConverter.parseBase64Binary((String)this.rockBlockPassword));
    }

    private void setRockBlockPassword(String password) {
        if (password == null) {
            this.rockBlockPassword = null;
        }
        this.rockBlockPassword = DatatypeConverter.printBase64Binary((byte[])password.getBytes(Charset.forName("UTF8")));
    }

    private void setRockBlockUsername(String username) {
        if (username == null) {
            this.rockBlockUsername = null;
        }
        this.rockBlockUsername = username;
    }

    private String getGmailUsername() {
        if (this.gmailUsername == null) {
            return "";
        }
        return this.gmailUsername;
    }

    private String getGmailPassword() {
        if (this.gmailPassword == null) {
            return "";
        }
        return StringUtils.newStringUtf8((byte[])DatatypeConverter.parseBase64Binary((String)this.gmailPassword));
    }

    private void setGmailPassword(String password) {
        if (password == null) {
            this.gmailPassword = null;
        }
        this.gmailPassword = DatatypeConverter.printBase64Binary((byte[])password.getBytes(Charset.forName("UTF8")));
    }

    private void setGmailUsername(String username) {
        if (username == null) {
            this.gmailUsername = null;
        }
        this.gmailUsername = username;
    }

    @Override
    public void sendMessage(IridiumMessage msg) throws Exception {
        String result;
        VehicleType vt = VehiclesHolder.getVehicleWithImc(new ImcId16(msg.getDestination()));
        if (vt == null) {
            throw new Exception("Cannot send message to an unknown destination");
        }
        IridiumArgs args = (IridiumArgs)vt.getProtocolsArgs().get("iridium");
        if (this.askRockBlockPassword || this.rockBlockPassword == null || this.rockBlockUsername == null) {
            Pair<String, String> credentials = GuiUtils.askCredentials(ConfigFetch.getSuperParentFrame(), "Enter RockBlock Credentials", this.getRockBlockUsername(), this.getRockBlockPassword());
            if (credentials == null) {
                return;
            }
            this.setRockBlockUsername(credentials.first());
            this.setRockBlockPassword(credentials.second());
            PluginUtils.saveProperties("conf/rockblock.props", this);
            this.askRockBlockPassword = false;
        }
        if ((result = RockBlockIridiumMessenger.sendToRockBlockHttp(args.getImei(), this.getRockBlockUsername(), this.getRockBlockPassword(), msg.serialize())) != null && !result.split(",")[0].equals("OK")) {
            throw new Exception("RockBlock server failed to deliver the message: '" + result + "'");
        }
    }

    public static String sendToRockBlockHttp(String destImei, String username, String password, byte[] data) throws HttpException, IOException {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost post = new HttpPost("https://secure.rock7mobile.com/rockblock/MT");
        ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
        urlParameters.add(new BasicNameValuePair("imei", destImei));
        urlParameters.add(new BasicNameValuePair("username", username));
        urlParameters.add(new BasicNameValuePair("password", password));
        urlParameters.add(new BasicNameValuePair("data", ByteUtil.encodeToHex(data)));
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParameters));
        post.setHeader("Content-Type", "application/x-www-form-urlencoded");
        HttpResponse response = client.execute((HttpUriRequest)post);
        BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        StringBuffer result = new StringBuffer();
        String line = "";
        while ((line = rd.readLine()) != null) {
            result.append(line);
        }
        return result.toString();
    }

    @Override
    public Collection<IridiumMessage> pollMessages(Date timeSince) throws Exception {
        if (this.askGmailPassword || this.gmailPassword == null || this.gmailUsername == null) {
            Pair<String, String> credentials = GuiUtils.askCredentials(ConfigFetch.getSuperParentFrame(), "Enter Gmail Credentials", this.getGmailUsername(), this.getGmailPassword());
            if (credentials == null) {
                return null;
            }
            this.setGmailUsername(credentials.first());
            this.setGmailPassword(credentials.second());
            PluginUtils.saveProperties("conf/rockblock.props", this);
            this.askGmailPassword = false;
        }
        Properties props = new Properties();
        props.put("mail.store.protocol", "imaps");
        ArrayList<IridiumMessage> messages = new ArrayList<IridiumMessage>();
        try {
            int numMsgs;
            Message m;
            Session session = Session.getDefaultInstance((Properties)props, null);
            Store store = session.getStore("imaps");
            store.connect("imap.gmail.com", this.getGmailUsername(), this.getGmailPassword());
            Folder inbox = store.getFolder("Inbox");
            inbox.open(1);
            for (int i = numMsgs = inbox.getMessageCount(); i > 0 && !(m = inbox.getMessage(i)).getReceivedDate().before(timeSince); --i) {
                MimeMultipart mime = (MimeMultipart)m.getContent();
                for (int j = 0; j < mime.getCount(); ++j) {
                    InputStream stream;
                    byte[] data;
                    IridiumMessage msg;
                    BodyPart p = mime.getBodyPart(j);
                    Matcher matcher = this.pattern.matcher(p.getContentType());
                    if (!matcher.matches() || (msg = this.process(data = IOUtils.toByteArray((InputStream)(stream = (InputStream)p.getContent())), matcher.group(1))) == null) continue;
                    messages.add(msg);
                }
            }
        }
        catch (NoSuchProviderException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (MessagingException ex) {
            ex.printStackTrace();
            System.exit(2);
        }
        return messages;
    }

    private IridiumMessage process(byte[] data, String from) {
        try {
            return IridiumMessage.deserialize(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isAvailable() {
        try {
            return RockBlockIridiumMessenger.rockBlockIsReachable().get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String getName() {
        return "RockBlock Messenger";
    }

    @Override
    public void addListener(IridiumMessageListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IridiumMessageListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void cleanup() {
    }

    public static Future<Boolean> rockBlockIsReachable() {
        return new Future<Boolean>(){
            Boolean result = null;
            boolean canceled = false;
            long start = System.currentTimeMillis();
            {
                if (System.currentTimeMillis() - lastSuccess < 15000L) {
                    this.result = true;
                }
                try {
                    URL url = new URL("https://secure.rock7mobile.com/rockblock");
                    int len = url.openConnection().getContentLength();
                    if (len > 0) {
                        lastSuccess = System.currentTimeMillis();
                    }
                    this.result = len > 0;
                }
                catch (Exception e) {
                    NeptusLog.pub().error((Object)e);
                    this.result = false;
                }
            }

            @Override
            public Boolean get() throws InterruptedException, ExecutionException {
                while (this.result == null) {
                    Thread.sleep(100L);
                }
                return this.result;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                this.canceled = true;
                return false;
            }

            @Override
            public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                while (this.result == null) {
                    Thread.sleep(100L);
                    if (System.currentTimeMillis() - this.start <= unit.toMillis(timeout)) continue;
                    throw new TimeoutException("Time out while connecting");
                }
                return this.result;
            }

            @Override
            public boolean isCancelled() {
                return this.canceled;
            }

            @Override
            public boolean isDone() {
                return this.result != null;
            }
        };
    }

    public String toString() {
        return this.getName();
    }

    public static void main(String[] args) throws Exception {
        RockBlockIridiumMessenger messenger = new RockBlockIridiumMessenger();
        ConfigFetch.initialize();
        for (IridiumMessage msg : messenger.pollMessages(new Date(System.currentTimeMillis() - 3600000L))) {
            System.out.println(msg);
        }
    }
}

