/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.iridium;

import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IridiumMsgRx;
import pt.lsts.imc.IridiumMsgTx;
import pt.lsts.neptus.comm.iridium.IridiumMessage;
import pt.lsts.neptus.comm.iridium.IridiumMessageListener;
import pt.lsts.neptus.comm.iridium.IridiumMessenger;
import pt.lsts.neptus.comm.iridium.IridiumProvider;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;

@IridiumProvider(id="sim", name="Simulated Messenger", description="This messenger posts the Iridium message directly in the bus of the destination via IMC. Used only for debug / simulation purposes")
public class SimulatedMessenger
implements IridiumMessenger {
    protected Vector<IridiumMessage> messagesReceived = new Vector();
    protected HashSet<IridiumMessageListener> listeners = new HashSet();

    @Override
    public void addListener(IridiumMessageListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IridiumMessageListener listener) {
        this.listeners.remove(listener);
    }

    @Subscribe
    public void on(IridiumMsgTx tx) {
        try {
            IridiumMessage m = IridiumMessage.deserialize(tx.getData());
            for (IridiumMessageListener listener : this.listeners) {
                listener.messageReceived(m);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendMessage(IridiumMessage msg) throws Exception {
        IridiumMsgRx rx = new IridiumMsgRx();
        rx.setOrigin("Iridium simulated messenger");
        rx.setDst(msg.getDestination());
        rx.setSrc(msg.getSource());
        rx.setData(msg.serialize());
        rx.setHtime((double)msg.timestampMillis / 1000.0);
        ImcMsgManager.getManager().sendMessage((IMCMessage)rx);
    }

    @Override
    public Collection<IridiumMessage> pollMessages(Date timeSince) throws Exception {
        return new Vector<IridiumMessage>();
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public String getName() {
        return "Simulated messenger";
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void cleanup() {
        this.listeners.clear();
        this.messagesReceived.clear();
    }
}

