/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.iridium;

import java.util.Collection;
import java.util.Vector;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCInputStream;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IMCOutputStream;
import pt.lsts.imc.RemoteSensorInfo;
import pt.lsts.neptus.comm.iridium.IridiumMessage;
import pt.lsts.neptus.types.coord.LocationType;

public class TargetAssetPosition
extends IridiumMessage {
    LocationType loc = new LocationType();
    public int asset_imc_id;

    public TargetAssetPosition() {
        super(2007);
    }

    @Override
    public int serializeFields(IMCOutputStream out) throws Exception {
        out.writeUnsignedShort(this.asset_imc_id);
        this.loc.convertToAbsoluteLatLonDepth();
        out.writeInt((int)Math.round(this.loc.getLatitudeDegs() * 1000000.0));
        out.writeInt((int)Math.round(this.loc.getLongitudeDegs() * 1000000.0));
        return 10;
    }

    @Override
    public int deserializeFields(IMCInputStream in) throws Exception {
        this.asset_imc_id = in.readUnsignedShort();
        this.loc = new LocationType();
        this.loc.setLatitudeDegs((double)in.readInt() / 1000000.0);
        this.loc.setLongitudeDegs((double)in.readInt() / 1000000.0);
        return 10;
    }

    public final LocationType getLocation() {
        return this.loc;
    }

    public final void setLocation(LocationType loc) {
        this.loc = loc;
    }

    public final int getAssetImcId() {
        return this.asset_imc_id;
    }

    public final void setAssetImcId(int asset_imc_id) {
        this.asset_imc_id = asset_imc_id;
    }

    @Override
    public Collection<IMCMessage> asImc() {
        Vector<IMCMessage> msgs = new Vector<IMCMessage>();
        RemoteSensorInfo sensorInfo = new RemoteSensorInfo();
        sensorInfo.setLat(this.getLocation().getLatitudeRads());
        sensorInfo.setLon(this.getLocation().getLongitudeRads());
        sensorInfo.setSensorClass("Target Position");
        sensorInfo.setAlt(0.0);
        sensorInfo.setId("TP_" + IMCDefinition.getInstance().getResolver().resolve(this.asset_imc_id));
        sensorInfo.setSrc(this.getSource());
        sensorInfo.setDst(this.getDestination());
        msgs.add((IMCMessage)sensorInfo);
        return msgs;
    }

    @Override
    public String toString() {
        String s = super.toString();
        return s + "\tAsset: " + IMCDefinition.getInstance().getResolver().resolve(this.getAssetImcId()) + "\n" + "\tLocation: " + this.getLocation() + "\n";
    }
}

