/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.comm.manager;

import com.l2fprod.common.swing.JOutlookBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.CommBaseManager;
import pt.lsts.neptus.comm.manager.CommManagerStatusChangeListener;
import pt.lsts.neptus.comm.manager.CommonCommBaseImplementation;
import pt.lsts.neptus.comm.manager.SystemCommBaseInfo;
import pt.lsts.neptus.gui.StatusLed;
import pt.lsts.neptus.gui.swing.JRoundButton;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.messages.IMessage;
import pt.lsts.neptus.messages.listener.MessageInfo;
import pt.lsts.neptus.messages.listener.MessageListener;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.MathMiscUtils;
import pt.lsts.neptus.util.conf.GeneralPreferences;
import pt.lsts.neptus.util.conf.PreferencesListener;

public abstract class BaseAbstractCommsMonitorPanel<W extends CommBaseManager<M, Mi, C, I, CommManagerStatusChangeListener>, C extends SystemCommBaseInfo<M, Mi, I>, M extends IMessage, Mi extends MessageInfo, I>
extends JPanel
implements CommManagerStatusChangeListener {
    private static final long serialVersionUID = 4617120125187818738L;
    protected I selectedSystem = null;
    private static ImageIcon CLEAR_ICON = new ImageIcon(ImageUtils.getImage("images/buttons/clear.png").getScaledInstance(16, 16, 4));
    private W commManager = null;
    private JOutlookBar topOutlookBar = null;
    private JTabbedPane monitorTabbedPane = null;
    private JPanel statusPanel = null;
    private JLabel statusLabel = null;
    private StatusLed statusLed = null;
    private JLabel statusNrSysLabel = null;
    private JTextField statusNrSysTextField = null;
    private JLabel queueSizeTextLabel = null;
    private JTextField queueSizeTextField = null;
    private StatusLed queueSizeStatusLed = null;
    private JRoundButton queueClearButton = null;
    private JLabel commonLastMsgArrivedLabel = null;
    private JTextField commonArrivalTimeText = null;
    private JTextField commonFreqArrivalTextField = null;
    private JTextField commonArrivalTxRxTimeNanosTextField = null;
    private JLabel commonLastMsgProcessLabel = null;
    private JTextField commonProcessTimeTextField = null;
    private JTextField commonFreqProcessTextField = null;
    private JTextField commonProcessTxRxTimeNanosTextField = null;
    private JRoundButton startCommButton = null;
    private JRoundButton stopCommButton = null;
    private JSeparator smallSeparator = null;
    private JLabel statusListenersLabel = null;
    private JTextField statusListenersSizeTextField = null;
    private JSeparator bigSeparator = null;
    private JScrollPane statusSysListScrollPane = null;
    private JList<String> statusSysList = null;
    private DefaultListModel<String> statusSysListModel = null;
    private JPanel systemCommsPanel = null;
    private JLabel sysTitleLabel = null;
    private JLabel sysIDLabel = null;
    private JLabel sysNameLabel = null;
    private JLabel sysActiveLabel = null;
    private StatusLed sysActiveLed = null;
    private JLabel activeListenerNameLabel = null;
    private JLabel sysLastMsgArrivedLabel = null;
    private JTextField sysArrivalTimeText = null;
    private JTextField sysFreqArrivalTextField = null;
    private JTextField sysArrivalTxRxTimeNanosTextField = null;
    private JLabel sysLastMsgProcessLabel = null;
    private JTextField sysProcessTimeTextField = null;
    private JTextField sysFreqProcessTextField = null;
    private JTextField sysProcessTxRxTimeNanosTextField = null;
    private JLabel sysQueueSizeLabel = null;
    private JTextField sysQueueSizeTextField = null;
    private StatusLed sysQueueSizeStatusLed = null;
    private JRoundButton sysQueueClearButton = null;
    private JLabel sysListenersSizeLabel = null;
    private JTextField sysListenersSizeTextField = null;
    private JPanel addSystemCommPanel = null;
    private Timer updateGuiTimer = null;
    private TimerTask updateGuiTask = null;
    private TimerTask updateGuiTask2 = null;
    protected int queueMaxSize = 1024;
    protected PreferencesListener preferencesListener = new PreferencesListener(){

        @Override
        public void preferencesUpdated() {
            BaseAbstractCommsMonitorPanel.this.queueMaxSize = GeneralPreferences.commsQueueSize;
        }
    };

    public BaseAbstractCommsMonitorPanel(W commManager) {
        this.setCommManager(commManager);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(396, 411));
        this.setPreferredSize(new Dimension(396, 411));
        this.add((Component)this.getTopOutlookBar(), "Center");
        this.updateGuiTimer = new Timer(BaseAbstractCommsMonitorPanel.class.getSimpleName(), true);
        this.updateGuiTask = new TimerTask(){

            @Override
            public void run() {
                boolean running = ((CommBaseManager)BaseAbstractCommsMonitorPanel.this.getCommManager()).isRunning();
                if (running) {
                    BaseAbstractCommsMonitorPanel.this.statusLed.setLevel((short)0, I18n.text("Running."));
                } else {
                    BaseAbstractCommsMonitorPanel.this.statusLed.setLevel((short)-1, I18n.text("Not running."));
                }
                if (!running) {
                    return;
                }
                BaseAbstractCommsMonitorPanel.this.updateSystemList();
            }
        };
        this.updateGuiTask2 = new TimerTask(){

            @Override
            public void run() {
                int queueSize = ((CommonCommBaseImplementation)BaseAbstractCommsMonitorPanel.this.getCommManager()).getMsgQueueLength();
                BaseAbstractCommsMonitorPanel.this.getQueueSizeTextField().setText("" + queueSize);
                BaseAbstractCommsMonitorPanel.this.getStatusListenersSizeTextField().setText("" + ((CommBaseManager)BaseAbstractCommsMonitorPanel.this.getCommManager()).getStatusListenersSize());
                if (queueSize < BaseAbstractCommsMonitorPanel.this.queueMaxSize) {
                    BaseAbstractCommsMonitorPanel.this.getQueueSizeStatusLed().setLevel((short)0, I18n.text("Queue OK"));
                } else {
                    BaseAbstractCommsMonitorPanel.this.getQueueSizeStatusLed().setLevel((short)1, I18n.text("Queue full"));
                }
                BaseAbstractCommsMonitorPanel.this.updateSystemCommData();
            }
        };
        this.updateGuiTimer.schedule(this.updateGuiTask, 200L);
        this.updateGuiTimer.scheduleAtFixedRate(this.updateGuiTask2, 500L, 200L);
        ((CommBaseManager)this.getCommManager()).addStatusListener((BaseAbstractCommsMonitorPanel)this);
        this.preferencesListener.preferencesUpdated();
        GeneralPreferences.addPreferencesListener(this.preferencesListener);
    }

    public void cleanup() {
        if (this.updateGuiTask != null) {
            this.updateGuiTask.cancel();
        }
        if (this.updateGuiTask2 != null) {
            this.updateGuiTask2.cancel();
        }
        if (this.updateGuiTimer != null) {
            this.updateGuiTimer.cancel();
        }
        ((CommBaseManager)this.getCommManager()).removeStatusListener((BaseAbstractCommsMonitorPanel)this);
        GeneralPreferences.removePreferencesListener(this.preferencesListener);
    }

    public final W getCommManager() {
        return this.commManager;
    }

    public final void setCommManager(W commManager) {
        this.commManager = commManager;
    }

    public abstract ImageIcon getOnIcon();

    public abstract ImageIcon getOffIcon();

    private void updateSystemList() {
        W sm = this.getCommManager();
        this.statusNrSysTextField.setText("" + ((CommBaseManager)sm).getNumberOfSystems());
        Object[] exel = new String[this.statusSysListModel.size()];
        this.statusSysListModel.copyInto(exel);
        Vector<Object> exelVRemove = new Vector<Object>();
        Vector<Object> exelVAdd = new Vector<Object>();
        for (Object st1 : exel) {
            exelVRemove.add(st1);
            exelVAdd.add(st1);
        }
        for (Object i : ((CommBaseManager)sm).getCommInfo().keySet()) {
            if (!exelVRemove.contains(this.convertStringIdAndNameToStringIdName(this.translateIdToStringId(i), this.translateSystemIdToName(i)))) continue;
            exelVRemove.remove(this.convertStringIdAndNameToStringIdName(this.translateIdToStringId(i), this.translateSystemIdToName(i)));
        }
        for (Object i : ((CommBaseManager)sm).getCommInfo().keySet()) {
            if (exelVAdd.contains(this.convertStringIdAndNameToStringIdName(this.translateIdToStringId(i), this.translateSystemIdToName(i)))) continue;
            this.statusSysListModel.addElement(this.convertStringIdAndNameToStringIdName(this.translateIdToStringId(i), this.translateSystemIdToName(i)));
        }
        for (String string : exelVRemove) {
            this.statusSysListModel.removeElement(string);
        }
        this.statusSysList.repaint();
    }

    private String convertStringIdNameToStringId(String val) {
        if (val == null) {
            return val;
        }
        return val.replaceFirst(" \\[[^\\]]*\\]$", "");
    }

    private String convertStringIdAndNameToStringIdName(String id, String name) {
        return id + " [" + name + "]";
    }

    protected String convertTimeSecondsToFormatedString(double timeSeconds) {
        String tt = "";
        tt = DateTimeUtil.milliSecondsToFormatedString((long)(timeSeconds * 1000.0));
        return tt;
    }

    private String convertTimeSecondsToFormatedStringNanos(double timeSeconds) {
        String tt = "";
        tt = timeSeconds < 60.0 ? MathMiscUtils.parseToEngineeringNotation(timeSeconds, 3) + "s" : DateTimeUtil.milliSecondsToFormatedString((long)(timeSeconds * 1000.0));
        return tt;
    }

    private void updateSystemCommData() {
        W sman = this.getCommManager();
        String deltaStr = I18n.text("\u2206tTxRx") + " ";
        String deltaStr2 = "\u2206tRxHdl ";
        String unknownStr = "? s";
        double tmpMillis = ((CommonCommBaseImplementation)sman).getProcessTimeMillisLastMsg();
        double time = (double)(System.currentTimeMillis() - (long)tmpMillis) / 1000.0;
        if (tmpMillis < 0.0) {
            this.getCommonProcessTimeTextField().setText(unknownStr);
        } else {
            this.getCommonProcessTimeTextField().setText(this.convertTimeSecondsToFormatedStringNanos(time));
        }
        double tmpNanos = ((CommonCommBaseImplementation)sman).getProcessDeltaTxRxTimeNanosLastMsg();
        String tmpConvNanos = unknownStr;
        if (tmpNanos >= 0.0) {
            tmpConvNanos = this.convertTimeSecondsToFormatedStringNanos(tmpNanos / 1.0E9);
        }
        this.getCommonProcessTxRxTimeNanosText().setText(deltaStr2 + tmpConvNanos);
        if (time < 2.0) {
            this.getCommonFreqProcessTextField().setText(MathMiscUtils.parseToEngineeringNotation(((CommonCommBaseImplementation)sman).getProcessMessageFreq(), 0) + " Hz");
        } else {
            this.getCommonFreqProcessTextField().setText("- Hz");
        }
        tmpMillis = ((CommonCommBaseImplementation)sman).getArrivalTimeMillisLastMsg();
        time = (double)(System.currentTimeMillis() - (long)tmpMillis) / 1000.0;
        if (tmpMillis < 0.0) {
            this.getCommonArrivalTimeText().setText(unknownStr);
        } else {
            this.getCommonArrivalTimeText().setText(this.convertTimeSecondsToFormatedStringNanos(time));
        }
        tmpNanos = ((CommonCommBaseImplementation)sman).getArrivalDeltaTxRxTimeNanosLastMsg();
        tmpConvNanos = unknownStr;
        if (tmpNanos >= 0.0) {
            tmpConvNanos = this.convertTimeSecondsToFormatedStringNanos(tmpNanos / 1.0E9);
        }
        this.getCommonArrivalTxRxTimeNanosText().setText(deltaStr + tmpConvNanos);
        if (time < 2.0) {
            this.getCommonFreqArrivalTextField().setText(MathMiscUtils.parseToEngineeringNotation(((CommonCommBaseImplementation)sman).getArrivalMessageFreq(), 0) + " Hz");
        } else {
            this.getCommonFreqArrivalTextField().setText("- Hz");
        }
        try {
            this.updateVehicleCommDataPeriodicCall();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.selectedSystem == null) {
            return;
        }
        SystemCommBaseInfo vci = (SystemCommBaseInfo)((CommBaseManager)sman).getCommInfo().get(this.selectedSystem);
        if (vci == null) {
            return;
        }
        if (!this.getSystemCommsPanel().isShowing()) {
            return;
        }
        this.getSysActiveLed().setLevel(vci.isActive() ? (short)0 : 1);
        int queueSize = vci.getMsgQueueLength();
        this.getSysQueueSizeTextField().setText("" + queueSize);
        if (queueSize < this.queueMaxSize) {
            this.getSysQueueSizeStatusLed().setLevel((short)0, I18n.text("Queue OK"));
        } else {
            this.getSysQueueSizeStatusLed().setLevel((short)1, I18n.text("Queue full"));
        }
        this.sysIDLabel.setText(this.translateIdToStringId(this.selectedSystem));
        try {
            this.sysNameLabel.setText(this.translateSystemIdToName(vci.getSystemCommId()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        tmpMillis = vci.getProcessTimeMillisLastMsg();
        time = (double)(System.currentTimeMillis() - (long)tmpMillis) / 1000.0;
        if (tmpMillis < 0.0) {
            this.getSysProcessTimeTextField().setText(unknownStr);
        } else {
            this.getSysProcessTimeTextField().setText(this.convertTimeSecondsToFormatedStringNanos(time));
        }
        tmpNanos = vci.getProcessDeltaTxRxTimeNanosLastMsg();
        tmpConvNanos = unknownStr;
        if (tmpNanos >= 0.0) {
            tmpConvNanos = this.convertTimeSecondsToFormatedStringNanos(tmpNanos / 1.0E9);
        }
        this.getSysProcessTxRxTimeNanosTextField().setText(deltaStr2 + tmpConvNanos);
        if (time < 2.0) {
            this.getSysFreqProcessTextField().setText(MathMiscUtils.parseToEngineeringNotation(vci.getProcessMessageFreq(), 0) + " Hz");
        } else {
            this.getSysFreqProcessTextField().setText("- Hz");
        }
        tmpMillis = vci.getArrivalTimeMillisLastMsg();
        time = (double)(System.currentTimeMillis() - (long)tmpMillis) / 1000.0;
        if (tmpMillis < 0.0) {
            this.getSysArrivalTimeText().setText(unknownStr);
        } else {
            this.getSysArrivalTimeText().setText(this.convertTimeSecondsToFormatedStringNanos(time));
        }
        tmpNanos = vci.getArrivalDeltaTxRxTimeNanosLastMsg();
        tmpConvNanos = unknownStr;
        if (tmpNanos >= 0.0) {
            tmpConvNanos = this.convertTimeSecondsToFormatedStringNanos(tmpNanos / 1.0E9);
        }
        this.getSysArrivalTxRxTimeNanosTextField().setText(deltaStr + tmpConvNanos);
        if (time < 2.0) {
            this.getSysFreqArrivalTextField().setText(MathMiscUtils.parseToEngineeringNotation(vci.getArrivalMessageFreq(), 0) + " Hz");
        } else {
            this.getSysFreqArrivalTextField().setText("- Hz");
        }
        this.getSysListenersSizeTextField().setText("" + vci.getListenersSize());
        MessageListener lastListener = vci.getLastListener();
        if (lastListener == null) {
            this.activeListenerNameLabel.setText("");
        } else {
            String name = lastListener.getClass().getSimpleName();
            this.activeListenerNameLabel.setText(name);
        }
    }

    protected void updateVehicleCommDataPeriodicCall() {
    }

    protected abstract String translateSystemIdToName(I var1);

    protected abstract I translateStringIdToId(String var1);

    protected abstract String translateIdToStringId(I var1);

    @Override
    public final void managerStatusChanged(int status, String msg) {
        if (status == 0) {
            this.statusLed.setLevel((short)0, I18n.text("Running"));
        } else if (status == 1) {
            this.statusLed.setLevel((short)-1, I18n.text("Not running"));
        }
    }

    @Override
    public final void managerVehicleAdded(VehicleType vehicle) {
        this.updateSystemList();
    }

    @Override
    public final void managerVehicleRemoved(VehicleType vehicle) {
        this.updateSystemList();
    }

    @Override
    public final void managerVehicleStatusChanged(VehicleType vehicle, int status) {
        this.updateSystemList();
    }

    @Override
    public void managerSystemAdded(String systemId) {
        this.updateSystemList();
    }

    @Override
    public void managerSystemRemoved(String systemId) {
        this.updateSystemList();
    }

    @Override
    public void managerSystemStatusChanged(String systemId, int status) {
        this.updateSystemList();
    }

    private JTabbedPane getMonitorTabbedPane() {
        if (this.monitorTabbedPane == null) {
            this.monitorTabbedPane = new JTabbedPane();
            this.monitorTabbedPane.setEnabled(true);
            this.monitorTabbedPane.addTab(I18n.text("Status"), null, this.getStatusPanel(), null);
        }
        return this.monitorTabbedPane;
    }

    protected final JTabbedPane getMonitorTabHolder() {
        return this.getMonitorTabbedPane();
    }

    protected final void addMonitorTab(String title, Icon icon, Component component, String tip) {
        this.getMonitorTabbedPane().addTab(title, icon, component, tip);
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            this.statusListenersLabel = new JLabel();
            this.statusListenersLabel.setSize(new Dimension(94, 15));
            this.statusListenersLabel.setText(I18n.text("Status listeners:"));
            this.queueSizeTextLabel = new JLabel();
            this.queueSizeTextLabel.setText(I18n.text("Common queue:"));
            this.queueSizeTextLabel.setLocation(new Point(15, 75));
            this.queueSizeTextLabel.setSize(new Dimension(92, 16));
            this.statusLabel = new JLabel();
            this.statusLabel.setLocation(new Point(15, 15));
            this.statusLabel.setSize(new Dimension(91, 16));
            this.statusLabel.setText(I18n.text("Status (on/off):"));
            this.statusNrSysLabel = new JLabel();
            this.statusNrSysLabel.setText(I18n.text("Nr. systems:"));
            this.statusNrSysLabel.setLocation(new Point(15, 45));
            this.statusNrSysLabel.setSize(new Dimension(91, 16));
            this.statusPanel = new JPanel();
            this.statusPanel.setName("");
            this.commonLastMsgArrivedLabel = new JLabel();
            this.commonLastMsgArrivedLabel.setSize(new Dimension(108, 15));
            this.commonLastMsgArrivedLabel.setText(I18n.text("Last msg arrived:"));
            this.commonLastMsgProcessLabel = new JLabel();
            this.commonLastMsgProcessLabel.setText(I18n.text("Last msg processed:"));
            this.commonLastMsgProcessLabel.setSize(new Dimension(113, 16));
            GroupLayout layout = new GroupLayout(this.statusPanel);
            this.statusPanel.setLayout(layout);
            layout.setAutoCreateGaps(true);
            layout.setAutoCreateContainerGaps(true);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.statusLabel).addComponent(this.getStatusLed(), this.getStatusLed().getWidth(), this.getStatusLed().getWidth(), this.getStatusLed().getWidth())).addGroup(layout.createSequentialGroup().addComponent(this.statusNrSysLabel).addComponent(this.getStatusNrSysTextField(), this.getStatusNrSysTextField().getWidth(), this.getStatusNrSysTextField().getWidth(), Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.queueSizeTextLabel).addComponent(this.getQueueSizeTextField(), this.getQueueSizeTextField().getWidth(), this.getQueueSizeTextField().getWidth(), Short.MAX_VALUE).addComponent(this.getQueueSizeStatusLed(), this.getQueueSizeStatusLed().getWidth(), this.getQueueSizeStatusLed().getWidth(), this.getQueueSizeStatusLed().getWidth()).addComponent(this.getQueueClearButton(), this.getQueueClearButton().getWidth(), this.getQueueClearButton().getWidth(), this.getQueueClearButton().getWidth())).addGroup(layout.createSequentialGroup().addComponent(this.getStartCommButton(), this.getStartCommButton().getWidth(), this.getStartCommButton().getWidth(), this.getStartCommButton().getWidth()).addComponent(this.getStopCommButton(), this.getStopCommButton().getWidth(), this.getStopCommButton().getWidth(), this.getStopCommButton().getWidth()).addComponent(this.getSmallSeparator(), this.getSmallSeparator().getWidth(), this.getSmallSeparator().getWidth(), this.getSmallSeparator().getWidth()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusListenersLabel).addComponent(this.getStatusListenersSizeTextField())))).addComponent(this.getBigSeparator(), this.getBigSeparator().getWidth(), this.getBigSeparator().getWidth(), this.getBigSeparator().getWidth()).addComponent(this.getStatusSysListScrollPane(), this.getStatusSysListScrollPane().getWidth(), this.getStatusSysListScrollPane().getWidth(), Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.commonLastMsgArrivedLabel).addComponent(this.getCommonArrivalTimeText()).addComponent(this.getCommonFreqArrivalTextField()).addComponent(this.getCommonArrivalTxRxTimeNanosText())).addGroup(layout.createSequentialGroup().addComponent(this.commonLastMsgProcessLabel).addComponent(this.getCommonProcessTimeTextField()).addComponent(this.getCommonFreqProcessTextField()).addComponent(this.getCommonProcessTxRxTimeNanosText())).addComponent(this.getSystemCommsPanel(), this.getSystemCommsPanel().getWidth(), this.getSystemCommsPanel().getWidth(), Short.MAX_VALUE).addComponent(this.getAddSystemCommPanel()));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.statusLabel).addComponent(this.getStatusLed())).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.statusNrSysLabel).addComponent(this.getStatusNrSysTextField(), this.getStatusNrSysTextField().getHeight(), this.getStatusNrSysTextField().getHeight(), this.getStatusNrSysTextField().getHeight())).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.queueSizeTextLabel).addComponent(this.getQueueSizeTextField(), this.getQueueSizeTextField().getHeight(), this.getQueueSizeTextField().getHeight(), this.getQueueSizeTextField().getHeight()).addComponent(this.getQueueSizeStatusLed(), this.getQueueSizeStatusLed().getHeight(), this.getQueueSizeStatusLed().getHeight(), this.getQueueSizeStatusLed().getHeight()).addComponent(this.getQueueClearButton(), this.getQueueClearButton().getHeight(), this.getQueueClearButton().getHeight(), this.getQueueClearButton().getHeight())).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.getStartCommButton(), this.getStartCommButton().getHeight(), this.getStartCommButton().getHeight(), this.getStartCommButton().getHeight()).addComponent(this.getStopCommButton(), this.getStopCommButton().getHeight(), this.getStopCommButton().getHeight(), this.getStopCommButton().getHeight()).addComponent(this.getSmallSeparator()).addGroup(layout.createSequentialGroup().addComponent(this.statusListenersLabel).addComponent(this.getStatusListenersSizeTextField(), this.getStatusListenersSizeTextField().getHeight(), this.getStatusListenersSizeTextField().getHeight(), this.getStatusListenersSizeTextField().getHeight())))).addComponent(this.getBigSeparator(), GroupLayout.Alignment.CENTER).addComponent(this.getStatusSysListScrollPane())).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.commonLastMsgArrivedLabel).addComponent(this.getCommonArrivalTimeText()).addComponent(this.getCommonFreqArrivalTextField()).addComponent(this.getCommonArrivalTxRxTimeNanosText())).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.commonLastMsgProcessLabel).addComponent(this.getCommonProcessTimeTextField()).addComponent(this.getCommonFreqProcessTextField()).addComponent(this.getCommonProcessTxRxTimeNanosText())).addComponent(this.getSystemCommsPanel(), this.getSystemCommsPanel().getHeight(), this.getSystemCommsPanel().getHeight(), Short.MAX_VALUE).addComponent(this.getAddSystemCommPanel()));
            layout.linkSize(0, this.statusLabel, this.statusNrSysLabel, this.queueSizeTextLabel);
            layout.linkSize(0, this.commonLastMsgArrivedLabel, this.commonLastMsgProcessLabel);
            layout.linkSize(1, this.getCommonArrivalTimeText(), this.getCommonProcessTimeTextField(), this.getCommonFreqArrivalTextField(), this.getCommonFreqProcessTextField(), this.getCommonArrivalTxRxTimeNanosText(), this.getCommonProcessTxRxTimeNanosText());
        }
        return this.statusPanel;
    }

    private JTextField getStatusNrSysTextField() {
        if (this.statusNrSysTextField == null) {
            this.statusNrSysTextField = new JTextField();
            this.statusNrSysTextField.setBounds(new Rectangle(120, 45, 48, 20));
            this.statusNrSysTextField.setEditable(false);
        }
        return this.statusNrSysTextField;
    }

    private StatusLed getStatusLed() {
        if (this.statusLed == null) {
            this.statusLed = new StatusLed();
            this.statusLed.setBounds(new Rectangle(120, 15, 14, 14));
            this.statusLed.setLevel((short)-1);
            this.statusLed.made2LevelIndicator();
        }
        return this.statusLed;
    }

    private StatusLed getQueueSizeStatusLed() {
        if (this.queueSizeStatusLed == null) {
            this.queueSizeStatusLed = new StatusLed();
            this.queueSizeStatusLed.setSize(new Dimension(14, 14));
            this.queueSizeStatusLed.setLevel((short)-1);
            this.queueSizeStatusLed.made2LevelIndicator();
        }
        return this.queueSizeStatusLed;
    }

    private StatusLed getSysQueueSizeStatusLed() {
        if (this.sysQueueSizeStatusLed == null) {
            this.sysQueueSizeStatusLed = new StatusLed();
            this.sysQueueSizeStatusLed.setSize(new Dimension(14, 14));
            this.sysQueueSizeStatusLed.setLevel((short)-2);
            this.sysQueueSizeStatusLed.made2LevelIndicator();
        }
        return this.sysQueueSizeStatusLed;
    }

    private JList<String> getStatusSysList() {
        if (this.statusSysList == null) {
            this.statusSysListModel = new DefaultListModel();
            this.statusSysList = new JList<String>(this.statusSysListModel);
            this.statusSysList.setSelectionMode(0);
            this.statusSysList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    String sid = (String)BaseAbstractCommsMonitorPanel.this.statusSysList.getSelectedValue();
                    try {
                        BaseAbstractCommsMonitorPanel.this.selectedSystem = BaseAbstractCommsMonitorPanel.this.translateStringIdToId(BaseAbstractCommsMonitorPanel.this.convertStringIdNameToStringId(sid));
                    }
                    catch (NumberFormatException e1) {
                        BaseAbstractCommsMonitorPanel.this.selectedSystem = null;
                    }
                }
            });
        }
        return this.statusSysList;
    }

    private JScrollPane getStatusSysListScrollPane() {
        if (this.statusSysListScrollPane == null) {
            this.statusSysListScrollPane = new JScrollPane();
            this.statusSysListScrollPane.setBounds(new Rectangle(220, 14, 151, 129));
            this.statusSysListScrollPane.setViewportView(this.getStatusSysList());
        }
        return this.statusSysListScrollPane;
    }

    private JTextField getQueueSizeTextField() {
        if (this.queueSizeTextField == null) {
            this.queueSizeTextField = new JTextField();
            this.queueSizeTextField.setSize(new Dimension(48, 20));
            this.queueSizeTextField.setEditable(false);
            this.queueSizeTextField.setLocation(new Point(120, 75));
        }
        return this.queueSizeTextField;
    }

    protected JPanel getSystemCommsPanel() {
        if (this.systemCommsPanel == null) {
            this.activeListenerNameLabel = new JLabel();
            this.activeListenerNameLabel.setText("");
            this.activeListenerNameLabel.setLocation(new Point(99, 33));
            this.activeListenerNameLabel.setSize(new Dimension(245, 16));
            this.sysLastMsgArrivedLabel = new JLabel();
            this.sysLastMsgArrivedLabel.setLocation(new Point(14, 58));
            this.sysLastMsgArrivedLabel.setSize(new Dimension(108, 15));
            this.sysLastMsgArrivedLabel.setText(I18n.text("Last msg arrived:"));
            this.sysListenersSizeLabel = new JLabel();
            this.sysListenersSizeLabel.setLocation(new Point(189, 109));
            this.sysListenersSizeLabel.setSize(new Dimension(72, 15));
            this.sysListenersSizeLabel.setText(I18n.text("Listeners:"));
            this.sysTitleLabel = new JLabel();
            this.sysTitleLabel.setLocation(new Point(13, 11));
            this.sysTitleLabel.setSize(new Dimension(65, 16));
            this.sysTitleLabel.setText("<html><b>" + I18n.text("System:"));
            this.sysLastMsgProcessLabel = new JLabel();
            this.sysLastMsgProcessLabel.setText(I18n.text("Last msg processed:"));
            this.sysLastMsgProcessLabel.setLocation(new Point(14, 81));
            this.sysLastMsgProcessLabel.setSize(new Dimension(113, 16));
            this.sysNameLabel = new JLabel();
            this.sysNameLabel.setText("");
            this.sysNameLabel.setLocation(new Point(225, 11));
            this.sysNameLabel.setSize(new Dimension(119, 16));
            this.sysIDLabel = new JLabel();
            this.sysIDLabel.setText("");
            this.sysIDLabel.setLocation(new Point(97, 11));
            this.sysIDLabel.setSize(new Dimension(110, 16));
            this.sysActiveLabel = new JLabel();
            this.sysActiveLabel.setLocation(new Point(13, 31));
            this.sysActiveLabel.setSize(new Dimension(51, 16));
            this.sysActiveLabel.setText(I18n.text("Activity:"));
            this.sysQueueSizeLabel = new JLabel();
            this.sysQueueSizeLabel.setText(I18n.text("Queue size:"));
            this.sysQueueSizeLabel.setLocation(new Point(14, 105));
            this.sysQueueSizeLabel.setSize(new Dimension(83, 16));
            this.systemCommsPanel = new JPanel();
            this.systemCommsPanel.setBorder(BorderFactory.createLineBorder(SystemColor.windowBorder, 1));
            this.systemCommsPanel.setLocation(new Point(15, 148));
            this.systemCommsPanel.setSize(new Dimension(355, 131));
            GroupLayout layout = new GroupLayout(this.systemCommsPanel);
            this.systemCommsPanel.setLayout(layout);
            layout.setAutoCreateGaps(true);
            layout.setAutoCreateContainerGaps(true);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.sysTitleLabel).addComponent(this.sysIDLabel, -1, -1, Short.MAX_VALUE).addComponent(this.sysNameLabel, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.sysActiveLabel).addComponent(this.getSysActiveLed(), this.getSysActiveLed().getWidth(), this.getSysActiveLed().getWidth(), this.getSysActiveLed().getWidth()).addComponent(this.activeListenerNameLabel)).addGroup(layout.createSequentialGroup().addComponent(this.sysLastMsgArrivedLabel).addComponent(this.getSysArrivalTimeText()).addComponent(this.getSysFreqArrivalTextField()).addComponent(this.getSysArrivalTxRxTimeNanosTextField())).addGroup(layout.createSequentialGroup().addComponent(this.sysLastMsgProcessLabel).addComponent(this.getSysProcessTimeTextField()).addComponent(this.getSysFreqProcessTextField()).addComponent(this.getSysProcessTxRxTimeNanosTextField())).addGroup(layout.createSequentialGroup().addComponent(this.sysQueueSizeLabel).addComponent(this.getSysQueueSizeTextField()).addComponent(this.getSysQueueSizeStatusLed(), this.getSysQueueSizeStatusLed().getWidth(), this.getSysQueueSizeStatusLed().getWidth(), this.getSysQueueSizeStatusLed().getWidth()).addComponent(this.getSysQueueClearButton(), this.getSysQueueClearButton().getWidth(), this.getSysQueueClearButton().getWidth(), this.getSysQueueClearButton().getWidth()).addComponent(this.sysListenersSizeLabel).addComponent(this.getSysListenersSizeTextField())));
            layout.linkSize(0, this.sysTitleLabel, this.sysActiveLabel);
            layout.linkSize(0, this.sysIDLabel, this.sysNameLabel);
            layout.linkSize(0, this.sysLastMsgArrivedLabel, this.sysLastMsgProcessLabel);
            layout.linkSize(0, this.sysQueueSizeLabel, this.sysListenersSizeLabel);
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sysTitleLabel).addComponent(this.sysIDLabel).addComponent(this.sysNameLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sysActiveLabel).addComponent(this.getSysActiveLed(), this.getSysActiveLed().getHeight(), this.getSysActiveLed().getHeight(), this.getSysActiveLed().getHeight()).addComponent(this.activeListenerNameLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sysLastMsgArrivedLabel).addComponent(this.getSysArrivalTimeText(), this.getSysArrivalTimeText().getHeight(), this.getSysArrivalTimeText().getHeight(), this.getSysArrivalTimeText().getHeight()).addComponent(this.getSysFreqArrivalTextField()).addComponent(this.getSysArrivalTxRxTimeNanosTextField(), this.getSysArrivalTxRxTimeNanosTextField().getHeight(), this.getSysArrivalTxRxTimeNanosTextField().getHeight(), this.getSysArrivalTimeText().getHeight())).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sysLastMsgProcessLabel).addComponent(this.getSysProcessTimeTextField()).addComponent(this.getSysFreqProcessTextField()).addComponent(this.getSysProcessTxRxTimeNanosTextField())).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sysQueueSizeLabel).addComponent(this.getSysQueueSizeTextField()).addComponent(this.getSysQueueSizeStatusLed(), this.getSysQueueSizeStatusLed().getHeight(), this.getSysQueueSizeStatusLed().getHeight(), this.getSysQueueSizeStatusLed().getHeight()).addComponent(this.getSysQueueClearButton(), this.getSysQueueClearButton().getHeight(), this.getSysQueueClearButton().getHeight(), this.getSysQueueClearButton().getHeight()).addComponent(this.sysListenersSizeLabel).addComponent(this.getSysListenersSizeTextField())));
            layout.linkSize(1, this.getSysArrivalTimeText(), this.getSysProcessTimeTextField(), this.getSysFreqArrivalTextField(), this.getSysFreqProcessTextField(), this.getSysQueueSizeTextField(), this.getSysListenersSizeTextField(), this.getSysArrivalTxRxTimeNanosTextField(), this.getSysProcessTxRxTimeNanosTextField());
        }
        return this.systemCommsPanel;
    }

    private StatusLed getSysActiveLed() {
        if (this.sysActiveLed == null) {
            this.sysActiveLed = new StatusLed();
            this.sysActiveLed.setBounds(new Rectangle(72, 33, 14, 14));
            this.sysActiveLed.made2LevelIndicator();
        }
        return this.sysActiveLed;
    }

    private JTextField getSysQueueSizeTextField() {
        if (this.sysQueueSizeTextField == null) {
            this.sysQueueSizeTextField = new JTextField();
            this.sysQueueSizeTextField.setLocation(new Point(113, 105));
            this.sysQueueSizeTextField.setEditable(false);
            this.sysQueueSizeTextField.setSize(new Dimension(53, 20));
        }
        return this.sysQueueSizeTextField;
    }

    private JTextField getSysProcessTimeTextField() {
        if (this.sysProcessTimeTextField == null) {
            this.sysProcessTimeTextField = new JTextField();
            this.sysProcessTimeTextField.setBounds(new Rectangle(137, 81, 127, 20));
            this.sysProcessTimeTextField.setEditable(false);
        }
        return this.sysProcessTimeTextField;
    }

    public JTextField getSysProcessTxRxTimeNanosTextField() {
        if (this.sysProcessTxRxTimeNanosTextField == null) {
            this.sysProcessTxRxTimeNanosTextField = new JTextField();
            this.sysProcessTxRxTimeNanosTextField.setBounds(new Rectangle(137, 81, 127, 20));
            this.sysProcessTxRxTimeNanosTextField.setEditable(false);
            this.sysProcessTxRxTimeNanosTextField.setToolTipText("<html>" + I18n.text("The time difference between reception and handling time"));
        }
        return this.sysProcessTxRxTimeNanosTextField;
    }

    private JTextField getCommonProcessTimeTextField() {
        if (this.commonProcessTimeTextField == null) {
            this.commonProcessTimeTextField = new JTextField();
            this.commonProcessTimeTextField.setBounds(new Rectangle(137, 81, 127, 20));
            this.commonProcessTimeTextField.setEditable(false);
        }
        return this.commonProcessTimeTextField;
    }

    public JTextField getCommonProcessTxRxTimeNanosText() {
        if (this.commonProcessTxRxTimeNanosTextField == null) {
            this.commonProcessTxRxTimeNanosTextField = new JTextField();
            this.commonProcessTxRxTimeNanosTextField.setBounds(new Rectangle(137, 81, 127, 20));
            this.commonProcessTxRxTimeNanosTextField.setEditable(false);
            this.commonProcessTxRxTimeNanosTextField.setToolTipText("<html>" + I18n.text("The time difference between reception and handling time"));
        }
        return this.commonProcessTxRxTimeNanosTextField;
    }

    private JRoundButton getStartCommButton() {
        if (this.startCommButton == null) {
            this.startCommButton = new JRoundButton();
            this.startCommButton.setToolTipText(I18n.textf("Start %commName comms.", this.getCommName()));
            this.startCommButton.setSize(new Dimension(34, 34));
            this.startCommButton.setLocation(new Point(16, 103));
            this.startCommButton.setIcon(this.getOnIcon());
            this.startCommButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BaseAbstractCommsMonitorPanel.this.startCommButton.setEnabled(false);
                    NeptusLog.action().warn((Object)("Start comm. manager '" + BaseAbstractCommsMonitorPanel.this.getCommName() + "' request"));
                    SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

                        @Override
                        protected Boolean doInBackground() throws Exception {
                            return ((CommBaseManager)BaseAbstractCommsMonitorPanel.this.getCommManager()).start();
                        }

                        @Override
                        protected void done() {
                            try {
                                this.get();
                            }
                            catch (Exception e) {
                                NeptusLog.pub().error((Object)e);
                            }
                            BaseAbstractCommsMonitorPanel.this.startCommButton.setEnabled(true);
                        }
                    };
                    worker.execute();
                }
            });
        }
        return this.startCommButton;
    }

    private JRoundButton getStopCommButton() {
        if (this.stopCommButton == null) {
            this.stopCommButton = new JRoundButton();
            this.stopCommButton.setToolTipText(I18n.textf("Stop %commName comms.", this.getCommName()));
            this.stopCommButton.setSize(new Dimension(34, 34));
            this.stopCommButton.setLocation(new Point(56, 103));
            this.stopCommButton.setIcon(this.getOffIcon());
            this.stopCommButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BaseAbstractCommsMonitorPanel.this.stopCommButton.setEnabled(false);
                    NeptusLog.action().warn((Object)("Stop comm. manager '" + BaseAbstractCommsMonitorPanel.this.getCommName() + "' request"));
                    SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

                        @Override
                        protected Boolean doInBackground() throws Exception {
                            return ((CommBaseManager)BaseAbstractCommsMonitorPanel.this.getCommManager()).stop();
                        }

                        @Override
                        protected void done() {
                            try {
                                this.get();
                            }
                            catch (Exception e) {
                                NeptusLog.pub().error((Object)e);
                            }
                            BaseAbstractCommsMonitorPanel.this.stopCommButton.setEnabled(true);
                        }
                    };
                    worker.execute();
                }
            });
        }
        return this.stopCommButton;
    }

    private JRoundButton getQueueClearButton() {
        if (this.queueClearButton == null) {
            this.queueClearButton = new JRoundButton();
            this.queueClearButton.setToolTipText(I18n.text("Clear queue"));
            this.queueClearButton.setSize(new Dimension(20, 20));
            this.queueClearButton.setIcon(CLEAR_ICON);
            this.queueClearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BaseAbstractCommsMonitorPanel.this.queueClearButton.setEnabled(false);
                    SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            ((CommonCommBaseImplementation)BaseAbstractCommsMonitorPanel.this.getCommManager()).clearMsgQueue();
                            return null;
                        }

                        @Override
                        protected void done() {
                            try {
                                this.get();
                            }
                            catch (Exception e) {
                                NeptusLog.pub().error((Object)e);
                            }
                            BaseAbstractCommsMonitorPanel.this.queueClearButton.setEnabled(true);
                        }
                    };
                    worker.execute();
                }
            });
        }
        return this.queueClearButton;
    }

    private JRoundButton getSysQueueClearButton() {
        if (this.sysQueueClearButton == null) {
            this.sysQueueClearButton = new JRoundButton();
            this.sysQueueClearButton.setToolTipText(I18n.text("Clear queue"));
            this.sysQueueClearButton.setSize(new Dimension(20, 20));
            this.sysQueueClearButton.setIcon(CLEAR_ICON);
            this.sysQueueClearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BaseAbstractCommsMonitorPanel.this.sysQueueClearButton.setEnabled(false);
                    SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            Object sman = BaseAbstractCommsMonitorPanel.this.getCommManager();
                            SystemCommBaseInfo vci = (SystemCommBaseInfo)((CommBaseManager)sman).getCommInfo().get(BaseAbstractCommsMonitorPanel.this.selectedSystem);
                            if (vci == null) {
                                return null;
                            }
                            vci.clearMsgQueue();
                            return null;
                        }

                        @Override
                        protected void done() {
                            try {
                                this.get();
                            }
                            catch (Exception e) {
                                NeptusLog.pub().error((Object)e);
                            }
                            BaseAbstractCommsMonitorPanel.this.sysQueueClearButton.setEnabled(true);
                        }
                    };
                    worker.execute();
                }
            });
        }
        return this.sysQueueClearButton;
    }

    private JPanel getAddSystemCommPanel() {
        if (this.addSystemCommPanel == null) {
            this.addSystemCommPanel = new JPanel();
            this.addSystemCommPanel.setLayout(new FlowLayout());
            this.addSystemCommPanel.setBorder(BorderFactory.createLineBorder(SystemColor.windowBorder, 1));
            this.addSystemCommPanel.setSize(new Dimension(355, 42));
            this.addSystemCommPanel.setLocation(new Point(15, 284));
        }
        return this.addSystemCommPanel;
    }

    protected final void addNewActivateCommPanel(JPanel newComponent) {
        GroupLayout grpL = (GroupLayout)this.getStatusPanel().getLayout();
        grpL.replace(this.getAddSystemCommPanel(), newComponent);
        this.addSystemCommPanel = newComponent;
        newComponent.setBorder(BorderFactory.createLineBorder(SystemColor.windowBorder, 1));
    }

    private JSeparator getBigSeparator() {
        if (this.bigSeparator == null) {
            this.bigSeparator = new JSeparator();
            this.bigSeparator.setBounds(new Rectangle(203, 11, 9, 131));
            this.bigSeparator.setBackground(SystemColor.windowBorder);
            this.bigSeparator.setOrientation(1);
        }
        return this.bigSeparator;
    }

    private JSeparator getSmallSeparator() {
        if (this.smallSeparator == null) {
            this.smallSeparator = new JSeparator();
            this.smallSeparator.setBounds(new Rectangle(96, 98, 10, 43));
            this.smallSeparator.setOrientation(1);
        }
        return this.smallSeparator;
    }

    private JOutlookBar getTopOutlookBar() {
        if (this.topOutlookBar == null) {
            this.topOutlookBar = new JOutlookBar();
            this.topOutlookBar.setPreferredSize(new Dimension(396, 411));
            this.topOutlookBar.addTab(I18n.textf("%commName Monitor", this.getCommName()), (Icon)this.getOnIcon(), (Component)this.getMonitorTabbedPane(), null);
        }
        return this.topOutlookBar;
    }

    protected final JOutlookBar getTopTabHolder() {
        return this.getTopOutlookBar();
    }

    protected abstract String getCommName();

    protected final void addTopTab(String title, Icon icon, Component component, String tip) {
        this.getTopOutlookBar().addTab(title, icon, component, tip);
    }

    private JTextField getSysFreqProcessTextField() {
        if (this.sysFreqProcessTextField == null) {
            this.sysFreqProcessTextField = new JTextField();
            this.sysFreqProcessTextField.setEditable(false);
            this.sysFreqProcessTextField.setLocation(new Point(269, 81));
            this.sysFreqProcessTextField.setSize(new Dimension(77, 19));
        }
        return this.sysFreqProcessTextField;
    }

    private JTextField getCommonFreqProcessTextField() {
        if (this.commonFreqProcessTextField == null) {
            this.commonFreqProcessTextField = new JTextField();
            this.commonFreqProcessTextField.setEditable(false);
            this.commonFreqProcessTextField.setLocation(new Point(269, 81));
            this.commonFreqProcessTextField.setSize(new Dimension(77, 19));
        }
        return this.commonFreqProcessTextField;
    }

    private JTextField getSysListenersSizeTextField() {
        if (this.sysListenersSizeTextField == null) {
            this.sysListenersSizeTextField = new JTextField();
            this.sysListenersSizeTextField.setEditable(false);
            this.sysListenersSizeTextField.setLocation(new Point(269, 105));
            this.sysListenersSizeTextField.setSize(new Dimension(75, 19));
        }
        return this.sysListenersSizeTextField;
    }

    private JTextField getStatusListenersSizeTextField() {
        if (this.statusListenersSizeTextField == null) {
            this.statusListenersSizeTextField = new JTextField();
            this.statusListenersSizeTextField.setBounds(new Rectangle(124, 123, 55, 19));
            this.statusListenersSizeTextField.setEditable(false);
        }
        return this.statusListenersSizeTextField;
    }

    private JTextField getSysArrivalTimeText() {
        if (this.sysArrivalTimeText == null) {
            this.sysArrivalTimeText = new JTextField();
            this.sysArrivalTimeText.setEditable(false);
            this.sysArrivalTimeText.setSize(new Dimension(127, 20));
            this.sysArrivalTimeText.setLocation(new Point(137, 59));
        }
        return this.sysArrivalTimeText;
    }

    public JTextField getSysArrivalTxRxTimeNanosTextField() {
        if (this.sysArrivalTxRxTimeNanosTextField == null) {
            this.sysArrivalTxRxTimeNanosTextField = new JTextField();
            this.sysArrivalTxRxTimeNanosTextField.setEditable(false);
            this.sysArrivalTxRxTimeNanosTextField.setToolTipText(I18n.text("<html>The time difference between sent and reception time<br>(clock difference may invalidate it)"));
            this.sysArrivalTxRxTimeNanosTextField.setSize(new Dimension(127, 20));
            this.sysArrivalTxRxTimeNanosTextField.setLocation(new Point(137, 59));
        }
        return this.sysArrivalTxRxTimeNanosTextField;
    }

    private JTextField getCommonArrivalTimeText() {
        if (this.commonArrivalTimeText == null) {
            this.commonArrivalTimeText = new JTextField();
            this.commonArrivalTimeText.setEditable(false);
            this.commonArrivalTimeText.setSize(new Dimension(127, 20));
            this.commonArrivalTimeText.setLocation(new Point(137, 59));
        }
        return this.commonArrivalTimeText;
    }

    public JTextField getCommonArrivalTxRxTimeNanosText() {
        if (this.commonArrivalTxRxTimeNanosTextField == null) {
            this.commonArrivalTxRxTimeNanosTextField = new JTextField();
            this.commonArrivalTxRxTimeNanosTextField.setEditable(false);
            this.commonArrivalTxRxTimeNanosTextField.setToolTipText(I18n.text("<html>The time difference between sent and reception time<br>(clock difference may invalidate it)"));
            this.commonArrivalTxRxTimeNanosTextField.setSize(new Dimension(127, 20));
            this.commonArrivalTxRxTimeNanosTextField.setLocation(new Point(137, 59));
        }
        return this.commonArrivalTxRxTimeNanosTextField;
    }

    private JTextField getSysFreqArrivalTextField() {
        if (this.sysFreqArrivalTextField == null) {
            this.sysFreqArrivalTextField = new JTextField();
            this.sysFreqArrivalTextField.setEditable(false);
            this.sysFreqArrivalTextField.setLocation(new Point(269, 59));
            this.sysFreqArrivalTextField.setSize(new Dimension(77, 19));
        }
        return this.sysFreqArrivalTextField;
    }

    private JTextField getCommonFreqArrivalTextField() {
        if (this.commonFreqArrivalTextField == null) {
            this.commonFreqArrivalTextField = new JTextField();
            this.commonFreqArrivalTextField.setEditable(false);
            this.commonFreqArrivalTextField.setLocation(new Point(269, 59));
            this.commonFreqArrivalTextField.setSize(new Dimension(77, 19));
        }
        return this.commonFreqArrivalTextField;
    }
}

